/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.meta.AdjustableDatesMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface AdjustableDates
extends RosettaModelObject,
GlobalKey {
    public static final AdjustableDatesMeta metaData = new AdjustableDatesMeta();

    public AdjustableDates build();

    public AdjustableDatesBuilder toBuilder();

    public List<? extends FieldWithMetaDate> getAdjustedDate();

    public BusinessDayAdjustments getDateAdjustments();

    public MetaFields getMeta();

    public List<Date> getUnadjustedDate();

    default public RosettaMetaData<? extends AdjustableDates> metaData() {
        return metaData;
    }

    public static AdjustableDatesBuilder builder() {
        return new AdjustableDatesBuilderImpl();
    }

    default public Class<? extends AdjustableDates> getType() {
        return AdjustableDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, this.getUnadjustedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustedDate"), processor, FieldWithMetaDate.class, this.getAdjustedDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class AdjustableDatesBuilderImpl
    implements AdjustableDatesBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<FieldWithMetaDate.FieldWithMetaDateBuilder> adjustedDate = new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>();
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected MetaFields.MetaFieldsBuilder meta;
        protected List<Date> unadjustedDate = new ArrayList<Date>();

        @Override
        public List<? extends FieldWithMetaDate.FieldWithMetaDateBuilder> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateAdjustedDate(int _index) {
            if (this.adjustedDate == null) {
                this.adjustedDate = new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>();
            }
            return (FieldWithMetaDate.FieldWithMetaDateBuilder)this.getIndex(this.adjustedDate, _index, () -> {
                FieldWithMetaDate.FieldWithMetaDateBuilder newAdjustedDate = FieldWithMetaDate.builder();
                return newAdjustedDate;
            });
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public List<Date> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate adjustedDate) {
            if (adjustedDate != null) {
                this.adjustedDate.add(adjustedDate.toBuilder());
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate adjustedDate, int _idx) {
            this.getIndex(this.adjustedDate, _idx, () -> adjustedDate.toBuilder());
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(Date adjustedDate) {
            this.getOrCreateAdjustedDate(-1).setValue(adjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(Date adjustedDate, int _idx) {
            this.getOrCreateAdjustedDate(_idx).setValue(adjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(List<? extends FieldWithMetaDate> adjustedDates) {
            if (adjustedDates != null) {
                for (FieldWithMetaDate fieldWithMetaDate : adjustedDates) {
                    this.adjustedDate.add(fieldWithMetaDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder setAdjustedDate(List<? extends FieldWithMetaDate> adjustedDates) {
            this.adjustedDate = adjustedDates == null ? new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>() : (List)adjustedDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(List<? extends Date> adjustedDates) {
            if (adjustedDates != null) {
                for (Date date : adjustedDates) {
                    this.addAdjustedDateValue(date);
                }
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder setAdjustedDateValue(List<? extends Date> adjustedDates) {
            this.adjustedDate.clear();
            if (adjustedDates != null) {
                adjustedDates.forEach(this::addAdjustedDateValue);
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments dateAdjustments) {
            this.dateAdjustments = dateAdjustments == null ? null : dateAdjustments.toBuilder();
            return this;
        }

        @Override
        public AdjustableDatesBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(Date unadjustedDate) {
            if (unadjustedDate != null) {
                this.unadjustedDate.add(unadjustedDate);
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(Date unadjustedDate, int _idx) {
            this.getIndex(this.unadjustedDate, _idx, () -> unadjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(List<? extends Date> unadjustedDates) {
            if (unadjustedDates != null) {
                for (Date date : unadjustedDates) {
                    this.unadjustedDate.add(date);
                }
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder setUnadjustedDate(List<? extends Date> unadjustedDates) {
            this.unadjustedDate = unadjustedDates == null ? new ArrayList<Date>() : (List)unadjustedDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AdjustableDates build() {
            return new AdjustableDatesImpl(this);
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder prune() {
            this.adjustedDate = this.adjustedDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedDate() != null && !this.getAdjustedDate().isEmpty()) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            return this.getUnadjustedDate() != null && !this.getUnadjustedDate().isEmpty();
        }

        public AdjustableDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustableDatesBuilder o = (AdjustableDatesBuilder)other;
            merger.mergeRosetta(this.getAdjustedDate(), o.getAdjustedDate(), this::getOrCreateAdjustedDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic(this.getUnadjustedDate(), o.getUnadjustedDate(), this::addUnadjustedDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDatesBuilder {adjustedDate=" + this.adjustedDate + ", dateAdjustments=" + this.dateAdjustments + ", meta=" + this.meta + ", unadjustedDate=" + this.unadjustedDate + '}';
        }
    }

    public static class AdjustableDatesImpl
    implements AdjustableDates {
        private final List<? extends FieldWithMetaDate> adjustedDate;
        private final BusinessDayAdjustments dateAdjustments;
        private final MetaFields meta;
        private final List<Date> unadjustedDate;

        protected AdjustableDatesImpl(AdjustableDatesBuilder builder) {
            this.adjustedDate = Optional.ofNullable(builder.getAdjustedDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.unadjustedDate = Optional.ofNullable(builder.getUnadjustedDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        public List<? extends FieldWithMetaDate> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public List<Date> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        public AdjustableDates build() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            AdjustableDatesBuilder builder = AdjustableDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustableDatesBuilder builder) {
            Optional.ofNullable(this.getAdjustedDate()).ifPresent(builder::setAdjustedDate);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getUnadjustedDate()).ifPresent(builder::setUnadjustedDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDates {adjustedDate=" + this.adjustedDate + ", dateAdjustments=" + this.dateAdjustments + ", meta=" + this.meta + ", unadjustedDate=" + this.unadjustedDate + '}';
        }
    }

    public static interface AdjustableDatesBuilder
    extends AdjustableDates,
    RosettaModelObjectBuilder {
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateAdjustedDate(int var1);

        public List<? extends FieldWithMetaDate.FieldWithMetaDateBuilder> getAdjustedDate();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate var1);

        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate var1, int var2);

        public AdjustableDatesBuilder addAdjustedDateValue(Date var1);

        public AdjustableDatesBuilder addAdjustedDateValue(Date var1, int var2);

        public AdjustableDatesBuilder addAdjustedDate(List<? extends FieldWithMetaDate> var1);

        public AdjustableDatesBuilder setAdjustedDate(List<? extends FieldWithMetaDate> var1);

        public AdjustableDatesBuilder addAdjustedDateValue(List<? extends Date> var1);

        public AdjustableDatesBuilder setAdjustedDateValue(List<? extends Date> var1);

        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public AdjustableDatesBuilder setMeta(MetaFields var1);

        public AdjustableDatesBuilder addUnadjustedDate(Date var1);

        public AdjustableDatesBuilder addUnadjustedDate(Date var1, int var2);

        public AdjustableDatesBuilder addUnadjustedDate(List<? extends Date> var1);

        public AdjustableDatesBuilder setUnadjustedDate(List<? extends Date> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, this.getUnadjustedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustedDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getAdjustedDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public AdjustableDatesBuilder prune();
    }
}

