/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.redis.FF4JRedisConstants;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import redis.clients.jedis.Jedis;

public class FeatureStoreRedis
extends AbstractFeatureStore
implements FF4JRedisConstants {
    protected String redisHost = "localhost";
    protected int redisport = 6379;
    protected int timeToLive = 900000000;
    protected Jedis jedis;

    public FeatureStoreRedis() {
        this.jedis = new Jedis(this.redisHost, this.redisport);
    }

    public FeatureStoreRedis(String xmlFeaturesfFile) {
        this();
        this.importFeaturesFromXmlFile(xmlFeaturesfFile);
    }

    public FeatureStoreRedis(String host, int port) {
        this.redisHost = host;
        this.redisport = port;
        this.jedis = new Jedis(host, port);
    }

    public FeatureStoreRedis(String host, int port, String xmlFeaturesfFile) {
        this(host, port);
        this.importFeaturesFromXmlFile(xmlFeaturesfFile);
    }

    public boolean exist(String uid) {
        Util.assertParamNotNull((String)uid, (String)"Feature identifier");
        return this.jedis.exists("FF4J_" + uid);
    }

    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        return FeatureJsonParser.parseFeature((String)this.jedis.get("FF4J_" + uid));
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        this.jedis.set("FF4J_" + fp.getUid(), fp.toJson());
        this.jedis.persist("FF4J_" + fp.getUid());
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.jedis.set("FF4J_" + fp.getUid(), fp.toJson());
        this.jedis.persist("FF4J_" + fp.getUid());
    }

    public Map<String, Feature> readAll() {
        Set myKeys = this.jedis.keys("FF4J_*");
        HashMap<String, Feature> myMap = new HashMap<String, Feature>();
        if (myKeys != null) {
            for (String key : myKeys) {
                key = key.replaceAll("FF4J_", "");
                myMap.put(key, this.read(key));
            }
        }
        return myMap;
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        this.jedis.del("FF4J_" + fpId);
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamNotNull((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamNotNull((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (String uid : features.keySet()) {
            if (!groupName.equals(features.get(uid).getGroup())) continue;
            group.put(uid, features.get(uid));
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (String uid : features.keySet()) {
            if (!groupName.equals(features.get(uid).getGroup())) continue;
            group.put(uid, features.get(uid));
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (String uid : features.keySet()) {
            features.get(uid).enable();
            this.update(features.get(uid));
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (String uid : features.keySet()) {
            features.get(uid).disable();
            this.update(features.get(uid));
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (String uid : features.keySet()) {
            groups.add(features.get(uid).getGroup());
        }
        groups.remove(null);
        return groups;
    }

    public boolean isCached() {
        return false;
    }

    public String getCacheProvider() {
        return null;
    }

    public String getCachedTargetStore() {
        return null;
    }
}

