/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.Set;
import org.ff4j.cache.FeatureCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.redis.FF4JRedisConstants;
import org.ff4j.utils.json.FeatureJsonParser;
import redis.clients.jedis.Jedis;

public class FeatureCacheProviderRedis
implements FeatureCacheManager,
FF4JRedisConstants {
    protected String redisHost = "localhost";
    protected int redisport = 6379;
    protected int timeToLive = 900000000;
    protected Jedis jedis = new Jedis(this.redisHost, this.redisport);

    public FeatureCacheProviderRedis() {
    }

    public FeatureCacheProviderRedis(String host, int port) {
    }

    public void clear() {
        this.jedis.flushAll();
    }

    public void evict(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        this.jedis.del(uid);
    }

    public void put(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        this.jedis.set(fp.getUid(), fp.toJson());
        this.jedis.expire(fp.getUid(), this.timeToLive);
    }

    public Feature get(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        String value = this.jedis.get(uid);
        if (value != null) {
            return FeatureJsonParser.parseFeature((String)value);
        }
        return null;
    }

    public Set<String> listCachedFeatureNames() {
        return this.jedis.keys("FF4J_*");
    }

    public Object getNativeCache() {
        return this.jedis;
    }

    public String getCacheProviderName() {
        return "REDIS";
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisport() {
        return this.redisport;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }
}

