/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.handler.EsHadoopAbortHandlerException;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.rest.ErrorExtractor;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.bulk.BulkResponse;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteErrorCollector;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteFailure;
import org.elasticsearch.hadoop.rest.bulk.handler.IBulkWriteErrorHandler;
import org.elasticsearch.hadoop.rest.bulk.handler.impl.BulkWriteHandlerLoader;
import org.elasticsearch.hadoop.rest.bulk.handler.impl.HttpRetryHandler;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.util.ArrayUtils;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class BulkProcessor
implements Closeable,
StatsAware {
    private static Log LOG = LogFactory.getLog(BulkProcessor.class);
    private final RestClient restClient;
    private final Resource resource;
    private final Settings settings;
    private final Stats stats = new Stats();
    private final ErrorExtractor errorExtractor;
    private BytesArray ba;
    private TrackingBytesArray data;
    private int dataEntries = 0;
    private int bufferEntriesThreshold;
    private boolean autoFlush = true;
    private int retryLimit;
    private boolean executedBulkWrite = false;
    private boolean hadWriteErrors = false;
    private boolean requiresRefreshAfterBulk = false;
    private List<IBulkWriteErrorHandler> documentBulkErrorHandlers;

    public BulkProcessor(RestClient restClient, Resource resource, Settings settings) {
        this.restClient = restClient;
        this.resource = resource;
        this.settings = settings;
        this.autoFlush = !settings.getBatchFlushManual();
        this.bufferEntriesThreshold = settings.getBatchSizeInEntries();
        this.requiresRefreshAfterBulk = settings.getBatchRefreshAfterWrite();
        int retryCount = settings.getBatchWriteRetryCount();
        int limit = settings.getBatchWriteRetryLimit();
        this.retryLimit = limit < retryCount || retryCount < 0 ? retryCount : limit;
        this.ba = new BytesArray(new byte[settings.getBatchSizeInBytes()], 0);
        this.data = new TrackingBytesArray(this.ba);
        HttpRetryHandler httpRetryHandler = new HttpRetryHandler(settings);
        BulkWriteHandlerLoader handlerLoader = new BulkWriteHandlerLoader();
        handlerLoader.setSettings(settings);
        this.documentBulkErrorHandlers = new ArrayList<IBulkWriteErrorHandler>();
        this.documentBulkErrorHandlers.add(httpRetryHandler);
        this.documentBulkErrorHandlers.addAll(handlerLoader.loadHandlers());
        this.errorExtractor = new ErrorExtractor(settings.getInternalVersionOrThrow());
    }

    public void add(BytesRef payload) {
        if (payload.length() > this.ba.available()) {
            if (this.autoFlush) {
                this.flush();
            } else {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and bulk buffer full; disable manual flush or increase capacity [current size %s]; bailing out", this.ba.capacity()));
            }
        }
        this.data.copyFrom(payload);
        ++this.dataEntries;
        if (this.bufferEntriesThreshold > 0 && this.dataEntries >= this.bufferEntriesThreshold) {
            if (this.autoFlush) {
                this.flush();
            } else if (this.dataEntries > this.bufferEntriesThreshold) {
                throw new EsHadoopIllegalStateException(String.format("Auto-flush disabled and maximum number of entries surpassed; disable manual flush or increase capacity [current size %s]; bailing out", this.bufferEntriesThreshold));
            }
        }
    }

    public BulkResponse tryFlush() {
        boolean trackingArrayExpanded;
        BulkResponse bulkResult;
        block29: {
            bulkResult = null;
            trackingArrayExpanded = false;
            String bulkLoggingID = this.createDebugTxnID();
            try {
                if (this.data.length() > 0) {
                    int totalDocs = this.data.entries();
                    int docsSent = 0;
                    int docsSkipped = 0;
                    int docsAborted = 0;
                    long totalTime = 0L;
                    boolean retryOperation = false;
                    int totalAttempts = 0;
                    long waitTime = 0L;
                    ArrayList<BulkAttempt> retries = new ArrayList<BulkAttempt>();
                    ArrayList<BulkResponse.BulkError> abortErrors = new ArrayList<BulkResponse.BulkError>();
                    do {
                        if (this.retryLimit >= 0 && totalAttempts > this.retryLimit) {
                            throw new EsHadoopException("Executed too many bulk requests without success. Attempted [" + totalAttempts + "] write operations, which exceeds the bulk request retry limit specifiedby [" + "es.batch.write.retry.limit" + "], and found data still not accepted. Perhaps there is an error handler that is not terminating? Bailing out...");
                        }
                        this.initFlushOperation(bulkLoggingID, retryOperation, retries.size(), waitTime);
                        this.debugLog(bulkLoggingID, "Submitting request", new Object[0]);
                        RestClient.BulkActionResponse bar = this.restClient.bulk(this.resource, this.data);
                        this.debugLog(bulkLoggingID, "Response received", new Object[0]);
                        ++totalAttempts;
                        totalTime += bar.getTimeSpent();
                        if (retryOperation) {
                            this.stats.docsRetried += (long)this.data.entries();
                            this.stats.bytesRetried += (long)this.data.length();
                            ++this.stats.bulkRetries;
                            this.stats.bulkRetriesTotalTime += bar.getTimeSpent();
                        }
                        this.executedBulkWrite = true;
                        if (!bar.getEntries().hasNext()) {
                            this.stats.bytesAccepted += (long)this.data.length();
                            this.stats.docsAccepted += (long)this.data.entries();
                            retryOperation = false;
                            bulkResult = BulkResponse.complete(bar.getResponseCode(), totalTime, totalDocs, totalDocs, 0);
                            continue;
                        }
                        int documentNumber = 0;
                        int trackingBytesPosition = 0;
                        ArrayList<BulkAttempt> previousRetries = retries;
                        retries = new ArrayList();
                        ArrayList<BulkAttempt> newDocumentRetries = new ArrayList<BulkAttempt>();
                        BulkWriteErrorCollector errorCollector = new BulkWriteErrorCollector();
                        Iterator<Map> iterator = bar.getEntries();
                        while (iterator.hasNext()) {
                            Map map = iterator.next();
                            Map values2 = (Map)map.values().iterator().next();
                            Integer docStatus = (Integer)values2.get("status");
                            EsHadoopException error = this.errorExtractor.extractError(values2);
                            if (error == null) {
                                this.stats.bytesAccepted += (long)this.data.length(trackingBytesPosition);
                                ++this.stats.docsAccepted;
                                ++docsSent;
                                this.data.remove(trackingBytesPosition);
                            } else {
                                BulkAttempt previousAttempt;
                                int status;
                                BytesArray document = this.data.entry(trackingBytesPosition);
                                int n = status = docStatus == null ? -1 : docStatus;
                                if (previousRetries.isEmpty()) {
                                    previousAttempt = new BulkAttempt(1, documentNumber);
                                } else {
                                    previousAttempt = (BulkAttempt)previousRetries.get(documentNumber);
                                    previousAttempt.attemptNumber++;
                                }
                                ArrayList<String> bulkErrorPassReasons = new ArrayList<String>();
                                BulkWriteFailure failure = new BulkWriteFailure(status, error, document, previousAttempt.attemptNumber, bulkErrorPassReasons);
                                block12: for (IBulkWriteErrorHandler errorHandler : this.documentBulkErrorHandlers) {
                                    HandlerResult result;
                                    try {
                                        result = errorHandler.onError(failure, errorCollector);
                                    }
                                    catch (EsHadoopAbortHandlerException ahe) {
                                        Throwable cause = ahe.getCause();
                                        if (cause != null) {
                                            LOG.error((Object)"Bulk write error handler abort exception caught with underlying cause:", cause);
                                        }
                                        result = HandlerResult.ABORT;
                                        error = ahe;
                                    }
                                    catch (Exception e) {
                                        throw new EsHadoopException("Encountered exception during error handler.", e);
                                    }
                                    switch (result) {
                                        case HANDLED: {
                                            Assert.isTrue(errorCollector.getAndClearMessage() == null, "Found pass message with Handled response. Be sure to return the value returned from pass(String) call.");
                                            if (errorCollector.receivedRetries()) {
                                                byte[] retryDataBuffer = errorCollector.getAndClearRetryValue();
                                                if (retryDataBuffer == null || document.bytes() == retryDataBuffer) {
                                                    retries.add(previousAttempt);
                                                    ++trackingBytesPosition;
                                                    break block12;
                                                }
                                                if (ArrayUtils.sliceEquals(document.bytes(), document.offset(), document.length(), retryDataBuffer, 0, retryDataBuffer.length)) {
                                                    retries.add(previousAttempt);
                                                    ++trackingBytesPosition;
                                                    break block12;
                                                }
                                                BytesRef newEntry = this.validateEditedEntry(retryDataBuffer);
                                                this.data.remove(trackingBytesPosition);
                                                this.data.copyFrom(newEntry);
                                                if (this.ba.available() < newEntry.length()) {
                                                    trackingArrayExpanded = true;
                                                }
                                                previousAttempt.attemptNumber = 0;
                                                newDocumentRetries.add(previousAttempt);
                                                break block12;
                                            }
                                            this.data.remove(trackingBytesPosition);
                                            ++docsSkipped;
                                            break block12;
                                        }
                                        case PASS: {
                                            String reason = errorCollector.getAndClearMessage();
                                            if (reason == null) continue block12;
                                            bulkErrorPassReasons.add(reason);
                                            continue block12;
                                        }
                                        case ABORT: {
                                            errorCollector.getAndClearMessage();
                                            this.data.remove(trackingBytesPosition);
                                            ++docsAborted;
                                            abortErrors.add(new BulkResponse.BulkError(previousAttempt.originalPosition, document, status, error));
                                            break block12;
                                        }
                                        default: {
                                            continue block12;
                                        }
                                    }
                                }
                            }
                            ++documentNumber;
                        }
                        retries.addAll(newDocumentRetries);
                        if (!retries.isEmpty()) {
                            retryOperation = true;
                            waitTime = errorCollector.getDelayTimeBetweenRetries();
                            continue;
                        }
                        retryOperation = false;
                        bulkResult = docsAborted > 0 ? BulkResponse.partial(bar.getResponseCode(), totalTime, totalDocs, docsSent, docsSkipped, docsAborted, abortErrors) : BulkResponse.complete(bar.getResponseCode(), totalTime, totalDocs, docsSent, docsSkipped);
                    } while (retryOperation);
                    this.debugLog(bulkLoggingID, "Completed. [%d] Original Entries. [%d] Attempts. [%d/%d] Docs Sent. [%d/%d] Docs Skipped. [%d/%d] Docs Aborted.", totalDocs, totalAttempts, docsSent, totalDocs, docsSkipped, totalDocs, docsAborted, totalDocs);
                    break block29;
                }
                bulkResult = BulkResponse.complete();
            }
            catch (EsHadoopException ex) {
                this.debugLog(bulkLoggingID, "Failed. %s", ex.getMessage());
                this.hadWriteErrors = true;
                throw ex;
            }
        }
        if (trackingArrayExpanded) {
            this.ba = new BytesArray(new byte[this.settings.getBatchSizeInBytes()], 0);
            this.data = new TrackingBytesArray(this.ba);
        } else {
            this.data.reset();
            this.dataEntries = 0;
        }
        return bulkResult;
    }

    private BytesRef validateEditedEntry(byte[] retryDataBuffer) {
        BytesRef result = new BytesRef();
        byte closeBrace = 125;
        byte newline = 10;
        int newlines = 0;
        for (byte b : retryDataBuffer) {
            if (b != newline) continue;
            ++newlines;
        }
        result.add(retryDataBuffer);
        byte lastByte = retryDataBuffer[retryDataBuffer.length - 1];
        if (lastByte == newline) {
            if (newlines != 2) {
                throw new EsHadoopIllegalArgumentException("Encountered malformed data entry for bulk write retry. Data contains [" + newlines + "] newline characters (\\n) but expected to have [2].");
            }
        } else if (lastByte == closeBrace) {
            if (newlines != 1) {
                throw new EsHadoopIllegalArgumentException("Encountered malformed data entry for bulk write retry. Data contains [" + newlines + "] newline characters (\\n) but expected to have [1].");
            }
            byte[] trailingNewline = new byte[]{newline};
            result.add(trailingNewline);
        }
        return result;
    }

    private void initFlushOperation(String bulkLoggingID, boolean retryOperation, long retriedDocs, long waitTime) {
        if (retryOperation) {
            if (waitTime > 0L) {
                this.debugLog(bulkLoggingID, "Retrying [%d] entries after backing off for [%s] ms", retriedDocs, TimeValue.timeValueMillis(waitTime));
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    this.debugLog(bulkLoggingID, "Thread interrupted - giving up on retrying...", new Object[0]);
                    throw new EsHadoopException("Thread interrupted - giving up on retrying...", e);
                }
            } else {
                this.debugLog(bulkLoggingID, "Retrying [%d] entries immediately (without backoff)", retriedDocs);
            }
        } else {
            this.debugLog(bulkLoggingID, "Sending batch of [%d] bytes/[%s] entries", this.data.length(), this.dataEntries);
        }
    }

    private String createDebugTxnID() {
        if (LOG.isDebugEnabled()) {
            return Integer.toString(this.hashCode()) + Long.toString(System.currentTimeMillis());
        }
        return null;
    }

    private void debugLog(String bulkLoggingID, String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            if (args.length > 0) {
                LOG.info((Object)("Bulk Flush #[" + bulkLoggingID + "]: " + String.format(message, args)));
            } else {
                LOG.info((Object)("Bulk Flush #[" + bulkLoggingID + "]: " + message));
            }
        }
    }

    public void flush() {
        BulkResponse bulk = this.tryFlush();
        if (!bulk.getDocumentErrors().isEmpty()) {
            int maxErrors = 5;
            String header = String.format("Could not write all entries for bulk operation [%s/%s]. Error sample (first [%s] error messages):\n", bulk.getDocumentErrors().size(), bulk.getTotalDocs(), maxErrors);
            StringBuilder message = new StringBuilder(header);
            int i = 0;
            for (BulkResponse.BulkError errors : bulk.getDocumentErrors()) {
                if (i >= maxErrors) break;
                message.append("\t");
                this.appendError(message, errors.getError());
                message.append("\n");
                message.append("\t").append(errors.getDocument().toString()).append("\n");
                ++i;
            }
            message.append("Bailing out...");
            throw new EsHadoopException(message.toString());
        }
    }

    private void appendError(StringBuilder message, Throwable exception) {
        if (exception != null) {
            message.append(exception);
            if (exception.getCause() != null) {
                message.append(';');
                this.appendError(message, exception.getCause());
            }
        }
    }

    @Override
    public void close() {
        try {
            if (!this.hadWriteErrors) {
                this.flush();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Dirty close; ignoring last existing write batch...");
            }
            if (this.requiresRefreshAfterBulk && this.executedBulkWrite) {
                this.restClient.refresh(this.resource);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Refreshing index [%s]", this.resource));
                }
            }
        }
        finally {
            for (IBulkWriteErrorHandler handler : this.documentBulkErrorHandlers) {
                handler.close();
            }
        }
    }

    @Override
    public Stats stats() {
        return new Stats(this.stats);
    }

    private class BulkAttempt {
        private int attemptNumber;
        private int originalPosition;

        public BulkAttempt(int attemptNumber, int originalPosition) {
            this.attemptNumber = attemptNumber;
            this.originalPosition = originalPosition;
        }
    }
}

