/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OsUtil {
    private static final Log LOG;
    public static final String OS_NAME;
    private static final String WINDOWS_PREFIX = "Windows";
    public static final boolean IS_OS_WINDOWS;

    private static boolean osMatches(String osPrefix) {
        return OS_NAME != null && OS_NAME.startsWith(osPrefix);
    }

    private OsUtil() {
    }

    static {
        String osName;
        LOG = LogFactory.getLog(OsUtil.class);
        try {
            osName = System.getProperty("os.name");
        }
        catch (SecurityException ex) {
            LOG.error((Object)"Caught SecurityException reading 'os.name' system property. Defaulting to null.", (Throwable)ex);
            osName = null;
        }
        OS_NAME = osName;
        IS_OS_WINDOWS = OsUtil.osMatches(WINDOWS_PREFIX);
    }
}

