/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.cfg.SparkSettings;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.sql.EsDataFrameWriter;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;

public final class EsSparkSQL$ {
    public static final EsSparkSQL$ MODULE$;
    private final Class<?> init;
    private final transient Log LOG;

    static {
        new EsSparkSQL$();
    }

    private Class<?> init() {
        return this.init;
    }

    public Dataset<Row> esDF(SQLContext sc) {
        return this.esDF(sc, (Map<String, String>)Map$.MODULE$.empty());
    }

    public Dataset<Row> esDF(SQLContext sc, String resource) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, String query) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public Dataset<Row> esDF(SQLContext sc, Map<String, String> cfg) {
        Settings esConf = new SparkSettingsManager().load(sc.sparkContext().getConf()).copy();
        esConf.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        return sc.read().format("org.elasticsearch.spark.sql").options((Map)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(esConf.asProperties()).asScala()).toMap(Predef$.MODULE$.$conforms())).load();
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, String query, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource))));
    }

    public Dataset<Row> esDF(SparkSession ss) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)Map$.MODULE$.empty());
    }

    public Dataset<Row> esDF(SparkSession ss, String resource) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, String query) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public Dataset<Row> esDF(SparkSession ss, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), cfg);
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, String query, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), resource, query, cfg);
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), resource, cfg);
    }

    public void saveToEs(Dataset<?> srdd, String resource) {
        this.saveToEs(srdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource)}))));
    }

    public void saveToEs(Dataset<?> srdd, String resource, Map<String, String> cfg) {
        this.saveToEs(srdd, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource))));
    }

    public void saveToEs(Dataset<?> srdd, Map<String, String> cfg) {
        if (srdd != null) {
            SparkContext sparkCtx = srdd.sqlContext().sparkContext();
            SparkSettings sparkCfg = new SparkSettingsManager().load(sparkCtx.getConf());
            Settings esCfg = new PropertiesSettings().load(sparkCfg.save());
            esCfg.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
            InitializationUtils.discoverEsVersion(esCfg, this.LOG);
            InitializationUtils.checkIdForOperation(esCfg);
            InitializationUtils.checkIndexExistence(esCfg);
            EsDataFrameWriter esDataFrameWriter = new EsDataFrameWriter(srdd.schema(), esCfg.save());
            sparkCtx.runJob(srdd.toDF().rdd(), (Function2)new Serializable(esDataFrameWriter){
                public static final long serialVersionUID = 0L;
                private final EsDataFrameWriter eta$0$1$1;

                public final void apply(TaskContext taskContext, Iterator<Row> data) {
                    this.eta$0$1$1.write(taskContext, data);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            }, ClassTag$.MODULE$.Unit());
        }
    }

    private EsSparkSQL$() {
        MODULE$ = this;
        this.init = ObjectUtils.loadClass("org.elasticsearch.spark.rdd.CompatUtils", ObjectUtils.class.getClassLoader());
        this.LOG = LogFactory.getLog(this.getClass());
    }
}

