/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;

public abstract class HttpStatus {
    private static final Map<Integer, String> CODE_TO_TEXT = new HashMap<Integer, String>();
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int PROCESSING = 102;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTI_STATUS = 207;
    public static final int ALREADY_REPORTED = 208;
    public static final int IM_USED = 226;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int SWITCH_PROXY = 306;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int PERMANENT_REDIRECT = 308;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int I_M_A_TEAPOT = 418;
    public static final int AUTHENTICATION_TIMEOUT = 419;
    public static final int UNPROCESSABLE_ENTITY = 422;
    public static final int LOCKED = 423;
    public static final int METHOD_FAILURE = 424;
    public static final int UNORDERED_COLLECTION = 425;
    public static final int UPGRADE_REQUIRED = 426;
    public static final int PRECONDITION_REQUIRED = 428;
    public static final int TOO_MANY_REQUESTS = 429;
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 50;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int VARIANT_ALSO_NEGOTIATES = 506;
    public static final int INSUFFICIENT_STORAGE = 507;
    public static final int LOOP_DETECTED = 508;
    public static final int BANDWIDTH_LIMIT_EXCEEDED = 509;
    public static final int NOT_EXTENDED = 510;
    public static final int NETWORK_AUTHENTICATION_REQUIRED = 511;
    public static final int ORIGIN_ERROR = 520;
    public static final int CONNECTION_TIMED_OUT = 522;
    public static final int PROXY_DECLINED_REQUEST = 523;
    public static final int A_TIMEOUT_OCCURRED = 524;
    public static final int NETWORK_READ_TIMEOUT_ERROR = 598;
    public static final int NETWORK_CONNECT_TIMEOUT_ERROR = 599;

    public static String getText(int code) {
        if (code < 100 || code / 100 > 5) {
            throw new EsHadoopIllegalArgumentException("Invalid http code");
        }
        return CODE_TO_TEXT.get(code);
    }

    private static void addCode(int code, String text) {
        CODE_TO_TEXT.put(code, text);
    }

    public static boolean canRetry(int status) {
        return 503 == status || 429 == status;
    }

    public static boolean isServerError(int status) {
        return status / 100 == 5;
    }

    public static boolean isClientError(int status) {
        return status / 100 == 4;
    }

    public static boolean isRedirection(int status) {
        return status / 100 == 3;
    }

    public static boolean isSuccess(int status) {
        return status / 100 == 2;
    }

    public static boolean isInformal(int status) {
        return status / 100 == 1;
    }

    static {
        HttpStatus.addCode(100, "Continue");
        HttpStatus.addCode(101, "Switching Protocols");
        HttpStatus.addCode(102, "Processing");
        HttpStatus.addCode(200, "OK");
        HttpStatus.addCode(201, "Created");
        HttpStatus.addCode(202, "Accepted");
        HttpStatus.addCode(203, "Non Authoritative Information");
        HttpStatus.addCode(204, "No Content");
        HttpStatus.addCode(205, "Reset Content");
        HttpStatus.addCode(206, "Partial Content");
        HttpStatus.addCode(207, "Multi-Status");
        HttpStatus.addCode(208, "Already Reported");
        HttpStatus.addCode(226, "IM Used");
        HttpStatus.addCode(300, "Multiple Choices");
        HttpStatus.addCode(301, "Moved Permanently");
        HttpStatus.addCode(302, "Moved Temporarily");
        HttpStatus.addCode(303, "See Other");
        HttpStatus.addCode(304, "Not Modified");
        HttpStatus.addCode(305, "Use Proxy");
        HttpStatus.addCode(306, "Switch Proxy");
        HttpStatus.addCode(307, "Temporary Redirect");
        HttpStatus.addCode(308, "Permanent Redirect");
        HttpStatus.addCode(400, "Bad Request");
        HttpStatus.addCode(401, "Unauthorized");
        HttpStatus.addCode(402, "Payment Required");
        HttpStatus.addCode(403, "Forbidden");
        HttpStatus.addCode(404, "Not Found");
        HttpStatus.addCode(405, "Method Not Allowed");
        HttpStatus.addCode(406, "Not Acceptable");
        HttpStatus.addCode(407, "Proxy Authentication Required");
        HttpStatus.addCode(408, "Request Timeout");
        HttpStatus.addCode(409, "Conflict");
        HttpStatus.addCode(410, "Gone");
        HttpStatus.addCode(411, "Length Required");
        HttpStatus.addCode(412, "Precondition Failed");
        HttpStatus.addCode(413, "Request Entity Too Large");
        HttpStatus.addCode(414, "Request-URI Too Long");
        HttpStatus.addCode(415, "Unsupported Media Type");
        HttpStatus.addCode(416, "Requested Range Not Satisfiable");
        HttpStatus.addCode(417, "Expectation Failed");
        HttpStatus.addCode(418, "I'm a teapot");
        HttpStatus.addCode(419, "Authentication Timeout");
        HttpStatus.addCode(422, "Unprocessable Entity");
        HttpStatus.addCode(423, "Locked");
        HttpStatus.addCode(424, "Method Failure");
        HttpStatus.addCode(425, "Unordered Collection");
        HttpStatus.addCode(426, "Upgrade Required");
        HttpStatus.addCode(428, "Precondition Required");
        HttpStatus.addCode(429, "Too Many Requests");
        HttpStatus.addCode(431, "Request Header Fields Too Large");
        HttpStatus.addCode(500, "Internal Server Error");
        HttpStatus.addCode(501, "Not Implemented");
        HttpStatus.addCode(502, "Bad Gateway");
        HttpStatus.addCode(503, "Service Unavailable");
        HttpStatus.addCode(50, "Gateway Timeout");
        HttpStatus.addCode(505, "Http Version Not Supported");
        HttpStatus.addCode(506, "Variant Also Negociates");
        HttpStatus.addCode(507, "Insufficient Storage");
        HttpStatus.addCode(508, "Loop Detected");
        HttpStatus.addCode(509, "Bandwidth Limit Exceeded");
        HttpStatus.addCode(510, "Not Extended");
        HttpStatus.addCode(511, "Network Authentication Required");
        HttpStatus.addCode(520, "Origin Error");
        HttpStatus.addCode(522, "Connection timed out");
        HttpStatus.addCode(523, "Proxy Declined Request");
        HttpStatus.addCode(524, "A timeout occurred");
        HttpStatus.addCode(598, "Network read timeout error");
        HttpStatus.addCode(599, "Network connect timeout error");
    }
}

