/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk.handler.impl;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.NoHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.Retry;
import org.elasticsearch.hadoop.rest.SimpleHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteErrorHandler;
import org.elasticsearch.hadoop.rest.bulk.handler.BulkWriteFailure;
import org.elasticsearch.hadoop.rest.bulk.handler.DelayableErrorCollector;
import org.elasticsearch.hadoop.util.ObjectUtils;

public class HttpRetryHandler
extends BulkWriteErrorHandler {
    private final Retry retry;
    private int retryLimit;
    private long retryTime;

    public HttpRetryHandler() {
        throw new EsHadoopIllegalArgumentException("HttpRetryHandler is not loadable through the default handler loader logic. Set the HttpRetryPolicy instead.");
    }

    public HttpRetryHandler(Settings settings) {
        String retryPolicyName = settings.getBatchWriteRetryPolicy();
        if ("simple".equals(retryPolicyName)) {
            retryPolicyName = SimpleHttpRetryPolicy.class.getName();
        } else if ("none".equals(retryPolicyName)) {
            retryPolicyName = NoHttpRetryPolicy.class.getName();
        }
        HttpRetryPolicy retryPolicy = (HttpRetryPolicy)ObjectUtils.instantiate(retryPolicyName, settings);
        this.retry = retryPolicy.init();
        this.retryLimit = settings.getBatchWriteRetryCount();
        this.retryTime = settings.getBatchWriteRetryWait();
    }

    @Override
    public HandlerResult onError(BulkWriteFailure entry, DelayableErrorCollector<byte[]> collector) throws Exception {
        boolean legacyRetry;
        boolean bl = legacyRetry = entry.getResponseCode() == -1 && entry.getException().getMessage().contains("EsRejectedExecutionException");
        if (legacyRetry || this.retry.retry(entry.getResponseCode())) {
            if (entry.getNumberOfAttempts() <= this.retryLimit) {
                return collector.backoffAndRetry(this.retryTime, TimeUnit.MILLISECONDS);
            }
            return collector.pass("Document bulk write attempts [" + entry.getNumberOfAttempts() + "] exceeds configured automatic retry limit of [" + this.retryLimit + "]");
        }
        return collector.pass("Non retryable code [" + entry.getResponseCode() + "] encountered.");
    }
}

