/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.dsl.typing.TupleType;
import org.eclipse.xsemantics.dsl.typing.XsemanticsTypeSystem;
import org.eclipse.xsemantics.dsl.util.XsemanticsNodeModelUtils;
import org.eclipse.xsemantics.dsl.util.XsemanticsUtils;
import org.eclipse.xsemantics.dsl.validation.AbstractXsemanticsValidator;
import org.eclipse.xsemantics.dsl.validation.XsemanticsXExpressionHelper;
import org.eclipse.xsemantics.dsl.xsemantics.AbstractFieldDefinition;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.CheckRule;
import org.eclipse.xsemantics.dsl.xsemantics.FieldDefinition;
import org.eclipse.xsemantics.dsl.xsemantics.Injected;
import org.eclipse.xsemantics.dsl.xsemantics.InputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentDescription;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentParameter;
import org.eclipse.xsemantics.dsl.xsemantics.OutputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.Overrider;
import org.eclipse.xsemantics.dsl.xsemantics.ReferToJudgment;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleConclusion;
import org.eclipse.xsemantics.dsl.xsemantics.RuleConclusionElement;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleParameter;
import org.eclipse.xsemantics.dsl.xsemantics.UniqueByName;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsPackage;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsSystem;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Multimaps2;

public class XsemanticsValidator
extends AbstractXsemanticsValidator {
    @Inject
    protected XsemanticsTypeSystem typeSystem;
    @Inject
    @Extension
    protected XsemanticsUtils _xsemanticsUtils;
    @Inject
    protected XsemanticsXExpressionHelper xExpressionHelper;
    @Inject
    protected XsemanticsNodeModelUtils nodeModelUtils;
    public static final int maxOfOutputParams = 3;
    protected boolean enableWarnings = true;
    public static final String PREFIX = "org.eclipse.xsemantics.dsl.validation.";
    public static final String DUPLICATE_JUDGMENT_DESCRIPTION_SYMBOLS = "org.eclipse.xsemantics.dsl.validation.DuplicateJudgmentDescriptionSymbols";
    public static final String NO_JUDGMENT_DESCRIPTION = "org.eclipse.xsemantics.dsl.validation.NoJudgmentDescription";
    public static final String NOT_SUBTYPE = "org.eclipse.xsemantics.dsl.validation.NotSubtype";
    public static final String DUPLICATE_RULE_WITH_SAME_ARGUMENTS = "org.eclipse.xsemantics.dsl.validation.DuplicateRulesWithSameArguments";
    public static final String DUPLICATE_AUXFUN_WITH_SAME_ARGUMENTS = "org.eclipse.xsemantics.dsl.validation.DuplicateAuxFunWithSameArguments";
    public static final String MUST_OVERRIDE = "org.eclipse.xsemantics.dsl.validation.MustOverride";
    public static final String DUPLICATE_NAME = "org.eclipse.xsemantics.dsl.validation.DuplicateName";
    public static final String NOT_VALIDATOR = "org.eclipse.xsemantics.dsl.validation.NotAbstractDeclarativeValidator";
    public static final String NOT_PARAMETER = "org.eclipse.xsemantics.dsl.validation.NotParameter";
    public static final String NOT_VALID_OUTPUT_ARG = "org.eclipse.xsemantics.dsl.validation.NotValidOutputArg";
    public static final String NOT_VALID_INPUT_ARG = "org.eclipse.xsemantics.dsl.validation.NotValidInputArg";
    public static final String TOO_MANY_OUTPUT_PARAMS = "org.eclipse.xsemantics.dsl.validation.TooManyOutputParams";
    public static final String NO_INPUT_PARAM = "org.eclipse.xsemantics.dsl.validation.NoInputParam";
    public static final String ASSIGNMENT_TO_INPUT_PARAM = "org.eclipse.xsemantics.dsl.validation.AssignmentToInputParam";
    public static final String NO_RULE_FOR_JUDGMENT_DESCRIPTION = "org.eclipse.xsemantics.dsl.validation.NoRuleForJudgmentDescription";
    public static final String NO_AUXFUN_FOR_AUX_DESCRIPTION = "org.eclipse.xsemantics.dsl.validation.NoAuxFunForAuxiliaryDescription";
    public static final String RETURN_NOT_ALLOWED = "org.eclipse.xsemantics.dsl.validation.ReturnNotAllowed";
    public static final String THROW_NOT_ALLOWED = "org.eclipse.xsemantics.dsl.validation.ThrowNotAllowed";
    public static final String NOT_VALID_SUPER_SYSTEM = "org.eclipse.xsemantics.dsl.validation.NotValidSuperSystem";
    public static final String CYCLIC_HIERARCHY = "org.eclipse.xsemantics.dsl.validation.CyclicHierarchy";
    public static final String EXTENDS_CANNOT_COEXIST_WITH_VALIDATOR_EXTENDS = "org.eclipse.xsemantics.dsl.validation.ExtendsCannotCoexistWithValidatorExtends";
    public static final String OVERRIDE_WITHOUT_SYSTEM_EXTENDS = "org.eclipse.xsemantics.dsl.validation.OverrideWithoutSystemExtends";
    public static final String NOTHING_TO_OVERRIDE = "org.eclipse.xsemantics.dsl.validation.NothingToOverride";
    public static final String DUPLICATE_AUXILIARY_NAME = "org.eclipse.xsemantics.dsl.validation.DuplicateAuxiliaryDescription";
    public static final String NO_AUXDESC_FOR_AUX_FUNCTION = "org.eclipse.xsemantics.dsl.validation.NoAuxDescForAuxiliaryFunction";
    public static final String PARAMS_SIZE_DONT_MATCH = "org.eclipse.xsemantics.dsl.validation.ParamsSizeDontMatch";
    public static final String ACCESS_TO_OUTPUT_PARAM_WITHIN_CLOSURE = "org.eclipse.xsemantics.dsl.validation.AccessToOutputParamWithinClosure";
    public static final String RESERVED_VARIABLE_NAME = "org.eclipse.xsemantics.dsl.validation.ReservedVariableName";
    public static final String FINAL_FIELD_NOT_INITIALIZED = "org.eclipse.xsemantics.dsl.validation.FinalFieldNotInitialized";
    public static final String TOO_LITTLE_TYPE_INFORMATION = "org.eclipse.xsemantics.dsl.validation.TooLittleTypeInformation";

    @Check
    public void checkAssignment(XAssignment assignment) {
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof JvmFormalParameter) {
            boolean bl = this._xsemanticsUtils.isInputParam((JvmFormalParameter)assignmentFeature);
            if (bl) {
                this.error("Assignment to input parameter", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, ASSIGNMENT_TO_INPUT_PARAM, new String[0]);
            }
            return;
        }
        super.checkAssignment(assignment);
    }

    @Check
    public void checkReturn(XReturnExpression expr) {
        boolean bl;
        boolean bl2 = this.isContainedInAuxiliaryFunction((XExpression)expr);
        boolean bl3 = bl = !bl2;
        if (bl) {
            this.error("Return statements are not allowed here", (EObject)expr, null, RETURN_NOT_ALLOWED, new String[0]);
        }
    }

    @Check
    public void checkVariableDeclaration(XVariableDeclaration declaration) {
        super.checkVariableDeclaration(declaration);
        boolean bl = "previousFailure".equals(declaration.getName());
        if (bl) {
            this.error("previousFailure is a reserved name", (EObject)declaration, null, RESERVED_VARIABLE_NAME, new String[0]);
        }
    }

    protected boolean isContainedInAuxiliaryFunction(XExpression expr) {
        AuxiliaryFunction auxiliaryFunction = (AuxiliaryFunction)EcoreUtil2.getContainerOfType((EObject)expr, AuxiliaryFunction.class);
        return auxiliaryFunction != null;
    }

    @Check
    public void checkThrow(XThrowExpression expr) {
        this.error("Throw statements are not allowed here", (EObject)expr, null, THROW_NOT_ALLOWED, new String[0]);
    }

    protected boolean isLocallyUsed(EObject target, EObject containerToFindUsage) {
        if (containerToFindUsage instanceof RuleInvocation) {
            return true;
        }
        return super.isLocallyUsed(target, containerToFindUsage);
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        boolean valueExpectedRecursive = super.isValueExpectedRecursive(expr);
        return valueExpectedRecursive || this.xExpressionHelper.isXsemanticsXExpression(expr.eContainer());
    }

    @Check
    public void checkJudgmentDescription(JudgmentDescription judgmentDescription) {
        this.checkNumOfOutputParams(judgmentDescription);
        this.checkInputParams(judgmentDescription);
        this.checkJudgmentDescriptionRules(judgmentDescription);
    }

    public void checkJudgmentDescriptionRules(JudgmentDescription judgmentDescription) {
        Iterable<Rule> rulesForJudgmentDescription = this._xsemanticsUtils.rulesForJudgmentDescription(judgmentDescription);
        boolean bl = IterableExtensions.isEmpty(rulesForJudgmentDescription);
        if (bl) {
            if (this.isEnableWarnings() && !judgmentDescription.isOverride()) {
                this.warning("No rule defined for the judgment description", (EStructuralFeature)XsemanticsPackage.Literals.JUDGMENT_DESCRIPTION.getEIDAttribute(), NO_RULE_FOR_JUDGMENT_DESCRIPTION, new String[0]);
            }
        } else {
            EList<JudgmentParameter> judgmentParameters = judgmentDescription.getJudgmentParameters();
            for (Rule rule : rulesForJudgmentDescription) {
                EList<RuleConclusionElement> conclusionElements = rule.getConclusion().getConclusionElements();
                Iterator judgmentParametersIt = judgmentParameters.iterator();
                for (RuleConclusionElement ruleConclusionElement : conclusionElements) {
                    if (this._xsemanticsUtils.isOutputParameter((JudgmentParameter)judgmentParametersIt.next()) || ruleConclusionElement instanceof RuleParameter) continue;
                    this.error("Must be a parameter, not an expression", ruleConclusionElement, (EStructuralFeature)XsemanticsPackage.Literals.RULE_CONCLUSION_ELEMENT.getEIDAttribute(), NOT_PARAMETER, new String[0]);
                }
                this.checkRuleConformantToJudgmentDescription(rule, judgmentDescription);
            }
        }
    }

    protected void checkNumOfOutputParams(JudgmentDescription judgmentDescription) {
        boolean bl;
        int n = this._xsemanticsUtils.outputJudgmentParameters(judgmentDescription).size();
        boolean bl2 = bl = n > 3;
        if (bl) {
            this.error("No more than " + Integer.valueOf(3) + " output parameters are handled at the moment", (EStructuralFeature)XsemanticsPackage.Literals.JUDGMENT_DESCRIPTION__JUDGMENT_PARAMETERS, TOO_MANY_OUTPUT_PARAMS, new String[0]);
        }
    }

    protected void checkInputParams(JudgmentDescription judgmentDescription) {
        List<InputParameter> inputParams = this._xsemanticsUtils.inputParams(judgmentDescription);
        boolean bl = inputParams.isEmpty();
        if (bl) {
            this.error("No input parameter; at least one is needed", (EStructuralFeature)XsemanticsPackage.Literals.JUDGMENT_DESCRIPTION__JUDGMENT_PARAMETERS, NO_INPUT_PARAM, new String[0]);
        } else {
            this.checkDuplicatesByName(inputParams, null, DUPLICATE_NAME);
        }
    }

    @Check
    public void checkRule(Rule rule) {
        RuleConclusion conclusion = rule.getConclusion();
        this.findJudgmentDescriptionOrError(rule, conclusion.getJudgmentSymbol(), (Iterable<String>)conclusion.getRelationSymbols(), (EStructuralFeature)XsemanticsPackage.Literals.RULE__CONCLUSION);
    }

    @Check
    public void checkRuleInvocation(RuleInvocation ruleInvocation) {
        JudgmentDescription judgmentDescription = this.checkRuleInvocationConformantToJudgmentDescription(ruleInvocation);
        if (judgmentDescription != null) {
            EList<JudgmentParameter> judgmentParameters = judgmentDescription.getJudgmentParameters();
            EList<XExpression> invocationExpressions = ruleInvocation.getExpressions();
            Iterator judgmentParametersIt = judgmentParameters.iterator();
            for (XExpression ruleInvocationExpression : invocationExpressions) {
                String string;
                String string2;
                boolean bl;
                boolean bl2;
                boolean bl3 = this._xsemanticsUtils.isOutputParameter((JudgmentParameter)judgmentParametersIt.next());
                if (bl3) {
                    bl2 = this._xsemanticsUtils.validOutputArgExpression(ruleInvocationExpression);
                    boolean bl4 = bl = !bl2;
                    if (!bl) continue;
                    string2 = this.nodeModelUtils.getProgramText((EObject)ruleInvocationExpression);
                    string = "Not a valid argument for output parameter: " + string2;
                    this.error(string, (EObject)ruleInvocationExpression, null, NOT_VALID_OUTPUT_ARG, new String[0]);
                    continue;
                }
                bl2 = this._xsemanticsUtils.validInputArgExpression(ruleInvocationExpression);
                boolean bl5 = bl = !bl2;
                if (!bl) continue;
                string2 = this.nodeModelUtils.getProgramText((EObject)ruleInvocationExpression);
                string = "Not a valid argument for input parameter: " + string2;
                this.error(string, (EObject)ruleInvocationExpression, null, NOT_VALID_INPUT_ARG, new String[0]);
            }
        }
    }

    @Check
    public void checkSystem(XsemanticsSystem system) {
        List<XsemanticsSystem> superSystems;
        boolean bl;
        Object object;
        JvmParameterizedTypeReference superSystem;
        Object object2;
        boolean bl2;
        JvmParameterizedTypeReference validatorExtends = system.getValidatorExtends();
        if (validatorExtends != null) {
            boolean bl3 = this.typeSystem.isAbstractDeclarativeValidator((JvmTypeReference)validatorExtends, system);
            boolean bl4 = bl2 = !bl3;
            if (bl2) {
                Object object3 = this.getNameOfTypes((JvmTypeReference)validatorExtends);
                object2 = "Not an AbstractDeclarativeValidator: " + object3;
                this.error((String)object2, (EStructuralFeature)XsemanticsPackage.Literals.XSEMANTICS_SYSTEM__VALIDATOR_EXTENDS, NOT_VALIDATOR, new String[0]);
            }
        }
        if ((superSystem = system.getSuperSystem()) != null) {
            boolean bl5;
            bl2 = this.typeSystem.isValidSuperSystem((JvmTypeReference)superSystem, system);
            boolean bl6 = bl5 = !bl2;
            if (bl5) {
                object2 = this.getNameOfTypes((JvmTypeReference)superSystem);
                object = "Not an Xsemantics system: " + object2;
                this.error((String)object, (EStructuralFeature)XsemanticsPackage.Literals.XSEMANTICS_SYSTEM__SUPER_SYSTEM, NOT_VALID_SUPER_SYSTEM, new String[0]);
            }
            if (validatorExtends != null) {
                this.error("system 'extends' cannot coexist with 'validatorExtends'", (EStructuralFeature)XsemanticsPackage.Literals.XSEMANTICS_SYSTEM__SUPER_SYSTEM, EXTENDS_CANNOT_COEXIST_WITH_VALIDATOR_EXTENDS, new String[0]);
                this.error("system 'extends' cannot coexist with 'validatorExtends'", (EStructuralFeature)XsemanticsPackage.Literals.XSEMANTICS_SYSTEM__VALIDATOR_EXTENDS, EXTENDS_CANNOT_COEXIST_WITH_VALIDATOR_EXTENDS, new String[0]);
            }
        }
        if (bl = (superSystems = this._xsemanticsUtils.allSuperSystemDefinitions(system)).contains(system)) {
            this.error("Cycle in extends relation", (EStructuralFeature)XsemanticsPackage.Literals.XSEMANTICS_SYSTEM__SUPER_SYSTEM, CYCLIC_HIERARCHY, new String[0]);
        }
        XsemanticsSystem superSystemDefinition = this._xsemanticsUtils.superSystemDefinition(system);
        object = null;
        if (superSystemDefinition != null) {
            object = this._xsemanticsUtils.allJudgments(superSystemDefinition);
        }
        String allSuperJudgments = object;
        Functions.Function2 function2 = (j1, j2) -> Objects.equal((Object)j1.getJudgmentSymbol(), (Object)j2.getJudgmentSymbol()) && IterableExtensions.elementsEqual(j1.getRelationSymbols(), j2.getRelationSymbols()) && this.typeSystem.equals((JudgmentDescription)j1, (JudgmentDescription)j2);
        this.checkOverrides((Iterable)system.getJudgmentDescriptions(), (Iterable)((Object)allSuperJudgments), (Functions.Function2)function2, "judgment");
        Iterable<AuxiliaryDescription> iterable = null;
        if (superSystemDefinition != null) {
            iterable = this._xsemanticsUtils.allAuxiliaryDescriptions(superSystemDefinition);
        }
        Iterable<AuxiliaryDescription> allSuperAuxiliaryDescriptions = iterable;
        Functions.Function2 function22 = (a1, a2) -> this.typeSystem.equals((AuxiliaryDescription)a1, (AuxiliaryDescription)a2);
        this.checkOverrides((Iterable)system.getAuxiliaryDescriptions(), allSuperAuxiliaryDescriptions, (Functions.Function2)function22, "auxiliary description");
        Iterable<CheckRule> iterable2 = null;
        if (superSystemDefinition != null) {
            iterable2 = this._xsemanticsUtils.allCheckRules(superSystemDefinition);
        }
        Iterable<CheckRule> allSuperCheckRules = iterable2;
        Functions.Function2 function23 = (r1, r2) -> this.typeSystem.equals(r1.getElement().getParameter().getParameterType(), r2.getElement().getParameter().getParameterType(), (EObject)r1);
        this.checkOverrides((Iterable)system.getCheckrules(), allSuperCheckRules, (Functions.Function2)function23, "checkrule");
        Iterable<Rule> iterable3 = null;
        if (superSystemDefinition != null) {
            iterable3 = this._xsemanticsUtils.allRules(superSystemDefinition);
        }
        Iterable<Rule> allSuperRules = iterable3;
        Functions.Function2 function24 = (r1, r2) -> r1.getConclusion().getJudgmentSymbol().equals(r2.getConclusion().getJudgmentSymbol()) && IterableExtensions.elementsEqual(r1.getConclusion().getRelationSymbols(), r2.getConclusion().getRelationSymbols()) && this.typeSystem.equals(this.typeSystem.getInputTypes((Rule)r1), this.typeSystem.getInputTypes((Rule)r2));
        this.checkOverrides((Iterable)system.getRules(), allSuperRules, (Functions.Function2)function24, "rule");
        EList<Rule> eList = system.getRules();
        for (Rule rule : eList) {
            boolean bl7;
            RuleConclusion conclusion = rule.getConclusion();
            List<Rule> rulesOfTheSameKind = this._xsemanticsUtils.allRulesByJudgmentDescription(system, conclusion.getJudgmentSymbol(), (Iterable<String>)conclusion.getRelationSymbols());
            int n = rulesOfTheSameKind.size();
            boolean bl8 = bl7 = n > 1;
            if (!bl7) continue;
            TupleType tupleType = this.typeSystem.getInputTypes(rule);
            for (Rule rule2 : rulesOfTheSameKind) {
                TupleType tupleType2;
                boolean bl9;
                if (Objects.equal((Object)rule2, (Object)rule) || rule.isOverride() || !(bl9 = this.typeSystem.equals(tupleType, tupleType2 = this.typeSystem.getInputTypes(rule2)))) continue;
                String string = this.tupleTypeRepresentation(tupleType);
                String string2 = "Duplicate rule of the same kind with parameters: " + string;
                String string3 = this.reportContainingSystemName(rule2);
                String string4 = String.valueOf(string2) + string3;
                this.error(string4, rule, (EStructuralFeature)XsemanticsPackage.Literals.RULE__CONCLUSION, DUPLICATE_RULE_WITH_SAME_ARGUMENTS, new String[0]);
            }
        }
        EList<AbstractFieldDefinition> eList2 = system.getFields();
        EList<JudgmentDescription> eList3 = system.getJudgmentDescriptions();
        Iterable iterable4 = Iterables.concat(eList2, eList3);
        EList<AuxiliaryDescription> eList4 = system.getAuxiliaryDescriptions();
        Iterable iterable5 = Iterables.concat((Iterable)iterable4, eList4);
        EList<Rule> eList5 = system.getRules();
        Iterable iterable6 = Iterables.concat((Iterable)iterable5, eList5);
        EList<CheckRule> eList6 = system.getCheckrules();
        Iterable elements = Iterables.concat((Iterable)iterable6, eList6);
        this.checkDuplicatesByName(elements, null, DUPLICATE_NAME);
        Functions.Function1 function1 = it -> this.judgmentRepresentation(it.getJudgmentSymbol(), (Iterable<String>)it.getRelationSymbols());
        Functions.Function2 function25 = (key, it) -> {
            String string = it.eClass().getName();
            String string2 = "Duplicate judgment symbols '" + key + "' (" + string;
            return String.valueOf(string2) + ")";
        };
        this.checkDuplicates((Iterable)system.getJudgmentDescriptions(), (EStructuralFeature)XsemanticsPackage.Literals.JUDGMENT_DESCRIPTION__JUDGMENT_SYMBOL, DUPLICATE_JUDGMENT_DESCRIPTION_SYMBOLS, (Functions.Function1)function1, (Functions.Function2)function25);
    }

    private <T extends UniqueByName> void checkDuplicatesByName(Iterable<T> collection, EStructuralFeature feature, String issue) {
        Functions.Function1 function1 = it -> it.getName();
        Functions.Function2 function2 = (key, it) -> {
            String string = it.getName();
            String string2 = "Duplicate name '" + string;
            String string3 = String.valueOf(string2) + "' (";
            String string4 = it.eClass().getName();
            String string5 = String.valueOf(string3) + string4;
            return String.valueOf(string5) + ")";
        };
        this.checkDuplicates(collection, feature, issue, function1, function2);
    }

    private <T extends EObject, K> void checkDuplicates(Iterable<T> collection, EStructuralFeature feature, String issue, Functions.Function1<? super T, ? extends K> keyComputer, Functions.Function2<? super K, ? super T, ? extends String> errorMessageProvider) {
        boolean bl;
        boolean bl2 = IterableExtensions.isEmpty(collection);
        boolean bl3 = bl = !bl2;
        if (bl) {
            ListMultimap<K, T> map = this.duplicatesMultimap();
            for (EObject e : collection) {
                map.put(keyComputer.apply((Object)e), (Object)e);
            }
            Set set = map.asMap().entrySet();
            for (Map.Entry entry : set) {
                boolean bl4;
                Collection duplicates = (Collection)entry.getValue();
                int n = duplicates.size();
                boolean bl5 = bl4 = n > 1;
                if (!bl4) continue;
                for (EObject d : duplicates) {
                    this.error((String)errorMessageProvider.apply(entry.getKey(), (Object)d), d, feature, issue, new String[0]);
                }
            }
        }
    }

    private <T extends Overrider> void checkOverrides(Iterable<T> collection, Iterable<T> superCollection, Functions.Function2<? super T, ? super T, ? extends Boolean> conformanceComputer, String kind) {
        if (superCollection == null) {
            Functions.Function1 function1 = it -> it.isOverride();
            Iterable iterable = IterableExtensions.filter(collection, (Functions.Function1)function1);
            for (Overrider j : iterable) {
                this.error("Cannot override " + kind + " without system 'extends'", j, null, OVERRIDE_WITHOUT_SYSTEM_EXTENDS, new String[0]);
            }
        } else {
            Functions.Function1 function1 = it -> it.getName();
            Map superMap = IterableExtensions.toMap(superCollection, (Functions.Function1)function1);
            for (Overrider j_1 : collection) {
                boolean bl;
                String name = j_1.getName();
                Overrider overridden = (Overrider)superMap.get(name);
                boolean bl2 = j_1.isOverride();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    if (overridden == null) continue;
                    String string = this.reportContainingSystemName(overridden);
                    String string2 = String.valueOf(kind) + " '" + name + "' must override " + kind + string;
                    this.error(string2, j_1, null, MUST_OVERRIDE, new String[0]);
                    continue;
                }
                if (overridden != null && ((Boolean)conformanceComputer.apply((Object)j_1, (Object)overridden)).booleanValue()) continue;
                this.error("No " + kind + " to override: " + name, j_1, null, NOTHING_TO_OVERRIDE, new String[0]);
            }
        }
    }

    @Check
    public void checkAuxiliaryDescription(AuxiliaryDescription aux) {
        int n;
        boolean bl;
        boolean bl2 = aux.getParameters().isEmpty();
        if (bl2) {
            this.error("No input parameter; at least one is needed", (EStructuralFeature)XsemanticsPackage.Literals.AUXILIARY_DESCRIPTION__NAME, NO_INPUT_PARAM, new String[0]);
        }
        List<AuxiliaryFunction> functionsForAuxiliaryDescrition = this._xsemanticsUtils.functionsForAuxiliaryDescrition(aux);
        if (this.isEnableWarnings() && functionsForAuxiliaryDescrition.isEmpty() && !aux.isOverride()) {
            this.warning("No function defined for the auxiliary description", (EStructuralFeature)XsemanticsPackage.Literals.AUXILIARY_DESCRIPTION.getEIDAttribute(), NO_AUXFUN_FOR_AUX_DESCRIPTION, new String[0]);
        }
        boolean bl3 = bl = (n = functionsForAuxiliaryDescrition.size()) > 1;
        if (bl) {
            Functions.Function1 function1 = it -> this.typeSystem.getInputTypes((AuxiliaryFunction)it);
            Functions.Function2 function2 = (key, it) -> {
                String string = this.tupleTypeRepresentation((TupleType)key);
                String string2 = "Duplicate auxiliary function of the same kind with parameters: " + string;
                String string3 = this.reportContainingSystemName((EObject)it);
                return String.valueOf(string2) + string3;
            };
            this.checkDuplicates(functionsForAuxiliaryDescrition, (EStructuralFeature)XsemanticsPackage.Literals.AUXILIARY_FUNCTION__PARAMETERS, DUPLICATE_AUXFUN_WITH_SAME_ARGUMENTS, function1, function2);
        }
    }

    @Check
    public void checkAuxiliaryFunctionHasAuxiliaryDescription(AuxiliaryFunction aux) {
        AuxiliaryDescription auxiliaryDescription = this._xsemanticsUtils.getAuxiliaryDescription(aux);
        if (auxiliaryDescription == null) {
            String string = aux.getName();
            String string2 = "No auxiliary description for auxiliary function '" + string;
            String string3 = String.valueOf(string2) + "'";
            this.error(string3, (EStructuralFeature)XsemanticsPackage.Literals.AUXILIARY_FUNCTION__NAME, NO_AUXDESC_FOR_AUX_FUNCTION, new String[0]);
        } else {
            this.checkConformanceOfAuxiliaryFunction(aux, auxiliaryDescription);
        }
    }

    @Check
    public void checkOutputParamAccessWithinClosure(XFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmFormalParameter) {
            EObject container = ((JvmFormalParameter)feature).eContainer();
            if (container instanceof RuleParameter && this._xsemanticsUtils.isOutputParam((RuleParameter)container) && this.insideClosure(featureCall)) {
                String string = ((JvmFormalParameter)feature).getIdentifier();
                String string2 = "Cannot refer to an output parameter " + string;
                String string3 = String.valueOf(string2) + " from within a closure";
                this.error(string3, (EObject)featureCall, null, ACCESS_TO_OUTPUT_PARAM_WITHIN_CLOSURE, new String[0]);
            }
            return;
        }
    }

    @Check
    protected void ensureNotPrimitive(JvmTypeReference typeRef) {
        EObject container;
        LightweightTypeReference reference = this.toLightweightTypeReference(typeRef);
        boolean bl = reference.isPrimitive();
        if (bl && ((container = typeRef.eContainer()) instanceof OutputParameter || container instanceof JvmFormalParameter || container instanceof Injected || container instanceof AuxiliaryDescription)) {
            this.error("Primitives cannot be used in this context.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkFieldInitialization(FieldDefinition f) {
        String string;
        String string2;
        String string3;
        if (!f.isWriteable() && f.getRight() == null) {
            string3 = f.getName();
            string2 = "The final field " + string3;
            string = String.valueOf(string2) + " may not have been initialized";
            this.error(string, (EStructuralFeature)XsemanticsPackage.Literals.ABSTRACT_FIELD_DEFINITION__NAME, FINAL_FIELD_NOT_INITIALIZED, new String[0]);
        }
        if (f.getType() == null && f.getRight() == null) {
            string3 = f.getName();
            string2 = "The field " + string3;
            string = String.valueOf(string2) + " needs an explicit type since there is no initialization expression to infer the type from.";
            this.error(string, f, (EStructuralFeature)XsemanticsPackage.Literals.ABSTRACT_FIELD_DEFINITION__NAME, TOO_LITTLE_TYPE_INFORMATION, new String[0]);
        }
    }

    private boolean insideClosure(XFeatureCall featureCall) {
        XClosure xClosure = (XClosure)EcoreUtil2.getContainerOfType((EObject)featureCall, XClosure.class);
        return xClosure != null;
    }

    protected void checkConformanceOfAuxiliaryFunction(AuxiliaryFunction aux, AuxiliaryDescription auxiliaryDescription) {
        int n;
        boolean bl;
        EList<JvmFormalParameter> funParams = aux.getParameters();
        EList<JvmFormalParameter> descParams = auxiliaryDescription.getParameters();
        int n2 = funParams.size();
        boolean bl2 = bl = n2 != (n = descParams.size());
        if (bl) {
            int n3 = descParams.size();
            String string = "expected " + Integer.valueOf(n3);
            String string2 = String.valueOf(string) + " parameter(s), but was ";
            int n4 = funParams.size();
            String string3 = String.valueOf(string2) + Integer.valueOf(n4);
            this.error(string3, aux, (EStructuralFeature)XsemanticsPackage.Literals.AUXILIARY_FUNCTION__PARAMETERS, PARAMS_SIZE_DONT_MATCH, new String[0]);
        } else {
            Iterator funParamsIt = funParams.iterator();
            for (JvmFormalParameter jvmFormalParameter : descParams) {
                boolean bl3;
                JvmFormalParameter funParam;
                JvmTypeReference actual;
                JvmTypeReference expected = this.typeSystem.getType((EObject)jvmFormalParameter);
                boolean bl4 = this.typeSystem.isConformant(expected, actual = this.typeSystem.getType((EObject)(funParam = (JvmFormalParameter)funParamsIt.next())), (EObject)funParam);
                boolean bl5 = bl3 = !bl4;
                if (!bl3) continue;
                Object object = this.getNameOfTypes(actual);
                String string = "parameter type " + object;
                String string4 = String.valueOf(string) + " is not subtype of AuxiliaryDescription declared type ";
                Object object2 = this.getNameOfTypes(expected);
                String string5 = String.valueOf(string4) + object2;
                this.error(string5, (EObject)funParam, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE, NOT_SUBTYPE, new String[0]);
            }
        }
    }

    protected String reportContainingSystemName(EObject object) {
        String string = this._xsemanticsUtils.containingSystem(object).getName();
        return ", in system: " + string;
    }

    private void checkRuleConformantToJudgmentDescription(Rule rule, JudgmentDescription judgmentDescription) {
        RuleConclusion conclusion = rule.getConclusion();
        this.checkConformanceAgainstJudgmentDescription(judgmentDescription, conclusion, conclusion.getJudgmentSymbol(), (Iterable<String>)conclusion.getRelationSymbols(), (Iterable<? extends EObject>)conclusion.getConclusionElements(), "Rule conclusion", (EStructuralFeature)XsemanticsPackage.Literals.RULE__CONCLUSION, (EStructuralFeature)XsemanticsPackage.Literals.RULE_CONCLUSION_ELEMENT.getEIDAttribute());
    }

    private JudgmentDescription checkRuleInvocationConformantToJudgmentDescription(RuleInvocation ruleInvocation) {
        return this.checkConformanceAgainstJudgmentDescription(ruleInvocation, ruleInvocation.getJudgmentSymbol(), (Iterable<String>)ruleInvocation.getRelationSymbols(), (Iterable<? extends EObject>)ruleInvocation.getExpressions(), "Rule invocation", (EStructuralFeature)XsemanticsPackage.Literals.RULE_INVOCATION.getEIDAttribute(), null);
    }

    private JudgmentDescription checkConformanceAgainstJudgmentDescription(ReferToJudgment element, String judgmentSymbol, Iterable<String> relationSymbols, Iterable<? extends EObject> elements, String elementDescription, EStructuralFeature elementFeature, EStructuralFeature conformanceFeature) {
        JudgmentDescription judgmentDescription = this.findJudgmentDescriptionOrError(element, judgmentSymbol, relationSymbols, elementFeature);
        this.checkConformanceAgainstJudgmentDescription(judgmentDescription, element, judgmentSymbol, relationSymbols, elements, elementDescription, elementFeature, conformanceFeature);
        return judgmentDescription;
    }

    private JudgmentDescription findJudgmentDescriptionOrError(ReferToJudgment element, String judgmentSymbol, Iterable<String> relationSymbols, EStructuralFeature elementFeature) {
        JudgmentDescription judgmentDescription = this._xsemanticsUtils.getJudgmentDescription(element);
        if (judgmentDescription == null) {
            String string = this.judgmentRepresentation(judgmentSymbol, relationSymbols);
            String string2 = "No Judgment description for: " + string;
            this.error(string2, elementFeature, NO_JUDGMENT_DESCRIPTION, new String[0]);
        }
        return judgmentDescription;
    }

    private void checkConformanceAgainstJudgmentDescription(JudgmentDescription judgmentDescription, EObject element, String judgmentSymbol, Iterable<String> relationSymbols, Iterable<? extends EObject> elements, String elementDescription, EStructuralFeature elementFeature, EStructuralFeature conformanceFeature) {
        if (judgmentDescription != null) {
            EList<JudgmentParameter> judgmentParameters = judgmentDescription.getJudgmentParameters();
            Iterator<? extends EObject> elementsIt = elements.iterator();
            for (JudgmentParameter judgmentParameter : judgmentParameters) {
                boolean bl = elementsIt.hasNext();
                if (!bl) continue;
                this.checkConformance(judgmentParameter, elementsIt.next(), elementDescription, conformanceFeature);
            }
        }
    }

    protected void checkConformance(JudgmentParameter judgmentParameter, EObject element, String elementDescription, EStructuralFeature feature) {
        boolean bl;
        JvmTypeReference actual;
        JvmTypeReference expected = this.typeSystem.getType(judgmentParameter);
        boolean bl2 = this.typeSystem.isConformant(expected, actual = this.typeSystem.getType(element), element);
        boolean bl3 = bl = !bl2;
        if (bl) {
            Object object = this.getNameOfTypes(actual);
            String string = String.valueOf(elementDescription) + " type " + object;
            String string2 = String.valueOf(string) + " is not subtype of JudgmentDescription declared type ";
            Object object2 = this.getNameOfTypes(expected);
            String string3 = String.valueOf(string2) + object2;
            this.error(string3, element, feature, NOT_SUBTYPE, new String[0]);
        }
    }

    protected String judgmentRepresentation(String judgmentSymbol, Iterable<String> relationSymbols) {
        String string = IterableExtensions.join(relationSymbols, (CharSequence)" ");
        return String.valueOf(judgmentSymbol) + " " + string;
    }

    protected String tupleTypeRepresentation(TupleType tupleType) {
        StringBuilder builder = new StringBuilder();
        Iterator it = tupleType.iterator();
        while (it.hasNext()) {
            builder.append(this.getNameOfTypes((JvmTypeReference)it.next()));
            boolean bl = it.hasNext();
            if (!bl) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private Object getNameOfTypes(JvmTypeReference typeRef) {
        String string = null;
        string = typeRef == null ? "<null>" : typeRef.getSimpleName();
        return string;
    }

    public boolean isEnableWarnings() {
        return this.enableWarnings;
    }

    public void setEnableWarnings(boolean enableWarnings) {
        this.enableWarnings = enableWarnings;
    }

    private <K, T> ListMultimap<K, T> duplicatesMultimap() {
        return Multimaps2.newLinkedHashListMultimap();
    }
}

