/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsemantics.dsl.util.XsemanticsDslCache;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.Cachable;
import org.eclipse.xsemantics.dsl.xsemantics.CachedClause;
import org.eclipse.xsemantics.dsl.xsemantics.CheckRule;
import org.eclipse.xsemantics.dsl.xsemantics.EntryPointsOption;
import org.eclipse.xsemantics.dsl.xsemantics.ExpressionInConclusion;
import org.eclipse.xsemantics.dsl.xsemantics.InputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentDescription;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentParameter;
import org.eclipse.xsemantics.dsl.xsemantics.OrExpression;
import org.eclipse.xsemantics.dsl.xsemantics.OutputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.ReferToJudgment;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleConclusionElement;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleParameter;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsFile;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsSystem;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class XsemanticsUtils {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private XsemanticsDslCache cache;

    public XsemanticsSystem containingSystem(EObject element) {
        EObject eObject = (EObject)IterableExtensions.head((Iterable)element.eResource().getContents());
        return ((XsemanticsFile)eObject).getXsemanticsSystem();
    }

    public Rule containingRule(EObject element) {
        return (Rule)EcoreUtil2.getContainerOfType((EObject)element, Rule.class);
    }

    public OrExpression containingOrExpression(EObject element) {
        return (OrExpression)EcoreUtil2.getContainerOfType((EObject)element, OrExpression.class);
    }

    public JudgmentDescription getJudgmentDescription(ReferToJudgment e) {
        boolean bl;
        boolean bl2 = e.isSet_judgment();
        boolean bl3 = bl = !bl2;
        if (bl) {
            e.set_judgment(this.judgmentDescription(e, e.getJudgmentSymbol(), (Iterable<String>)e.getRelationSymbols()));
        }
        return e.get_judgment();
    }

    private JudgmentDescription judgmentDescription(EObject object, String judgmentSymbol, Iterable<String> relationSymbols) {
        Map<Pair<String, EList<String>>, JudgmentDescription> map = this.allJudgmentsRepresentations(this.containingSystem(object));
        Pair pair = Pair.of((Object)judgmentSymbol, relationSymbols);
        return map.get(pair);
    }

    public AuxiliaryDescription getAuxiliaryDescription(AuxiliaryFunction fun) {
        boolean bl;
        AuxiliaryDescription auxiliaryDescription = null;
        boolean bl2 = fun.isSet_auxiliaryDescription();
        boolean bl3 = bl = !bl2;
        if (bl) {
            fun.set_auxiliaryDescription(this.auxiliaryDescriptionsByName(this.containingSystem(fun)).get(fun.getName()));
        }
        auxiliaryDescription = fun.get_auxiliaryDescription();
        return auxiliaryDescription;
    }

    public Iterable<Rule> rulesForJudgmentDescription(JudgmentDescription judgmentDescription) {
        return this.filterRulesByJudgmentDescription(this.containingSystem(judgmentDescription), judgmentDescription.getJudgmentSymbol(), (Iterable<String>)judgmentDescription.getRelationSymbols());
    }

    public List<AuxiliaryFunction> functionsForAuxiliaryDescrition(AuxiliaryDescription aux) {
        Functions.Function1 function1 = it -> {
            String string = it.getName();
            String string2 = aux.getName();
            return Objects.equal((Object)string, (Object)string2);
        };
        return Lists.newArrayList((Iterable)IterableExtensions.filter(this.containingSystem(aux).getAuxiliaryFunctions(), (Functions.Function1)function1));
    }

    public Iterable<Rule> filterRulesByJudgmentDescription(XsemanticsSystem ts, String judgmentSymbol, Iterable<String> relationSymbols) {
        return this.filterRulesByJudgmentDescription((Iterable<Rule>)ts.getRules(), judgmentSymbol, relationSymbols);
    }

    public Iterable<Rule> filterRulesByJudgmentDescription(Iterable<Rule> rules, String judgmentSymbol, Iterable<String> relationSymbols) {
        Functions.Function1 function1 = it -> it.getConclusion().getJudgmentSymbol().equals(judgmentSymbol) && IterableExtensions.elementsEqual(it.getConclusion().getRelationSymbols(), (Iterable)relationSymbols);
        return IterableExtensions.filter(rules, (Functions.Function1)function1);
    }

    public boolean isOutputParameter(JudgmentParameter j) {
        return j instanceof OutputParameter;
    }

    public List<OutputParameter> outputJudgmentParameters(JudgmentDescription judgmentDescription) {
        return EcoreUtil2.typeSelect(judgmentDescription.getJudgmentParameters(), OutputParameter.class);
    }

    public List<RuleConclusionElement> outputConclusionElements(Rule rule) {
        ArrayList arrayList = null;
        Iterator judgmentParameters = this.getJudgmentDescription(rule).getJudgmentParameters().iterator();
        Functions.Function1 function1 = it -> this.isOutputParameter((JudgmentParameter)judgmentParameters.next());
        arrayList = Lists.newArrayList((Iterable)IterableExtensions.filter(rule.getConclusion().getConclusionElements(), (Functions.Function1)function1));
        return arrayList;
    }

    public List<OutputParameter> outputParams(RuleInvocation ruleInvocation) {
        return this.outputJudgmentParameters(this.getJudgmentDescription(ruleInvocation));
    }

    public List<InputParameter> inputParams(JudgmentDescription judgmentDescription) {
        return EcoreUtil2.typeSelect(judgmentDescription.getJudgmentParameters(), InputParameter.class);
    }

    public EList<RuleParameter> inputParams(Rule rule) {
        boolean bl;
        EList<RuleParameter> eList = null;
        boolean bl2 = rule.isSet_inputParams();
        boolean bl3 = bl = !bl2;
        if (bl) {
            Iterator judgmentParameters = this.getJudgmentDescription(rule).getJudgmentParameters().iterator();
            EList<RuleParameter> eList2 = rule.get_inputParams();
            Functions.Function1 function1 = it -> {
                boolean bl = this.isOutputParameter((JudgmentParameter)judgmentParameters.next());
                return !bl;
            };
            List list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.filter(rule.getConclusion().getConclusionElements(), (Functions.Function1)function1), RuleParameter.class));
            Iterables.addAll(eList2, (Iterable)list);
        }
        eList = rule.get_inputParams();
        return eList;
    }

    public boolean isInputParam(RuleParameter ruleParameter) {
        return this.inputParams(this.containingRule(ruleParameter)).contains((Object)ruleParameter);
    }

    public boolean isOutputParam(RuleParameter ruleParameter) {
        return this.outputParams(this.containingRule(ruleParameter)).contains(ruleParameter);
    }

    public boolean isInputParam(JvmFormalParameter jvmFormalParameter) {
        boolean bl = false;
        RuleParameter ruleParameter = (RuleParameter)EcoreUtil2.getContainerOfType((EObject)jvmFormalParameter, RuleParameter.class);
        boolean bl2 = false;
        bl2 = ruleParameter != null ? this.isInputParam(ruleParameter) : true;
        bl = bl2;
        return bl;
    }

    public List<RuleParameter> outputParams(Rule rule) {
        boolean bl;
        EList<RuleParameter> eList = null;
        boolean bl2 = rule.isSet_outputParams();
        boolean bl3 = bl = !bl2;
        if (bl) {
            JudgmentDescription judgmentDescription = this.getJudgmentDescription(rule);
            if (judgmentDescription == null || judgmentDescription.getJudgmentParameters().isEmpty()) {
                return Lists.newArrayList();
            }
            Iterator judgmentParameters = judgmentDescription.getJudgmentParameters().iterator();
            EList<RuleParameter> eList2 = rule.get_outputParams();
            Functions.Function1 function1 = it -> this.isOutputParameter((JudgmentParameter)judgmentParameters.next());
            List list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.filter(rule.getConclusion().getConclusionElements(), (Functions.Function1)function1), RuleParameter.class));
            Iterables.addAll(eList2, (Iterable)list);
        }
        eList = rule.get_outputParams();
        return eList;
    }

    public boolean hasOutputParams(RuleInvocation ruleInvocation) {
        boolean bl = this.outputParams(ruleInvocation).isEmpty();
        return !bl;
    }

    public List<ExpressionInConclusion> expressionsInConclusion(Rule rule) {
        return EcoreUtil2.getAllContentsOfType((EObject)rule.getConclusion(), ExpressionInConclusion.class);
    }

    public ArrayList<XExpression> outputArgsExpressions(RuleInvocation ruleInvocation) {
        ArrayList arrayList = null;
        Iterator judgmentParameters = this.getJudgmentDescription(ruleInvocation).getJudgmentParameters().iterator();
        Functions.Function1 function1 = it -> this.isOutputParameter((JudgmentParameter)judgmentParameters.next());
        arrayList = Lists.newArrayList((Iterable)IterableExtensions.filter(ruleInvocation.getExpressions(), (Functions.Function1)function1));
        return arrayList;
    }

    public boolean validOutputArgExpression(XExpression xexp) {
        if (xexp instanceof XFeatureCall) {
            JvmIdentifiableElement feature = ((XFeatureCall)xexp).getFeature();
            if (feature instanceof JvmFormalParameter) {
                boolean bl = this.isInputParam((JvmFormalParameter)feature);
                return !bl;
            }
            return true;
        }
        if (xexp instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)xexp).isWriteable() && ((XVariableDeclaration)xexp).getRight() == null;
        }
        return false;
    }

    public boolean validInputArgExpression(XExpression ruleInvocationExpression) {
        return !(ruleInvocationExpression instanceof XVariableDeclaration);
    }

    public ArrayList<XExpression> inputArgsExpressions(RuleInvocation ruleInvocation) {
        ArrayList arrayList = null;
        Iterator judgmentParameters = this.getJudgmentDescription(ruleInvocation).getJudgmentParameters().iterator();
        Functions.Function1 function1 = it -> {
            boolean bl = this.isOutputParameter((JudgmentParameter)judgmentParameters.next());
            return !bl;
        };
        arrayList = Lists.newArrayList((Iterable)IterableExtensions.filter(ruleInvocation.getExpressions(), (Functions.Function1)function1));
        return arrayList;
    }

    public Iterable<JudgmentDescription> allJudgments(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allJudgments", (Object)system);
        Provider provider = () -> {
            EList<JudgmentDescription> eList = system.getJudgmentDescriptions();
            Functions.Function1 function1 = it -> it.getJudgmentDescriptions();
            Iterable iterable = Iterables.concat((Iterable)ListExtensions.map(this.allSuperSystemDefinitions(system), (Functions.Function1)function1));
            return Iterables.concat(eList, (Iterable)iterable);
        };
        return (Iterable)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public Iterable<Rule> allRules(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allRules", (Object)system);
        Provider provider = () -> {
            EList<Rule> eList = system.getRules();
            Functions.Function1 function1 = it -> it.getRules();
            Iterable iterable = Iterables.concat((Iterable)ListExtensions.map(this.allSuperSystemDefinitions(system), (Functions.Function1)function1));
            return Iterables.concat(eList, (Iterable)iterable);
        };
        return (Iterable)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public List<Rule> allRulesByJudgmentDescription(XsemanticsSystem ts, String judgmentSymbol, Iterable<String> relationSymbols) {
        Pair pair = Pair.of((Object)judgmentSymbol, relationSymbols);
        Pair pair2 = Pair.of((Object)ts, (Object)pair);
        Pair pair3 = Pair.of((Object)"allRulesByJudgmentDescription", (Object)pair2);
        Provider provider = () -> IterableExtensions.toList(this.filterRulesByJudgmentDescription(this.allRules(ts), judgmentSymbol, relationSymbols));
        return (List)this.cache.get2(pair3, provider);
    }

    public Iterable<CheckRule> allCheckRules(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allCheckRules", (Object)system);
        Provider provider = () -> {
            EList<CheckRule> eList = system.getCheckrules();
            Functions.Function1 function1 = it -> it.getCheckrules();
            Iterable iterable = Iterables.concat((Iterable)ListExtensions.map(this.allSuperSystemDefinitions(system), (Functions.Function1)function1));
            return Iterables.concat(eList, (Iterable)iterable);
        };
        return (Iterable)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public Iterable<AuxiliaryDescription> allAuxiliaryDescriptions(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allAuxiliaryDescriptions", (Object)system);
        Provider provider = () -> {
            EList<AuxiliaryDescription> eList = system.getAuxiliaryDescriptions();
            Functions.Function1 function1 = it -> it.getAuxiliaryDescriptions();
            Iterable iterable = Iterables.concat((Iterable)ListExtensions.map(this.allSuperSystemDefinitions(system), (Functions.Function1)function1));
            return Iterables.concat(eList, (Iterable)iterable);
        };
        return (Iterable)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public List<XsemanticsSystem> allSuperSystemDefinitions(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allSuperSystemDefinitions", (Object)system);
        Provider provider = () -> this.allSuperSystemDefinitionsInternal(system, Sets.newHashSet());
        return (List)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    protected List<XsemanticsSystem> allSuperSystemDefinitionsInternal(XsemanticsSystem system, Set<XsemanticsSystem> visited) {
        ArrayList arrayList = null;
        boolean bl = visited.contains(system);
        if (bl) {
            return Lists.newArrayList();
        }
        visited.add(system);
        ArrayList arrayList2 = Lists.newArrayList();
        Procedures.Procedure1 procedure1 = it -> {
            XsemanticsSystem superS = this.superSystemDefinition(system);
            if (superS != null) {
                it.add(superS);
                List<XsemanticsSystem> list = this.allSuperSystemDefinitionsInternal(superS, visited);
                Iterables.addAll((Collection)it, list);
            }
        };
        arrayList = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList2, (Procedures.Procedure1)procedure1);
        return arrayList;
    }

    public XsemanticsSystem superSystemDefinition(XsemanticsSystem system) {
        JvmParameterizedTypeReference jvmParameterizedTypeReference = system.getSuperSystem();
        XsemanticsSystem xsemanticsSystem = null;
        if (jvmParameterizedTypeReference != null) {
            xsemanticsSystem = this.originalSystemDefinition((JvmTypeReference)jvmParameterizedTypeReference);
        }
        return xsemanticsSystem;
    }

    public XsemanticsSystem originalSystemDefinition(JvmTypeReference typeReference) {
        return (XsemanticsSystem)IterableExtensions.head((Iterable)Iterables.filter((Iterable)this.associations.getSourceElements((EObject)typeReference.getType()), XsemanticsSystem.class));
    }

    public Map<Pair<String, EList<String>>, JudgmentDescription> allJudgmentsRepresentations(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"allJudgmentsRepresentations", (Object)system);
        Provider provider = () -> {
            Functions.Function1 function1 = it -> {
                String string = it.getJudgmentSymbol();
                EList<String> eList = it.getRelationSymbols();
                return Pair.of((Object)string, eList);
            };
            return IterableExtensions.toMap(this.allJudgments(system), (Functions.Function1)function1);
        };
        return (Map)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public Map<String, AuxiliaryDescription> auxiliaryDescriptionsByName(XsemanticsSystem system) {
        Pair pair = Pair.of((Object)"auxiliaryDescriptionsByName", (Object)system);
        Provider provider = () -> {
            Functions.Function1 function1 = it -> it.getName();
            return IterableExtensions.toMap(system.getAuxiliaryDescriptions(), (Functions.Function1)function1);
        };
        return (Map)this.cache.get((Pair<String, EObject>)pair, provider);
    }

    public boolean cacheEntryPointMethods(Cachable c) {
        CachedClause cachedClause = c.getCachedClause();
        EntryPointsOption entryPointsOption = null;
        if (cachedClause != null) {
            entryPointsOption = cachedClause.getEntryPointsOption();
        }
        return Objects.equal((Object)((Object)entryPointsOption), (Object)((Object)EntryPointsOption.DEFAULT));
    }

    public XExpression cacheCondition(Cachable c) {
        CachedClause cachedClause = c.getCachedClause();
        XExpression xExpression = null;
        if (cachedClause != null) {
            xExpression = cachedClause.getCondition();
        }
        return xExpression;
    }
}

