/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.typing;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.dsl.typing.TupleType;
import org.eclipse.xsemantics.dsl.typing.XsemanticsTypeSystemGen;
import org.eclipse.xsemantics.dsl.util.XsemanticsUtils;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentDescription;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentParameter;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleParameter;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xsemantics.runtime.XsemanticsRuntimeSystem;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class XsemanticsTypeSystem {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private XsemanticsTypeSystemGen xsemanticsTypeSystemGen;
    @Inject
    @Extension
    private XsemanticsUtils _xsemanticsUtils;

    public JvmTypeReference getType(EObject element) {
        return (JvmTypeReference)this.xsemanticsTypeSystemGen.type(element).getValue();
    }

    public TupleType getInputTypes(Rule rule) {
        TupleType tupleType = new TupleType();
        EList<RuleParameter> eList = this._xsemanticsUtils.inputParams(rule);
        for (RuleParameter p : eList) {
            tupleType.add(this.getType(p));
        }
        return tupleType;
    }

    public TupleType getInputTypes(AuxiliaryFunction aux) {
        TupleType tupleType = new TupleType();
        EList<JvmFormalParameter> eList = aux.getParameters();
        for (JvmFormalParameter p : eList) {
            tupleType.add(this.getType((EObject)p));
        }
        return tupleType;
    }

    public boolean equals(TupleType tupleType1, TupleType tupleType2) {
        return tupleType1.equals(tupleType2);
    }

    public boolean equals(JudgmentDescription j1, JudgmentDescription j2) {
        int n;
        boolean bl;
        int n2 = j1.getJudgmentParameters().size();
        boolean bl2 = bl = n2 != (n = j2.getJudgmentParameters().size());
        if (bl) {
            return false;
        }
        Iterator judgmentParametersIt = j1.getJudgmentParameters().iterator();
        EList<JudgmentParameter> eList = j2.getJudgmentParameters();
        for (JudgmentParameter jParam2 : eList) {
            JudgmentParameter jParam1 = (JudgmentParameter)judgmentParametersIt.next();
            if (Objects.equal((Object)jParam1.eClass(), (Object)jParam2.eClass()) && this.equals(this.getType(jParam1), this.getType(jParam2), jParam1)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(AuxiliaryDescription aux1, AuxiliaryDescription aux2) {
        boolean bl;
        int n;
        boolean bl2;
        int n2 = aux1.getParameters().size();
        boolean bl3 = bl2 = n2 != (n = aux2.getParameters().size());
        if (bl2) {
            return false;
        }
        boolean bl4 = this.equals(aux1.getType(), aux2.getType(), aux1);
        boolean bl5 = bl = !bl4;
        if (bl) {
            return false;
        }
        Iterator paramIt = aux1.getParameters().iterator();
        EList<JvmFormalParameter> eList = aux2.getParameters();
        for (JvmFormalParameter param2 : eList) {
            JvmFormalParameter param1 = (JvmFormalParameter)paramIt.next();
            if (Objects.equal((Object)param1.eClass(), (Object)param2.eClass()) && this.equals(this.getType((EObject)param1), this.getType((EObject)param2), (EObject)param1)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(JvmTypeReference t1, JvmTypeReference t2, EObject context) {
        if (t1 == null) {
            return t2 == null;
        }
        if (t2 == null) {
            return t1 == null;
        }
        return t1.getType().equals(t2.getType());
    }

    public boolean isConformant(JvmTypeReference expected, JvmTypeReference actual, EObject context) {
        return this.isSubtype(actual, expected, context);
    }

    public boolean isEObject(JvmTypeReference type, EObject context) {
        return this.isConformant(this.typeReferences.getTypeForName(EObject.class, (Notifier)context, new JvmTypeReference[0]), type, context);
    }

    public boolean isAbstractDeclarativeValidator(JvmTypeReference type, EObject context) {
        return this.isConformant(this.typeReferences.getTypeForName(AbstractDeclarativeValidator.class, (Notifier)context, new JvmTypeReference[0]), type, context);
    }

    public boolean isEStructuralFeature(JvmTypeReference type, EObject context) {
        return this.isConformant(this.typeReferences.getTypeForName(EStructuralFeature.class, (Notifier)context, new JvmTypeReference[0]), type, context);
    }

    public boolean isValidSuperSystem(JvmTypeReference type, EObject context) {
        return this.isConformant(this.typeReferences.getTypeForName(XsemanticsRuntimeSystem.class, (Notifier)context, new JvmTypeReference[0]), type, context);
    }

    public boolean isBooleanPremise(XExpression expression) {
        boolean bl;
        boolean bl2 = this.isExpressionToCheck(expression);
        boolean bl3 = bl = !bl2;
        if (bl) {
            return false;
        }
        JvmTypeReference booleanType = this.typeReferences.getTypeForName(Boolean.TYPE, (Notifier)expression, new JvmTypeReference[0]);
        JvmTypeReference operationType = this.getType((EObject)expression);
        return this.isSubtype(operationType, booleanType, (EObject)expression);
    }

    public boolean isExpressionToCheck(XExpression expression) {
        return expression instanceof XFeatureCall || expression instanceof XBinaryOperation || expression instanceof XUnaryOperation || expression instanceof XMemberFeatureCall || expression instanceof XBooleanLiteral || expression instanceof XInstanceOfExpression;
    }

    public boolean isSubtype(JvmTypeReference t1, JvmTypeReference t2, EObject context) {
        boolean bl = false;
        if (t1 == null || t2 == null) {
            return false;
        }
        LightweightTypeReference type1 = this.toLightweightTypeReference(t1, context);
        LightweightTypeReference type2 = this.toLightweightTypeReference(t2, context);
        bl = type2.isAssignableFrom(type1);
        return bl;
    }

    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, EObject context) {
        return this.newTypeReferenceOwner(context).toLightweightTypeReference(typeRef);
    }

    protected StandardTypeReferenceOwner newTypeReferenceOwner(EObject context) {
        return new StandardTypeReferenceOwner(this.services, context);
    }

    public boolean isPredicate(JudgmentDescription j) {
        boolean bl = false;
        if (j == null) {
            return false;
        }
        bl = this._xsemanticsUtils.outputJudgmentParameters(j).isEmpty();
        return bl;
    }

    public boolean isPredicate(RuleInvocation ruleInvocation) {
        return this.isPredicate(this._xsemanticsUtils.getJudgmentDescription(ruleInvocation));
    }

    public JvmTypeReference ruleFailedExceptionType(EObject o) {
        return this.typeReferences.getTypeForName(RuleFailedException.class, (Notifier)o, new JvmTypeReference[0]);
    }
}

