/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.typing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.dsl.typing.XsemanticsTypeSystem;
import org.eclipse.xsemantics.dsl.util.XsemanticsUtils;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.CheckRule;
import org.eclipse.xsemantics.dsl.xsemantics.EmptyEnvironment;
import org.eclipse.xsemantics.dsl.xsemantics.EnvironmentComposition;
import org.eclipse.xsemantics.dsl.xsemantics.EnvironmentMapping;
import org.eclipse.xsemantics.dsl.xsemantics.ErrorSpecification;
import org.eclipse.xsemantics.dsl.xsemantics.Fail;
import org.eclipse.xsemantics.dsl.xsemantics.OrExpression;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleParameter;
import org.eclipse.xsemantics.dsl.xsemantics.RuleWithPremises;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.annotations.typesystem.XbaseWithAnnotationsTypeComputer;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

@Singleton
public class XsemanticsTypeComputer
extends XbaseWithAnnotationsTypeComputer {
    @Inject
    @Extension
    private XsemanticsUtils _xsemanticsUtils;
    @Inject
    @Extension
    private XsemanticsTypeSystem _xsemanticsTypeSystem;

    public void computeTypes(XExpression expression, ITypeComputationState state) {
        boolean bl = false;
        if (expression instanceof RuleInvocation) {
            bl = true;
            this._computeTypes((RuleInvocation)expression, state);
        }
        if (!bl && expression instanceof OrExpression) {
            bl = true;
            this._computeTypes((OrExpression)expression, state);
        }
        if (!bl && expression instanceof Fail) {
            bl = true;
            this._computeTypes((Fail)expression, state);
        }
        if (!bl && expression instanceof ErrorSpecification) {
            bl = true;
            this._computeTypes((ErrorSpecification)expression, state);
        }
        if (!bl) {
            super.computeTypes(expression, state);
        }
    }

    public void _computeTypes(XBlockExpression b, ITypeComputationState typeState) {
        Object object;
        Object object2;
        EObject eObject;
        EObject eObject2;
        ITypeComputationState state = typeState;
        if (b.eContainer() instanceof Rule || b.eContainer() instanceof CheckRule) {
            state = state.withoutRootExpectation();
        }
        if ((eObject2 = b.eContainer()) instanceof AuxiliaryFunction) {
            Iterator type;
            eObject = b.eContainer();
            AuxiliaryFunction aux = (AuxiliaryFunction)eObject;
            AuxiliaryDescription auxiliaryDescription = this._xsemanticsUtils.getAuxiliaryDescription(aux);
            object2 = null;
            if (auxiliaryDescription != null) {
                object2 = auxiliaryDescription.getType();
            }
            if ((type = object2) == null) {
                state = state.withExpectation(this.getPrimitiveVoid(state));
            }
        }
        if ((eObject = b.eContainer()) instanceof RuleWithPremises) {
            object = b.eContainer();
            RuleWithPremises rule = (RuleWithPremises)object;
            object2 = this._xsemanticsUtils.outputParams(rule);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                RuleParameter outputParam = (RuleParameter)iterator.next();
                state.addLocalToCurrentScope((JvmIdentifiableElement)outputParam.getParameter());
            }
        }
        object = state.getExpectations();
        object2 = object.iterator();
        while (object2.hasNext()) {
            boolean bl;
            boolean bl2;
            ITypeExpectation expectation = (ITypeExpectation)object2.next();
            LightweightTypeReference expectedType = expectation.getExpectedType();
            if (expectedType != null && expectedType.isPrimitiveVoid()) {
                EList expressions = b.getExpressions();
                bl2 = expressions.isEmpty();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    for (XExpression expression : expressions) {
                        ITypeComputationState expressionState = state.withoutExpectation();
                        expressionState.computeTypes(expression);
                        this.addVariableDeclarationsToScope(expression, state);
                    }
                }
                expectation.acceptActualType(this.getPrimitiveVoid(state), new ConformanceHint[]{ConformanceHint.CHECKED, ConformanceHint.SUCCESS});
                continue;
            }
            EList expressions_1 = b.getExpressions();
            bl2 = expressions_1.isEmpty();
            boolean bl4 = bl = !bl2;
            if (bl) {
                int n = expressions_1.size();
                int n2 = n - 1;
                List list = expressions_1.subList(0, n2);
                for (XExpression expression_1 : list) {
                    ITypeComputationState expressionState = state.withoutExpectation();
                    expressionState.computeTypes(expression_1);
                    this.addVariableDeclarationsToScope(expression_1, state);
                }
                XExpression lastExpression = (XExpression)IterableExtensions.last((Iterable)expressions_1);
                state.computeTypes(lastExpression);
                this.addVariableDeclarationsToScope(lastExpression, state);
                continue;
            }
            ITypeReferenceOwner iTypeReferenceOwner = expectation.getReferenceOwner();
            Iterator iterator = new AnyTypeReference(iTypeReferenceOwner);
            expectation.acceptActualType((LightweightTypeReference)iterator, new ConformanceHint[]{ConformanceHint.UNCHECKED});
        }
    }

    protected void addVariableDeclarationsToScope(XExpression e, ITypeComputationState state) {
        boolean bl = false;
        if (e instanceof XVariableDeclaration) {
            bl = true;
            this.addLocalToCurrentScope((XVariableDeclaration)e, state);
        }
        if (!bl && e instanceof RuleInvocation) {
            bl = true;
            EList<XExpression> eList = ((RuleInvocation)e).getExpressions();
            for (XExpression exp : eList) {
                if (!(exp instanceof XVariableDeclaration)) continue;
                this.addLocalToCurrentScope((XVariableDeclaration)exp, state);
            }
        }
    }

    protected void _computeTypes(RuleInvocation e, ITypeComputationState state) {
        EList<XExpression> eList = e.getExpressions();
        for (XExpression expression : eList) {
            ITypeComputationState expressionState = state.withoutExpectation();
            expressionState.computeTypes(expression);
        }
        this.handleEnvironmentSpecification(e.getEnvironment(), state.withExpectation(this.getTypeForName(RuleEnvironment.class, state)));
        if (this.hasTypeExpectations(state) && this._xsemanticsTypeSystem.isPredicate(e)) {
            state.acceptActualType(this.getTypeForName(Boolean.TYPE, state));
        } else {
            state.acceptActualType(this.getPrimitiveVoid(state));
        }
    }

    protected boolean hasTypeExpectations(ITypeComputationState state) {
        boolean bl = state.getExpectations().isEmpty();
        return !bl;
    }

    protected void _computeTypes(OrExpression e, ITypeComputationState state) {
        boolean firstBranch = true;
        EList<XExpression> eList = e.getBranches();
        for (XExpression b : eList) {
            ITypeComputationState s = state.withoutExpectation();
            if (!firstBranch && this._xsemanticsUtils.containingOrExpression(e.eContainer()) == null) {
                XVariableDeclaration xVariableDeclaration = XbaseFactory.eINSTANCE.createXVariableDeclaration();
                Procedures.Procedure1 procedure1 = it -> {
                    it.setWriteable(false);
                    it.setName("previousFailure");
                };
                XVariableDeclaration implicitVar = (XVariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)xVariableDeclaration, (Procedures.Procedure1)procedure1);
                EList eList2 = e.eResource().getContents();
                eList2.add((Object)implicitVar);
                s = s.assignType((JvmIdentifiableElement)implicitVar, this._xsemanticsTypeSystem.toLightweightTypeReference(this._xsemanticsTypeSystem.ruleFailedExceptionType((EObject)e), (EObject)e));
            }
            firstBranch = false;
            this.computeTypes(b, s);
        }
        state.acceptActualType(this.getPrimitiveVoid(state));
    }

    protected void _handleEnvironmentSpecification(EmptyEnvironment e, ITypeComputationState state) {
        state.acceptActualType(this.getTypeForName(RuleEnvironment.class, state));
    }

    protected void _handleEnvironmentSpecification(EnvironmentComposition e, ITypeComputationState state) {
        this.handleEnvironmentSpecification(e.getCurrentEnvironment(), state);
        this.handleEnvironmentSpecification(e.getSubEnvironment(), state);
    }

    protected void _handleEnvironmentSpecification(EnvironmentMapping e, ITypeComputationState state) {
        state.withNonVoidExpectation().computeTypes(e.getKey());
        state.withNonVoidExpectation().computeTypes(e.getValue());
    }

    protected void _handleEnvironmentSpecification(XExpression e, ITypeComputationState state) {
        state.computeTypes(e);
    }

    protected void _computeTypes(Fail e, ITypeComputationState state) {
        XExpression xExpression = e.getError();
        if (xExpression != null) {
            this.computeTypes(xExpression, state);
        }
        state.acceptActualType(this.getPrimitiveVoid(state));
    }

    protected void _computeTypes(ErrorSpecification e, ITypeComputationState state) {
        XExpression xExpression;
        boolean bl;
        XExpression xExpression2;
        boolean bl2;
        XExpression xExpression3;
        boolean bl3;
        boolean bl4;
        XExpression xExpression4 = e.getError();
        boolean bl5 = bl4 = xExpression4 != null;
        if (bl4) {
            state.withExpectation(this.getTypeForName(String.class, state)).computeTypes(e.getError());
        }
        boolean bl6 = bl3 = (xExpression3 = e.getSource()) != null;
        if (bl3) {
            state.withExpectation(this.getTypeForName(EObject.class, state)).computeTypes(e.getSource());
        }
        boolean bl7 = bl2 = (xExpression2 = e.getFeature()) != null;
        if (bl2) {
            state.withExpectation(this.getTypeForName(EStructuralFeature.class, state)).computeTypes(e.getFeature());
        }
        boolean bl8 = bl = (xExpression = e.getData()) != null;
        if (bl) {
            state.withNonVoidExpectation().computeTypes(e.getData());
        }
        state.acceptActualType(this.getPrimitiveVoid(state));
    }

    protected void handleEnvironmentSpecification(XExpression e, ITypeComputationState state) {
        if (e instanceof EmptyEnvironment) {
            this._handleEnvironmentSpecification((EmptyEnvironment)e, state);
            return;
        }
        if (e instanceof EnvironmentComposition) {
            this._handleEnvironmentSpecification((EnvironmentComposition)e, state);
            return;
        }
        if (e instanceof EnvironmentMapping) {
            this._handleEnvironmentSpecification((EnvironmentMapping)e, state);
            return;
        }
        if (e != null) {
            this._handleEnvironmentSpecification(e, state);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, state).toString());
    }
}

