/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.generator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsemantics.dsl.generator.XsemanticsGeneratorExtensions;
import org.eclipse.xsemantics.dsl.typing.XsemanticsTypeSystem;
import org.eclipse.xsemantics.dsl.util.XsemanticsNodeModelUtils;
import org.eclipse.xsemantics.dsl.util.XsemanticsUtils;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.CachedClause;
import org.eclipse.xsemantics.dsl.xsemantics.CheckRule;
import org.eclipse.xsemantics.dsl.xsemantics.Description;
import org.eclipse.xsemantics.dsl.xsemantics.EmptyEnvironment;
import org.eclipse.xsemantics.dsl.xsemantics.EnvironmentComposition;
import org.eclipse.xsemantics.dsl.xsemantics.EnvironmentMapping;
import org.eclipse.xsemantics.dsl.xsemantics.ErrorSpecification;
import org.eclipse.xsemantics.dsl.xsemantics.Fail;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentDescription;
import org.eclipse.xsemantics.dsl.xsemantics.OrExpression;
import org.eclipse.xsemantics.dsl.xsemantics.ReferToJudgment;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleConclusion;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleWithPremises;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XsemanticsXbaseCompiler
extends XbaseCompiler {
    @Inject
    @Extension
    private XsemanticsUtils _xsemanticsUtils;
    @Inject
    @Extension
    private XsemanticsGeneratorExtensions _xsemanticsGeneratorExtensions;
    @Inject
    @Extension
    private XsemanticsNodeModelUtils _xsemanticsNodeModelUtils;
    @Inject
    @Extension
    private XsemanticsTypeSystem typeSystem;
    @Inject
    private TypeReferences typeReferences;

    public ITreeAppendable compile(XExpression obj, ITreeAppendable appendable, JvmTypeReference expectedReturnType, Set<JvmTypeReference> declaredExceptions) {
        EObject rule = obj.eContainer();
        boolean bl = false;
        if (rule instanceof RuleWithPremises) {
            bl = true;
            this._xsemanticsGeneratorExtensions.declareVariablesForOutputParams((Rule)rule, appendable);
            this.compileRuleBody((RuleWithPremises)rule, this._xsemanticsGeneratorExtensions.resultType(this._xsemanticsUtils.getJudgmentDescription((ReferToJudgment)rule)), appendable);
            return appendable;
        }
        if (!bl && rule instanceof CheckRule) {
            boolean bl2;
            bl = true;
            this.compilePremises((CheckRule)rule, appendable);
            boolean bl3 = appendable.toString().isEmpty();
            boolean bl4 = bl2 = !bl3;
            if (bl2) {
                appendable.newLine();
            }
            appendable.append((CharSequence)"return new ");
            this._xsemanticsGeneratorExtensions.resultType((CheckRule)rule, (IAppendable)appendable);
            appendable.append((CharSequence)"(true);");
            return appendable;
        }
        if (!bl && rule instanceof AuxiliaryFunction) {
            boolean bl5;
            bl = true;
            JvmTypeReference jvmTypeReference = this._xsemanticsUtils.getAuxiliaryDescription((AuxiliaryFunction)rule).getType();
            boolean bl6 = bl5 = jvmTypeReference != null;
            if (bl5) {
                return super.compile(obj, appendable, expectedReturnType, declaredExceptions);
            }
            this.internalToJavaStatement(obj, appendable, false);
            appendable.newLine().append((CharSequence)"return true;");
            return appendable;
        }
        if (obj instanceof ErrorSpecification) {
            String error = this.compileErrorOfErrorSpecification((ErrorSpecification)obj, appendable);
            String source = this.compileSourceOfErrorSpecification((ErrorSpecification)obj, appendable);
            String feature = this.compileFeatureOfErrorSpecification((ErrorSpecification)obj, appendable);
            String data = this.compileDataOfErrorSpecification((ErrorSpecification)obj, appendable);
            appendable.newLine();
            this.compileFinalPartOfThrowExceptionMethod(((ErrorSpecification)obj).eContainer(), appendable, error, source, feature, data);
            return appendable;
        }
        return super.compile(obj, appendable, expectedReturnType, declaredExceptions);
    }

    public void compileRuleBody(RuleWithPremises rule, JvmTypeReference resultType, ITreeAppendable result) {
        this.compilePremises(rule, result);
        this._xsemanticsGeneratorExtensions.compileReturnResult(rule, resultType, result);
    }

    public void compilePremises(RuleWithPremises rule, ITreeAppendable result) {
        this.toJavaStatement(rule.getPremises(), result, false);
    }

    public void compilePremises(CheckRule rule, ITreeAppendable result) {
        this.toJavaStatement(rule.getPremises(), result, false);
    }

    protected ITreeAppendable _compileFinalPartOfThrowExceptionMethod(Description desc, ITreeAppendable a, String error, String source, String feature, String data) {
        ITreeAppendable iTreeAppendable = null;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this._xsemanticsGeneratorExtensions.throwRuleFailedExceptionMethod();
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("(");
        stringConcatenation.append(error);
        stringConcatenation.append(",");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("_issue, _ex, new ");
        a.append((CharSequence)stringConcatenation);
        this.serialize(this._xsemanticsGeneratorExtensions.errorInformationType(desc), desc, a);
        iTreeAppendable = this.compileArgsForErrorInformationConstructor(a, source, feature, data);
        return iTreeAppendable;
    }

    protected ITreeAppendable _compileFinalPartOfThrowExceptionMethod(RuleConclusion ruleConclusion, ITreeAppendable a, String error, String source, String feature, String data) {
        ITreeAppendable iTreeAppendable = null;
        Rule rule = this._xsemanticsUtils.containingRule(ruleConclusion);
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this._xsemanticsGeneratorExtensions.throwRuleFailedExceptionMethod();
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("(");
        stringConcatenation.append(error);
        stringConcatenation.append(",");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string = this._xsemanticsGeneratorExtensions.ruleIssueString(rule);
        stringConcatenation.append(string, "\t");
        stringConcatenation.append(", e_");
        CharSequence charSequence2 = this._xsemanticsGeneratorExtensions.applyRuleName(rule);
        stringConcatenation.append((Object)charSequence2, "\t");
        stringConcatenation.append(", new ");
        a.append((CharSequence)stringConcatenation);
        this.serialize(this._xsemanticsGeneratorExtensions.errorInformationType(rule), rule, a);
        iTreeAppendable = this.compileArgsForErrorInformationConstructor(a, source, feature, data);
        return iTreeAppendable;
    }

    private ITreeAppendable compileArgsForErrorInformationConstructor(ITreeAppendable a, String source, String feature, String data) {
        ITreeAppendable iTreeAppendable = null;
        boolean bl = data.isEmpty();
        if (bl) {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("(");
            stringConcatenation.append(source);
            stringConcatenation.append(", ");
            stringConcatenation.append(feature);
            stringConcatenation.append("));");
            iTreeAppendable = a.append((CharSequence)stringConcatenation);
        } else {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("(");
            stringConcatenation.append(source);
            stringConcatenation.append(", ");
            stringConcatenation.append(feature);
            stringConcatenation.append(", ");
            stringConcatenation.append(data);
            stringConcatenation.append("));");
            iTreeAppendable = a.append((CharSequence)stringConcatenation);
        }
        return iTreeAppendable;
    }

    public String compileErrorOfErrorSpecification(ErrorSpecification errorSpecification, ITreeAppendable b) {
        return this.compileAndAssignToLocalVariable(errorSpecification.getError(), b, this.typeReferences.getTypeForName(String.class, (Notifier)errorSpecification, new JvmTypeReference[0]), "error");
    }

    public String compileSourceOfErrorSpecification(ErrorSpecification errorSpecification, ITreeAppendable b) {
        return this.compileAndAssignToLocalVariable(errorSpecification.getSource(), b, this.typeReferences.getTypeForName(EObject.class, (Notifier)errorSpecification, new JvmTypeReference[0]), "source");
    }

    public String compileFeatureOfErrorSpecification(ErrorSpecification errorSpecification, ITreeAppendable b) {
        return this.compileAndAssignToLocalVariable(errorSpecification.getFeature(), b, this.typeReferences.getTypeForName(EStructuralFeature.class, (Notifier)errorSpecification, new JvmTypeReference[0]), "feature");
    }

    public String compileDataOfErrorSpecification(ErrorSpecification errorSpecification, ITreeAppendable b) {
        boolean bl;
        XExpression xExpression = errorSpecification.getData();
        boolean bl2 = bl = xExpression == null;
        if (bl) {
            return "";
        }
        return this.compileAndAssignToLocalVariable(errorSpecification.getData(), b, this.typeReferences.getTypeForName(Object.class, (Notifier)errorSpecification, new JvmTypeReference[0]), "data");
    }

    protected String compileAndAssignToLocalVariable(XExpression expression, ITreeAppendable b, JvmTypeReference expectedType, String proposedVariable) {
        if (expression == null) {
            return "null";
        }
        this.toJavaStatement(expression, b, true);
        Object syntheticObject = new Object();
        String varName = b.declareSyntheticVariable(syntheticObject, proposedVariable);
        b.append((CharSequence)"\n");
        this.serialize(expectedType, (EObject)expression, b);
        b.append((CharSequence)" ").append((CharSequence)varName).append((CharSequence)" = ");
        this.toJavaExpression(expression, b);
        b.append((CharSequence)";");
        return b.getName(syntheticObject);
    }

    protected void _toJavaStatement(XBlockExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (this.insideClosure((XExpression)expr) || this.insideCachedCondition((XExpression)expr)) {
            super._toJavaStatement(expr, b, isReferenced);
        } else {
            boolean needsBraces;
            boolean bl;
            boolean bl2 = expr.getExpressions().isEmpty();
            if (bl2) {
                return;
            }
            int n = expr.getExpressions().size();
            boolean bl3 = bl = n == 1;
            if (bl) {
                this.compileBooleanXExpression((XExpression)expr.getExpressions().get(0), b, isReferenced);
                return;
            }
            if (isReferenced) {
                this.declareSyntheticVariable((XExpression)expr, b);
            }
            if (needsBraces = isReferenced) {
                b.newLine().append((CharSequence)"{").increaseIndentation();
                b.openPseudoScope();
            }
            EList expressions = expr.getExpressions();
            int i = 0;
            for (XExpression ex : expressions) {
                boolean bl4;
                boolean hasToBeReferenced = isReferenced;
                int n2 = expressions.size();
                int n3 = n2 - 1;
                boolean bl5 = bl4 = i < n3;
                if (bl4) {
                    hasToBeReferenced = false;
                }
                this.compileBooleanXExpression(ex, b, hasToBeReferenced);
                if (hasToBeReferenced) {
                    b.append((CharSequence)"\n").append((CharSequence)this.getVarName(expr, b)).append((CharSequence)" = (");
                    this.internalToConvertedExpression(ex, b, null);
                    b.append((CharSequence)");");
                }
                ++i;
            }
            if (needsBraces) {
                b.closeScope();
                b.decreaseIndentation().newLine().append((CharSequence)"}");
            }
        }
    }

    public void compileBooleanXExpression(XExpression expression, ITreeAppendable b, boolean toBeReferenced) {
        boolean hasToBeReferenced = toBeReferenced;
        if (expression instanceof XBlockExpression) {
            this.internalToJavaStatement(expression, b, hasToBeReferenced);
            return;
        }
        boolean isBoolean = this.typeSystem.isBooleanPremise(expression);
        if (isBoolean) {
            hasToBeReferenced = true;
        }
        this.internalToJavaStatement(expression, b, hasToBeReferenced);
        if (isBoolean) {
            this.generateCommentWithOriginalCode((EObject)expression, b);
            this.newLine(b);
            b.append((CharSequence)"if (!");
            this.toJavaExpression(expression, b);
            b.append((CharSequence)") {");
            b.increaseIndentation();
            this.newLine(b);
            this.throwNewRuleFailedException(expression, b);
            this.closeBracket(b);
        }
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b, boolean recursive) {
        int n;
        int n2;
        EList siblings;
        XExpression xExpression;
        boolean bl;
        EObject container;
        boolean bl2 = this.typeSystem.isBooleanPremise(expr);
        if (bl2 && (container = expr.eContainer()) instanceof XBlockExpression && (bl = Objects.equal((Object)(xExpression = (XExpression)(siblings = ((XBlockExpression)container).getExpressions()).get(n2 = (n = siblings.size()) - 1)), (Object)expr))) {
            EObject eObject = ((XBlockExpression)container).eContainer();
            return eObject instanceof AuxiliaryFunction;
        }
        return super.isVariableDeclarationRequired(expr, b, recursive);
    }

    protected void appendFeatureCall(XAbstractFeatureCall call, ITreeAppendable b) {
        JvmIdentifiableElement feature = call.getFeature();
        AuxiliaryDescription auxiliaryDescription = this._xsemanticsGeneratorExtensions.associatedAuxiliaryDescription(feature);
        if (auxiliaryDescription == null) {
            super.appendFeatureCall(call, b);
            return;
        }
        CharSequence name = this._xsemanticsGeneratorExtensions.entryPointInternalMethodName(auxiliaryDescription);
        b.trace((EObject)call, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append(name);
        if (feature instanceof JvmExecutable) {
            boolean bl;
            b.append((CharSequence)"(");
            b.append(this._xsemanticsGeneratorExtensions.ruleApplicationTraceName());
            EList arguments = call.getActualArguments();
            boolean bl2 = arguments.isEmpty();
            boolean bl3 = bl = !bl2;
            if (bl) {
                b.append((CharSequence)", ");
                XExpression xExpression = null;
                xExpression = call instanceof XMemberFeatureCall ? ((XMemberFeatureCall)call).getMemberCallTarget() : null;
                XExpression receiver = xExpression;
                boolean shouldBreakFirstArgument = receiver == null || !Objects.equal((Object)arguments.get(0), (Object)receiver);
                this.appendArguments((List)arguments, b, shouldBreakFirstArgument);
            }
            b.append((CharSequence)")");
        }
    }

    public void throwNewRuleFailedException(XExpression expression, ITreeAppendable b) {
        b.append((CharSequence)this._xsemanticsGeneratorExtensions.sneakyThrowRuleFailedException());
        b.append((CharSequence)"(");
        this.generateStringWithOriginalCode((EObject)expression, b);
        b.append((CharSequence)");");
    }

    protected void _doInternalToJavaStatement(XExpression e, ITreeAppendable b, boolean isReferenced) {
        super.doInternalToJavaStatement(e, b, isReferenced);
    }

    protected void _internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        super.internalToConvertedExpression(obj, appendable);
    }

    protected void _doInternalToJavaStatement(OrExpression orExpression, ITreeAppendable b, boolean isReferenced) {
        this.generateCommentWithOriginalCode((EObject)orExpression, b);
        this.openBracket(b);
        boolean bl = this.previousFailureMustBeDeclared(orExpression);
        if (bl) {
            this.declarePreviousFailureVariable(orExpression, b);
        }
        XExpression left = (XExpression)orExpression.getBranches().get(0);
        XExpression right = (XExpression)orExpression.getBranches().get(1);
        this.tryStmnt(b);
        this.compileBooleanXExpression(left, b, false);
        this.catchStmnt(b, orExpression);
        this.compileBooleanXExpression(right, b, false);
        this.closeBracket(b);
        this.closeBracket(b);
    }

    private ITreeAppendable declarePreviousFailureVariable(OrExpression orExpression, ITreeAppendable b) {
        ITreeAppendable iTreeAppendable = null;
        b.newLine();
        b.declareVariable((Object)orExpression, "previousFailure");
        b.append(this.typeSystem.ruleFailedExceptionType((EObject)orExpression).getType());
        iTreeAppendable = b.append((CharSequence)" previousFailure = null;");
        return iTreeAppendable;
    }

    private boolean previousFailureMustBeDeclared(OrExpression e) {
        EObject container = e.eContainer();
        while (container != null) {
            if (container instanceof OrExpression) {
                return false;
            }
            if (container instanceof XClosure) {
                return true;
            }
            container = container.eContainer();
        }
        return true;
    }

    protected boolean canCompileToJavaLambda(XClosure closure, LightweightTypeReference typeRef, JvmOperation operation) {
        return EcoreUtil2.getContainerOfType((EObject)closure, OrExpression.class) == null && super.canCompileToJavaLambda(closure, typeRef, operation);
    }

    protected void _doInternalToJavaStatement(Fail fail, ITreeAppendable b, boolean isReference) {
        this.generateCommentWithOriginalCode((EObject)fail, b);
        XExpression errorSpecification = fail.getError();
        if (errorSpecification == null) {
            this.newLine(b);
            b.append((CharSequence)"throwForExplicitFail();");
        } else {
            this.toJavaStatement(errorSpecification, b, isReference);
        }
    }

    protected void _doInternalToJavaStatement(ErrorSpecification errorSpecification, ITreeAppendable b, boolean isReference) {
        boolean bl;
        String errorMessageVar = this.compileErrorOfErrorSpecification(errorSpecification, b);
        String sourceVar = this.compileSourceOfErrorSpecification(errorSpecification, b);
        String featureVar = this.compileFeatureOfErrorSpecification(errorSpecification, b);
        String dataVar = this.compileDataOfErrorSpecification(errorSpecification, b);
        this.newLine(b);
        b.append((CharSequence)"throwForExplicitFail(");
        b.append((CharSequence)errorMessageVar);
        this.comma(b);
        b.append((CharSequence)"new ");
        b.append(this._xsemanticsGeneratorExtensions.errorInformationType((EObject)errorSpecification).getType());
        b.append((CharSequence)"(");
        b.append((CharSequence)sourceVar);
        this.comma(b);
        b.append((CharSequence)featureVar);
        boolean bl2 = dataVar.isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            this.comma(b);
            b.append((CharSequence)dataVar);
        }
        b.append((CharSequence)")");
        b.append((CharSequence)");");
    }

    protected void _doInternalToJavaStatement(RuleInvocation ruleInvocation, ITreeAppendable b, boolean isReferenced) {
        this.generateCommentWithOriginalCode(ruleInvocation, b);
        JudgmentDescription judgmentDescription = this._xsemanticsUtils.getJudgmentDescription(ruleInvocation);
        EList<XExpression> ruleInvocationExpressions = ruleInvocation.getExpressions();
        this.ruleInvocationExpressionsToJavaStatements(b, (List<XExpression>)ruleInvocationExpressions);
        this.generateEnvironmentSpecificationAsStatements(ruleInvocation.getEnvironment(), b);
        if (isReferenced) {
            Later later = it -> {
                it.append((CharSequence)this._xsemanticsGeneratorExtensions.succeededMethodName(judgmentDescription).toString());
                it.append((CharSequence)"(");
                this.generateEnvironmentSpecificationAsExpression(ruleInvocation.getEnvironment(), it);
                this.comma(it);
                it.append((CharSequence)this._xsemanticsGeneratorExtensions.additionalArgsForRuleInvocation(ruleInvocation).toString());
                this.comma(it);
                this.ruleInvocationArgumentsToJavaExpressions(it, ruleInvocation);
                it.append((CharSequence)")");
            };
            this.declareFreshLocalVariable(ruleInvocation, b, later);
        } else {
            boolean hasOutputParams = this._xsemanticsUtils.hasOutputParams(ruleInvocation);
            this.newLine(b);
            String resultVariable = "";
            if (hasOutputParams) {
                this._xsemanticsGeneratorExtensions.resultType(judgmentDescription, (IAppendable)b);
                this.space(b);
                resultVariable = this.generateResultVariable(ruleInvocation, b);
                this.assign(b);
            }
            b.append((CharSequence)this._xsemanticsGeneratorExtensions.entryPointInternalMethodName(judgmentDescription).toString());
            b.append((CharSequence)"(");
            this.generateEnvironmentSpecificationAsExpression(ruleInvocation.getEnvironment(), b);
            this.comma(b);
            b.append((CharSequence)this._xsemanticsGeneratorExtensions.additionalArgsForRuleInvocation(ruleInvocation).toString());
            this.comma(b);
            this.ruleInvocationArgumentsToJavaExpressions(b, ruleInvocation);
            b.append((CharSequence)");");
            if (hasOutputParams) {
                this.reassignResults(b, ruleInvocation, resultVariable);
            }
        }
    }

    protected void ruleInvocationExpressionsToJavaStatements(ITreeAppendable b, List<XExpression> ruleInvocationExpressions) {
        for (XExpression ruleInvocationExpression : ruleInvocationExpressions) {
            this.toJavaStatement(ruleInvocationExpression, b, true);
        }
    }

    protected void generateEnvironmentSpecificationAsStatements(XExpression environmentSpecification, ITreeAppendable b) {
        if (environmentSpecification instanceof EmptyEnvironment) {
            return;
        }
        if (environmentSpecification instanceof EnvironmentMapping) {
            this.toJavaStatement(((EnvironmentMapping)environmentSpecification).getKey(), b, true);
            this.toJavaStatement(((EnvironmentMapping)environmentSpecification).getValue(), b, true);
        } else if (environmentSpecification instanceof EnvironmentComposition) {
            this.generateEnvironmentSpecificationAsStatements(((EnvironmentComposition)environmentSpecification).getCurrentEnvironment(), b);
            this.generateEnvironmentSpecificationAsStatements(((EnvironmentComposition)environmentSpecification).getSubEnvironment(), b);
        } else {
            this.toJavaStatement(environmentSpecification, b, true);
        }
    }

    public void generateEnvironmentSpecificationAsExpression(XExpression environmentSpecification, ITreeAppendable b) {
        if (environmentSpecification instanceof EnvironmentMapping) {
            b.append((CharSequence)this._xsemanticsGeneratorExtensions.environmentEntryInvocation());
            b.append((CharSequence)"(");
            this.toJavaExpression(((EnvironmentMapping)environmentSpecification).getKey(), b);
            this.comma(b);
            this.toJavaExpression(((EnvironmentMapping)environmentSpecification).getValue(), b);
            b.append((CharSequence)")");
        } else if (environmentSpecification instanceof EnvironmentComposition) {
            b.append((CharSequence)this._xsemanticsGeneratorExtensions.environmentCompositionInvocation());
            b.append((CharSequence)"(");
            b.increaseIndentation();
            this.newLine(b);
            this.generateEnvironmentSpecificationAsExpression(((EnvironmentComposition)environmentSpecification).getCurrentEnvironment(), b);
            this.comma(b);
            this.generateEnvironmentSpecificationAsExpression(((EnvironmentComposition)environmentSpecification).getSubEnvironment(), b);
            b.decreaseIndentation();
            this.newLine(b);
            b.append((CharSequence)")");
        } else {
            this.toJavaExpression(environmentSpecification, b);
        }
    }

    protected String generateResultVariable(RuleInvocation ruleInvocation, ITreeAppendable b) {
        String declareResultVariable = this.declareResultVariable(ruleInvocation, b);
        b.append((CharSequence)declareResultVariable);
        return declareResultVariable;
    }

    public String declareResultVariable(RuleInvocation ruleInvocation, ITreeAppendable b) {
        return b.declareSyntheticVariable((Object)ruleInvocation, "result");
    }

    protected void ruleInvocationArgumentsToJavaExpressions(ITreeAppendable b, RuleInvocation ruleInvocation) {
        this.ruleInvocationArgumentsToJavaExpressions(b, this._xsemanticsUtils.inputArgsExpressions(ruleInvocation));
    }

    protected void ruleInvocationArgumentsToJavaExpressions(ITreeAppendable b, Iterable<XExpression> inputArgsExpressions) {
        Iterator<XExpression> expIt = inputArgsExpressions.iterator();
        while (expIt.hasNext()) {
            this.toJavaExpression(expIt.next(), b);
            boolean bl = expIt.hasNext();
            if (!bl) continue;
            this.comma(b);
        }
    }

    protected void reassignResults(ITreeAppendable b, RuleInvocation ruleInvocation, String resultVariable) {
        ArrayList<XExpression> expressions = this._xsemanticsUtils.outputArgsExpressions(ruleInvocation);
        this.newLine(b);
        Iterator<String> getMethods = XsemanticsGeneratorExtensions.getResultGetMethods().iterator();
        for (XExpression expression : expressions) {
            JvmTypeReference expressionType = this.typeSystem.getType((EObject)expression);
            String getMethod = getMethods.next();
            b.append((CharSequence)"checkAssignableTo");
            b.append((CharSequence)"(");
            b.append((CharSequence)(String.valueOf(resultVariable) + "." + getMethod));
            this.comma(b);
            this.generateJavaClassReference(expressionType, expression, b);
            b.append((CharSequence)");");
            this.newLine(b);
            if (expression instanceof XVariableDeclaration) {
                b.append((CharSequence)b.getName((Object)expression));
            } else {
                this.toJavaExpression(expression, b);
            }
            this.assign(b);
            b.append((CharSequence)"(");
            this.serialize(expressionType, (EObject)expression, b);
            b.append((CharSequence)")");
            this.space(b);
            b.append((CharSequence)(String.valueOf(resultVariable) + "." + getMethod));
            b.append((CharSequence)";");
            this.newLine(b);
        }
    }

    protected void _internalToConvertedExpression(RuleInvocation ruleInvocation, ITreeAppendable b) {
        b.append((CharSequence)this.getVarName(ruleInvocation, b));
    }

    protected void _internalToConvertedExpression(EmptyEnvironment e, ITreeAppendable b) {
        b.append((CharSequence)this._xsemanticsGeneratorExtensions.emptyEnvironmentInvocation());
    }

    public void generateCommentWithOriginalCode(EObject modelElement, ITreeAppendable b) {
        b.append((CharSequence)"\n").append((CharSequence)"/* ").append((CharSequence)this._xsemanticsNodeModelUtils.getProgramText(modelElement)).append((CharSequence)" */");
    }

    public void generateStringWithOriginalCode(EObject modelElement, ITreeAppendable b) {
        b.append((CharSequence)"\"").append((CharSequence)this._xsemanticsGeneratorExtensions.javaString(this._xsemanticsNodeModelUtils.getProgramText(modelElement))).append((CharSequence)"\"");
    }

    public void comma(ITreeAppendable b) {
        b.append((CharSequence)", ");
    }

    public void newLine(ITreeAppendable b) {
        b.append((CharSequence)"\n");
    }

    public void space(ITreeAppendable b) {
        b.append((CharSequence)" ");
    }

    public void assign(ITreeAppendable b) {
        this.space(b);
        b.append((CharSequence)"=");
        this.space(b);
    }

    public void openBracket(ITreeAppendable b) {
        this.newLine(b);
        b.append((CharSequence)"{");
        b.increaseIndentation();
    }

    public void closeBracket(ITreeAppendable b) {
        b.decreaseIndentation();
        this.newLine(b);
        b.append((CharSequence)"}");
    }

    public void tryStmnt(ITreeAppendable b) {
        this.newLine(b);
        b.append((CharSequence)"try {");
        b.increaseIndentation();
    }

    public String catchStmnt(ITreeAppendable b, XExpression expression) {
        b.decreaseIndentation();
        this.newLine(b);
        b.append((CharSequence)"} catch (");
        b.append(this._xsemanticsGeneratorExtensions.exceptionType((EObject)expression).getType());
        b.append((CharSequence)" ");
        String declareExceptionVariable = this.declareExceptionVariable(expression, b);
        b.append((CharSequence)declareExceptionVariable);
        b.append((CharSequence)") {");
        b.increaseIndentation();
        b.newLine();
        b.append((CharSequence)("previousFailure = extractRuleFailedException(" + declareExceptionVariable + ");"));
        return declareExceptionVariable;
    }

    public String declareExceptionVariable(XExpression expression, ITreeAppendable b) {
        return b.declareSyntheticVariable((Object)expression, "e");
    }

    public void generateJavaClassReference(JvmTypeReference expressionType, XExpression expression, ITreeAppendable b) {
        b.append(expressionType.getType());
        b.append((CharSequence)".class");
    }

    public boolean insideClosure(XExpression expr) {
        EObject eObject = expr.eContainer();
        return eObject instanceof XClosure;
    }

    public boolean insideCachedCondition(XExpression expr) {
        CachedClause cachedClause = (CachedClause)EcoreUtil2.getContainerOfType((EObject)expr, CachedClause.class);
        return cachedClause != null;
    }

    public ITreeAppendable compileFinalPartOfThrowExceptionMethod(EObject desc, ITreeAppendable a, String error, String source, String feature, String data) {
        if (desc instanceof Description) {
            return this._compileFinalPartOfThrowExceptionMethod((Description)desc, a, error, source, feature, data);
        }
        if (desc instanceof RuleConclusion) {
            return this._compileFinalPartOfThrowExceptionMethod((RuleConclusion)desc, a, error, source, feature, data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(desc, a, error, source, feature, data).toString());
    }

    public void doInternalToJavaStatement(XExpression errorSpecification, ITreeAppendable b, boolean isReference) {
        if (errorSpecification instanceof ErrorSpecification) {
            this._doInternalToJavaStatement((ErrorSpecification)errorSpecification, b, isReference);
            return;
        }
        if (errorSpecification instanceof Fail) {
            this._doInternalToJavaStatement((Fail)errorSpecification, b, isReference);
            return;
        }
        if (errorSpecification instanceof OrExpression) {
            this._doInternalToJavaStatement((OrExpression)errorSpecification, b, isReference);
            return;
        }
        if (errorSpecification instanceof RuleInvocation) {
            this._doInternalToJavaStatement((RuleInvocation)errorSpecification, b, isReference);
            return;
        }
        if (errorSpecification != null) {
            this._doInternalToJavaStatement(errorSpecification, b, isReference);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(errorSpecification, b, isReference).toString());
    }

    public void internalToConvertedExpression(XExpression e, ITreeAppendable b) {
        if (e instanceof EmptyEnvironment) {
            this._internalToConvertedExpression((EmptyEnvironment)e, b);
            return;
        }
        if (e instanceof RuleInvocation) {
            this._internalToConvertedExpression((RuleInvocation)e, b);
            return;
        }
        if (e != null) {
            this._internalToConvertedExpression(e, b);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, b).toString());
    }
}

