/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.dsl.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsemantics.dsl.generator.UniqueNames;
import org.eclipse.xsemantics.dsl.typing.XsemanticsTypeSystem;
import org.eclipse.xsemantics.dsl.util.XsemanticsUtils;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryDescription;
import org.eclipse.xsemantics.dsl.xsemantics.AuxiliaryFunction;
import org.eclipse.xsemantics.dsl.xsemantics.Cachable;
import org.eclipse.xsemantics.dsl.xsemantics.CheckRule;
import org.eclipse.xsemantics.dsl.xsemantics.Description;
import org.eclipse.xsemantics.dsl.xsemantics.ExpressionInConclusion;
import org.eclipse.xsemantics.dsl.xsemantics.InputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentDescription;
import org.eclipse.xsemantics.dsl.xsemantics.JudgmentParameter;
import org.eclipse.xsemantics.dsl.xsemantics.Named;
import org.eclipse.xsemantics.dsl.xsemantics.OutputParameter;
import org.eclipse.xsemantics.dsl.xsemantics.Rule;
import org.eclipse.xsemantics.dsl.xsemantics.RuleConclusionElement;
import org.eclipse.xsemantics.dsl.xsemantics.RuleInvocation;
import org.eclipse.xsemantics.dsl.xsemantics.RuleParameter;
import org.eclipse.xsemantics.dsl.xsemantics.UniqueByName;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsSystem;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.Result;
import org.eclipse.xsemantics.runtime.Result2;
import org.eclipse.xsemantics.runtime.Result3;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class XsemanticsGeneratorExtensions {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private XsemanticsUtils _xsemanticsUtils;
    @Inject
    @Extension
    private XsemanticsTypeSystem typeSystem;
    @Inject
    @Extension
    private TypeReferenceSerializer _typeReferenceSerializer;
    @Inject
    @Extension
    private TypeReferences _typeReferences;
    @Inject
    protected IJvmModelAssociations associations;
    protected static final ArrayList<String> RESULT_GET_METHODS = CollectionLiterals.newArrayList((Object[])new String[]{"getFirst()", "getSecond()", "getThird()"});

    public static ArrayList<String> getResultGetMethods() {
        return RESULT_GET_METHODS;
    }

    public QualifiedName toJavaFullyQualifiedName(XsemanticsSystem ts) {
        return this._iQualifiedNameProvider.getFullyQualifiedName((EObject)ts);
    }

    public String toJavaFullyQualifiedName(Named e) {
        String string = null;
        QualifiedName fQN = this.toJavaFullyQualifiedName(this._xsemanticsUtils.containingSystem(e));
        String string2 = null;
        if (fQN != null && fQN.getSegmentCount() > 1) {
            QualifiedName qualifiedName = fQN.skipLast(1);
            String string3 = qualifiedName + ".";
            String string4 = this.toJavaClassName(e);
            string2 = String.valueOf(string3) + string4;
        } else {
            string2 = this.toJavaClassName(e);
        }
        string = string2;
        return string;
    }

    public String toJavaClassName(Named e) {
        return Strings.toFirstUpper((String)e.getName());
    }

    public String toValidatorPackage(XsemanticsSystem ts) {
        String string = null;
        QualifiedName typeSystemPackage = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)ts);
        String string2 = null;
        if (typeSystemPackage != null && typeSystemPackage.getSegmentCount() > 1) {
            QualifiedName qualifiedName = typeSystemPackage.skipLast(1);
            String string3 = qualifiedName + ".";
            string2 = String.valueOf(string3) + "validation";
        } else {
            string2 = "";
        }
        string = string2;
        return string;
    }

    public String toValidatorJavaClassName(XsemanticsSystem ts) {
        QualifiedName qualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)ts);
        String string = null;
        if (qualifiedName != null) {
            string = qualifiedName.getLastSegment();
        }
        return String.valueOf(string) + "Validator";
    }

    public String toValidatorJavaFullyQualifiedName(XsemanticsSystem ts) {
        boolean bl;
        String string = null;
        String validatorPackage = this.toValidatorPackage(ts);
        String string2 = null;
        int n = validatorPackage.length();
        boolean bl2 = bl = n > 0;
        if (bl) {
            String string3 = this.toValidatorJavaClassName(ts);
            string2 = String.valueOf(validatorPackage) + "." + string3;
        } else {
            string2 = this.toValidatorJavaClassName(ts);
        }
        string = string2;
        return string;
    }

    public String ruleIssueString(Named e) {
        return e.getName().toUpperCase();
    }

    public CharSequence polymorphicDispatcherField(UniqueByName e) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = e.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("Dispatcher");
        return stringConcatenation;
    }

    public String relationSymbolsArgs(JudgmentDescription judgmentDescription) {
        Functions.Function1 function1 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("\"");
            String string = this.escapeJavaStringChars((String)it);
            stringConcatenation.append(string);
            stringConcatenation.append("\"");
            return stringConcatenation.toString();
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(judgmentDescription.getRelationSymbols(), (Functions.Function1)function1), (CharSequence)", ");
    }

    public CharSequence polymorphicDispatcherImpl(JudgmentDescription judgmentDescription) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = judgmentDescription.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("Impl");
        return stringConcatenation;
    }

    public CharSequence polymorphicDispatcherBuildMethod(JudgmentDescription judgmentDescription) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("buildPolymorphicDispatcher");
        int n = this.polymorphicDispatcherBuildMethodSuffix(judgmentDescription);
        stringConcatenation.append((Object)n);
        return stringConcatenation;
    }

    public int polymorphicDispatcherBuildMethodSuffix(JudgmentDescription judgmentDescription) {
        int n = 0;
        int n2 = this._xsemanticsUtils.outputJudgmentParameters(judgmentDescription).size();
        boolean bl = n2 == 0;
        n = bl ? 1 : this._xsemanticsUtils.outputJudgmentParameters(judgmentDescription).size();
        return n;
    }

    public CharSequence polymorphicDispatcherImpl(AuxiliaryDescription aux) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = aux.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("Impl");
        return stringConcatenation;
    }

    public CharSequence polymorphicDispatcherNumOfArgs(JudgmentDescription judgmentDescription) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        int n = this._xsemanticsUtils.inputParams(judgmentDescription).size();
        int n2 = n + 2;
        stringConcatenation.append((Object)n2);
        return stringConcatenation;
    }

    public CharSequence polymorphicDispatcherNumOfArgs(AuxiliaryDescription aux) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        int n = aux.getParameters().size();
        int n2 = n + 1;
        stringConcatenation.append((Object)n2);
        return stringConcatenation;
    }

    public CharSequence entryPointMethodName(Description desc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = desc.getName();
        stringConcatenation.append(string);
        return stringConcatenation;
    }

    public CharSequence succeededMethodName(JudgmentDescription judgmentDescription) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = judgmentDescription.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("Succeeded");
        return stringConcatenation;
    }

    public String inputArgs(JudgmentDescription judgmentDescription) {
        String string = null;
        UniqueNames names = new UniqueNames();
        Functions.Function1 function1 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            String string = names.createName(this.inputParameterName((InputParameter)it));
            stringConcatenation.append(string);
            return stringConcatenation.toString();
        };
        string = IterableExtensions.join((Iterable)ListExtensions.map(this._xsemanticsUtils.inputParams(judgmentDescription), (Functions.Function1)function1), (CharSequence)", ");
        return string;
    }

    public String inputArgs(AuxiliaryDescription aux) {
        Functions.Function1 function1 = it -> it.getName();
        return IterableExtensions.join((Iterable)ListExtensions.map(aux.getParameters(), (Functions.Function1)function1), (CharSequence)", ");
    }

    public String inputParameterName(InputParameter param) {
        return param.getParameter().getName();
    }

    public CharSequence environmentName() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_environment_");
        return stringConcatenation;
    }

    public CharSequence entryPointInternalMethodName(JudgmentDescription judgmentDescription) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.entryPointMethodName(judgmentDescription);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("Internal");
        return stringConcatenation;
    }

    public CharSequence entryPointInternalMethodName(AuxiliaryDescription aux) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.entryPointMethodName(aux);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("Internal");
        return stringConcatenation;
    }

    public CharSequence additionalArgs() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.environmentName();
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append(", ");
        CharSequence charSequence2 = this.ruleApplicationTraceName();
        stringConcatenation.append((Object)charSequence2);
        return stringConcatenation;
    }

    public CharSequence ruleApplicationTraceName() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_trace_");
        return stringConcatenation;
    }

    public CharSequence ruleApplicationSubtraceName() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_subtrace_");
        return stringConcatenation;
    }

    public CharSequence exceptionVarName(UniqueByName e) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_e_");
        String string = e.getName();
        stringConcatenation.append(string);
        return stringConcatenation;
    }

    public String exceptionVarName(Rule rule) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("e_");
        CharSequence charSequence = this.applyRuleName(rule);
        stringConcatenation.append((Object)charSequence);
        return stringConcatenation.toString();
    }

    public String exceptionVarName(AuxiliaryFunction aux) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("e_");
        CharSequence charSequence = this.applyAuxFunName(aux);
        stringConcatenation.append((Object)charSequence);
        return stringConcatenation.toString();
    }

    public String suffixStartingFrom2(JudgmentDescription judgmentDescription) {
        String string = null;
        int numOfOutputParams = this._xsemanticsUtils.outputJudgmentParameters(judgmentDescription).size();
        String string2 = null;
        string2 = numOfOutputParams > 1 ? "" + Integer.valueOf(numOfOutputParams) : "";
        string = string2;
        return string;
    }

    public CharSequence throwExceptionMethod(UniqueByName e) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = Strings.toFirstLower((String)e.getName());
        stringConcatenation.append(string);
        stringConcatenation.append("ThrowException");
        return stringConcatenation;
    }

    public CharSequence cacheConditionMethod(Cachable c) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = Strings.toFirstLower((String)c.getName());
        stringConcatenation.append(string);
        stringConcatenation.append("CacheCondition");
        return stringConcatenation;
    }

    public CharSequence throwRuleFailedExceptionMethod() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("throwRuleFailedException");
        return stringConcatenation;
    }

    public CharSequence newTraceMethod(CharSequence trace) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("newTrace(");
        stringConcatenation.append((Object)trace);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence applyRuleName(Rule rule) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("applyRule");
        String string = this.toJavaClassName(rule);
        stringConcatenation.append(string);
        return stringConcatenation;
    }

    public CharSequence applyAuxFunName(AuxiliaryFunction aux) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("applyAuxFun");
        String string = this.toJavaClassName(aux);
        stringConcatenation.append(string);
        return stringConcatenation;
    }

    public CharSequence additionalArgsForRule(Rule rule) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = this.ruleEnvName(rule);
        stringConcatenation.append(string);
        stringConcatenation.append(", ");
        CharSequence charSequence = this.ruleApplicationSubtraceName();
        stringConcatenation.append((Object)charSequence);
        return stringConcatenation;
    }

    public CharSequence additionalArgsForRuleInvocation(RuleInvocation ruleInvocation) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.ruleApplicationTraceName();
        stringConcatenation.append((Object)charSequence);
        return stringConcatenation;
    }

    public String ruleEnvName(Rule rule) {
        return rule.getConclusion().getEnvironment().getName();
    }

    public StringConcatenationClient addToTraceMethod(final CharSequence trace, final CharSequence toAdd) {
        StringConcatenationClient stringConcatenationClient = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"addToTrace(");
                _builder.append((Object)trace);
                _builder.append((Object)", new ");
                _builder.append(Provider.class);
                _builder.append((Object)"<Object>() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"public Object get() {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append((Object)toAdd, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"})");
            }
        };
        return stringConcatenationClient;
    }

    public CharSequence addAsSubtraceMethod(CharSequence trace, CharSequence subtrace) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("addAsSubtrace(");
        stringConcatenation.append((Object)trace);
        stringConcatenation.append(", ");
        stringConcatenation.append((Object)subtrace);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public String traceStringForRule(Rule rule) {
        String string = null;
        Iterator<String> getMethods = XsemanticsGeneratorExtensions.getResultGetMethods().iterator();
        Functions.Function1 function1 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            CharSequence charSequence = this.resultVariableForTrace();
            stringConcatenation.append((Object)charSequence);
            stringConcatenation.append(".");
            String string = (String)getMethods.next();
            stringConcatenation.append(string);
            return this.wrapInStringRepr((CharSequence)stringConcatenation);
        };
        Functions.Function1 function12 = it -> this.wrapInStringRepr(this.ruleConclusionInputParamForError((RuleConclusionElement)it));
        string = this.stringForRule(rule, (Functions.Function1<? super RuleConclusionElement, ? extends CharSequence>)function1, (Functions.Function1<? super RuleConclusionElement, ? extends CharSequence>)function12);
        return string;
    }

    public String stringForRule(Rule rule, Functions.Function1<? super RuleConclusionElement, ? extends CharSequence> forOutput, Functions.Function1<? super RuleConclusionElement, ? extends CharSequence> forInput) {
        String string = null;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.ruleNameInvocation(rule.getName());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append(" + ");
        CharSequence charSequence2 = this.wrapInStringReprForEnv(this.ruleEnvName(rule));
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.append(" + \" ");
        String string2 = rule.getConclusion().getJudgmentSymbol();
        stringConcatenation.append(string2);
        stringConcatenation.append(" \"");
        StringBuffer buffer = new StringBuffer((CharSequence)stringConcatenation);
        Iterator judgmentParameters = this._xsemanticsUtils.getJudgmentDescription(rule).getJudgmentParameters().iterator();
        Iterator relationSymbols = rule.getConclusion().getRelationSymbols().iterator();
        EList<RuleConclusionElement> eList = rule.getConclusion().getConclusionElements();
        for (RuleConclusionElement e : eList) {
            buffer.append(" + ");
            boolean bl = this._xsemanticsUtils.isOutputParameter((JudgmentParameter)judgmentParameters.next());
            if (bl) {
                buffer.append((CharSequence)forOutput.apply((Object)e));
            } else {
                buffer.append((CharSequence)forInput.apply((Object)e));
            }
            boolean bl2 = relationSymbols.hasNext();
            if (!bl2) continue;
            StringConcatenation stringConcatenation2 = new StringConcatenation();
            stringConcatenation2.append(" ");
            stringConcatenation2.append("+ \" ");
            String string3 = this.escapeJavaStringChars((String)relationSymbols.next());
            stringConcatenation2.append(string3, " ");
            stringConcatenation2.append(" \"");
            buffer.append((CharSequence)stringConcatenation2);
        }
        string = buffer.toString();
        return string;
    }

    public String traceStringForAuxiliaryFun(AuxiliaryFunction aux) {
        String string = this.errorForAuxiliaryFun(aux);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(" ");
        stringConcatenation.append("+ \" = \" + ");
        String string2 = String.valueOf(string) + stringConcatenation;
        CharSequence charSequence = this.wrapInStringRepr(this.resultVariableForTrace());
        return String.valueOf(string2) + charSequence;
    }

    public CharSequence ruleNameInvocation(String ruleName) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("ruleName(\"");
        stringConcatenation.append(ruleName);
        stringConcatenation.append("\")");
        return stringConcatenation;
    }

    public CharSequence auxFunNameInvocation(String ruleName) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("auxFunName(\"");
        stringConcatenation.append(ruleName);
        stringConcatenation.append("\")");
        return stringConcatenation;
    }

    public CharSequence wrapInStringReprForEnv(CharSequence s) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.stringRepresentationForEnv();
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("(");
        stringConcatenation.append((Object)s);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence stringRepresentationForEnv() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("stringRepForEnv");
        return stringConcatenation;
    }

    public CharSequence stringRepresentation() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("stringRep");
        return stringConcatenation;
    }

    public CharSequence wrapInStringRepr(CharSequence s) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence = this.stringRepresentation();
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.append("(");
        stringConcatenation.append((Object)s);
        stringConcatenation.append(")");
        return stringConcatenation;
    }

    public CharSequence resultVariableForTrace() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("_result_");
        return stringConcatenation;
    }

    public String sneakyThrowRuleFailedException() {
        return "sneakyThrowRuleFailedException";
    }

    public String ruleConclusionInputParamForError(RuleConclusionElement element) {
        if (element instanceof RuleParameter) {
            return ((RuleParameter)element).getParameter().getName();
        }
        return "";
    }

    public String inputParameterNames(Rule rule) {
        Functions.Function1 function1 = it -> it.getParameter().getName();
        return IterableExtensions.join((Iterable)ListExtensions.map(this._xsemanticsUtils.inputParams(rule), (Functions.Function1)function1), (CharSequence)", ");
    }

    public String inputParameterNames(AuxiliaryFunction aux) {
        Functions.Function1 function1 = it -> it.getName();
        return IterableExtensions.join((Iterable)ListExtensions.map(aux.getParameters(), (Functions.Function1)function1), (CharSequence)", ");
    }

    public String errorForRule(Rule rule) {
        Functions.Function1 function1 = it -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("\"");
            String string = this.ruleConclusionOutputParamForError((RuleConclusionElement)it);
            stringConcatenation.append(string);
            stringConcatenation.append("\"");
            return stringConcatenation.toString();
        };
        Functions.Function1 function12 = it -> this.wrapInStringRepr(this.ruleConclusionInputParamForError((RuleConclusionElement)it));
        return this.stringForRule(rule, (Functions.Function1<? super RuleConclusionElement, ? extends CharSequence>)function1, (Functions.Function1<? super RuleConclusionElement, ? extends CharSequence>)function12);
    }

    public String errorForAuxiliaryFun(AuxiliaryFunction aux) {
        CharSequence charSequence = this.auxFunNameInvocation(this._xsemanticsUtils.getAuxiliaryDescription(aux).getName());
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append(" ");
        stringConcatenation.append("+ \"(\" + ");
        Functions.Function1 function1 = it -> this.wrapInStringRepr(it.getName());
        List list = ListExtensions.map(aux.getParameters(), (Functions.Function1)function1);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("+ \", \" + ");
        String string = IterableExtensions.join((Iterable)list, (CharSequence)stringConcatenation2);
        stringConcatenation.append(string, " ");
        stringConcatenation.append("+ \")\"");
        return charSequence + stringConcatenation.toString();
    }

    public String ruleConclusionOutputParamForError(RuleConclusionElement element) {
        String string = null;
        boolean bl = false;
        if (element instanceof RuleParameter) {
            bl = true;
            string = ((RuleParameter)element).getParameter().getParameterType().getSimpleName();
        }
        if (!bl && element instanceof ExpressionInConclusion) {
            bl = true;
            string = this.typeSystem.getType(element).getSimpleName();
        }
        return string;
    }

    public String javaString(String s) {
        return Strings.convertToJavaString((String)s);
    }

    public void resultType(JudgmentDescription judgmentDescription, IAppendable b) {
        this._typeReferenceSerializer.serialize(this.resultType(judgmentDescription), (EObject)judgmentDescription, b);
    }

    public JvmTypeReference resultType(JudgmentDescription e) {
        boolean bl;
        ArrayList<JvmTypeReference> resultTypeArguments = this.resultJvmTypeReferences(e);
        JvmTypeReference resultT = null;
        int n = resultTypeArguments.size();
        boolean bl2 = bl = n == 1;
        if (bl) {
            resultT = this._typeReferences.getTypeForName(Result.class, (Notifier)e, new JvmTypeReference[]{resultTypeArguments.get(0)});
        } else {
            boolean bl3;
            int n2 = resultTypeArguments.size();
            boolean bl4 = bl3 = n2 == 2;
            if (bl3) {
                resultT = this._typeReferences.getTypeForName(Result2.class, (Notifier)e, new JvmTypeReference[]{resultTypeArguments.get(0), resultTypeArguments.get(1)});
            } else {
                int n3 = resultTypeArguments.size();
                boolean bl5 = n3 == 3;
                resultT = bl5 ? this._typeReferences.getTypeForName(Result3.class, (Notifier)e, new JvmTypeReference[]{resultTypeArguments.get(0), resultTypeArguments.get(1), resultTypeArguments.get(2)}) : this._typeReferences.getTypeForName(Result.class, (Notifier)e, new JvmTypeReference[0]);
            }
        }
        return resultT;
    }

    public JvmTypeReference resultType(AuxiliaryDescription e) {
        return this.typeSystem.getType(e);
    }

    public JvmTypeReference resultType(AuxiliaryFunction e) {
        return this.typeSystem.getType(this._xsemanticsUtils.getAuxiliaryDescription(e));
    }

    public ArrayList<JvmTypeReference> resultJvmTypeReferences(JudgmentDescription e) {
        boolean bl;
        ArrayList arrayList = null;
        List<OutputParameter> outputParams = this._xsemanticsUtils.outputJudgmentParameters(e);
        ArrayList arrayList2 = null;
        int n = outputParams.size();
        boolean bl2 = bl = n == 0;
        if (bl) {
            arrayList2 = CollectionLiterals.newArrayList((Object[])new JvmTypeReference[]{this._typeReferences.getTypeForName(Boolean.class, (Notifier)e, new JvmTypeReference[0])});
        } else {
            Functions.Function1 function1 = it -> it.getJvmTypeReference() != null && it.getJvmTypeReference().getType() != null;
            Functions.Function1 function12 = it -> it.getJvmTypeReference();
            arrayList2 = CollectionLiterals.newArrayList((Object[])((JvmTypeReference[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filter(outputParams, (Functions.Function1)function1), (Functions.Function1)function12), JvmTypeReference.class)));
        }
        arrayList = arrayList2;
        return arrayList;
    }

    public void resultType(CheckRule checkRule, IAppendable b) {
        this._typeReferenceSerializer.serialize(this.resultType(checkRule), (EObject)checkRule, b);
    }

    public JvmTypeReference resultType(CheckRule checkRule) {
        return this._typeReferences.getTypeForName(Result.class, (Notifier)checkRule, new JvmTypeReference[]{this._typeReferences.getTypeForName(Boolean.class, (Notifier)checkRule, new JvmTypeReference[0])});
    }

    public JvmTypeReference errorInformationType(EObject o) {
        return this._typeReferences.getTypeForName(ErrorInformation.class, (Notifier)o, new JvmTypeReference[0]);
    }

    public JvmTypeReference exceptionType(EObject o) {
        return this._typeReferences.getTypeForName(Exception.class, (Notifier)o, new JvmTypeReference[0]);
    }

    public String emptyEnvironmentInvocation() {
        return "emptyEnvironment()";
    }

    public String environmentEntryInvocation() {
        return "environmentEntry";
    }

    public String environmentCompositionInvocation() {
        return "environmentComposition";
    }

    public String methodName(CheckRule rule) {
        return Strings.toFirstLower((String)rule.getName());
    }

    public AuxiliaryDescription associatedAuxiliaryDescription(JvmIdentifiableElement e) {
        AuxiliaryDescription auxiliaryDescription = null;
        EObject associated = this.associations.getPrimarySourceElement((EObject)e);
        AuxiliaryDescription auxiliaryDescription2 = null;
        auxiliaryDescription2 = associated instanceof AuxiliaryDescription ? (AuxiliaryDescription)associated : null;
        auxiliaryDescription = auxiliaryDescription2;
        return auxiliaryDescription;
    }

    public void declareVariablesForOutputParams(Rule rule, ITreeAppendable appendable) {
        List<RuleParameter> list = this._xsemanticsUtils.outputParams(rule);
        for (RuleParameter p : list) {
            appendable.append((CharSequence)"\n");
            this.declareVariableForOutputParam(p, appendable);
        }
    }

    public ITreeAppendable declareVariableForOutputParam(RuleParameter ruleParam, ITreeAppendable appendable) {
        ITreeAppendable iTreeAppendable = null;
        String outputVarName = appendable.declareVariable((Object)ruleParam.getParameter(), ruleParam.getParameter().getSimpleName());
        ITreeAppendable childAppendable = appendable.trace((EObject)ruleParam.getParameter(), true);
        this._typeReferenceSerializer.serialize(ruleParam.getParameter().getParameterType(), (EObject)ruleParam.getParameter(), (IAppendable)childAppendable);
        iTreeAppendable = childAppendable.append((CharSequence)(" " + outputVarName + " = null; // output parameter"));
        return iTreeAppendable;
    }

    public String expressionInConclusionMethodName(ExpressionInConclusion e) {
        String string = null;
        Rule containingRule = this._xsemanticsUtils.containingRule(e);
        CharSequence charSequence = this.applyRuleName(containingRule);
        String string2 = "_" + charSequence;
        String string3 = String.valueOf(string2) + "_";
        int n = containingRule.getConclusion().getConclusionElements().indexOf((Object)e);
        string = String.valueOf(string3) + Integer.valueOf(n);
        return string;
    }

    public ITreeAppendable compileReturnResult(Rule rule, JvmTypeReference resultType, ITreeAppendable result) {
        boolean bl;
        ITreeAppendable iTreeAppendable = null;
        List<RuleConclusionElement> expressions = this._xsemanticsUtils.outputConclusionElements(rule);
        result.append((CharSequence)"\n");
        result.append((CharSequence)"return new ");
        this._typeReferenceSerializer.serialize(resultType, (EObject)rule, (IAppendable)result);
        result.append((CharSequence)"(");
        int n = expressions.size();
        boolean bl2 = bl = n == 0;
        if (bl) {
            result.append((CharSequence)"true");
        } else {
            Iterator<RuleConclusionElement> iterator = expressions.iterator();
            while (iterator.hasNext()) {
                boolean bl3;
                RuleConclusionElement elem = iterator.next();
                boolean bl4 = false;
                if (elem instanceof RuleParameter) {
                    bl4 = true;
                    result.append((CharSequence)result.getName((Object)((RuleParameter)elem).getParameter()));
                }
                if (!bl4 && elem instanceof ExpressionInConclusion) {
                    bl4 = true;
                    String inputParams = this.inputParameterNames(rule);
                    String string = this.expressionInConclusionMethodName((ExpressionInConclusion)elem);
                    String string2 = String.valueOf(string) + "(";
                    String string3 = this.ruleEnvName(rule);
                    String string4 = String.valueOf(string2) + string3;
                    String string5 = String.valueOf(string4) + ", ";
                    String string6 = String.valueOf(string5) + inputParams;
                    String string7 = String.valueOf(string6) + ")";
                    result.append((CharSequence)string7);
                }
                if (!(bl3 = iterator.hasNext())) continue;
                result.append((CharSequence)", ");
            }
        }
        iTreeAppendable = result.append((CharSequence)");");
        return iTreeAppendable;
    }

    public String escapeJavaStringChars(String s) {
        return Strings.convertToJavaString((String)s);
    }

    public Iterable<RuleParameter> inputEObjectParams(Rule rule) {
        Functions.Function1 function1 = it -> this.typeSystem.isEObject(it.getParameter().getParameterType(), rule);
        return IterableExtensions.filter(this._xsemanticsUtils.inputParams(rule), (Functions.Function1)function1);
    }

    public Iterable<JvmFormalParameter> inputEObjectParams(AuxiliaryFunction aux) {
        Functions.Function1 function1 = it -> this.typeSystem.isEObject(it.getParameterType(), aux);
        return IterableExtensions.filter(aux.getParameters(), (Functions.Function1)function1);
    }
}

