/**
 */
package org.eclipse.xsemantics.dsl.xsemantics.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.xsemantics.dsl.xsemantics.*;

import org.eclipse.xtext.xbase.XExpression;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.xsemantics.dsl.xsemantics.XsemanticsPackage
 * @generated
 */
public class XsemanticsSwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static XsemanticsPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XsemanticsSwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = XsemanticsPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
			case XsemanticsPackage.XSEMANTICS_FILE:
			{
				XsemanticsFile xsemanticsFile = (XsemanticsFile)theEObject;
				T result = caseXsemanticsFile(xsemanticsFile);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.XSEMANTICS_SYSTEM:
			{
				XsemanticsSystem xsemanticsSystem = (XsemanticsSystem)theEObject;
				T result = caseXsemanticsSystem(xsemanticsSystem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.INJECTED:
			{
				Injected injected = (Injected)theEObject;
				T result = caseInjected(injected);
				if (result == null) result = caseAbstractFieldDefinition(injected);
				if (result == null) result = caseUniqueByName(injected);
				if (result == null) result = caseNamed(injected);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.AUXILIARY_DESCRIPTION:
			{
				AuxiliaryDescription auxiliaryDescription = (AuxiliaryDescription)theEObject;
				T result = caseAuxiliaryDescription(auxiliaryDescription);
				if (result == null) result = caseDescription(auxiliaryDescription);
				if (result == null) result = caseOverrider(auxiliaryDescription);
				if (result == null) result = caseCachable(auxiliaryDescription);
				if (result == null) result = caseUniqueByName(auxiliaryDescription);
				if (result == null) result = caseNamed(auxiliaryDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.JUDGMENT_DESCRIPTION:
			{
				JudgmentDescription judgmentDescription = (JudgmentDescription)theEObject;
				T result = caseJudgmentDescription(judgmentDescription);
				if (result == null) result = caseDescription(judgmentDescription);
				if (result == null) result = caseOverrider(judgmentDescription);
				if (result == null) result = caseCachable(judgmentDescription);
				if (result == null) result = caseUniqueByName(judgmentDescription);
				if (result == null) result = caseNamed(judgmentDescription);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.JUDGMENT_PARAMETER:
			{
				JudgmentParameter judgmentParameter = (JudgmentParameter)theEObject;
				T result = caseJudgmentParameter(judgmentParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.AUXILIARY_FUNCTION:
			{
				AuxiliaryFunction auxiliaryFunction = (AuxiliaryFunction)theEObject;
				T result = caseAuxiliaryFunction(auxiliaryFunction);
				if (result == null) result = caseNamed(auxiliaryFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE:
			{
				Rule rule = (Rule)theEObject;
				T result = caseRule(rule);
				if (result == null) result = caseOverrider(rule);
				if (result == null) result = caseReferToJudgment(rule);
				if (result == null) result = caseUniqueByName(rule);
				if (result == null) result = caseNamed(rule);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.AXIOM:
			{
				Axiom axiom = (Axiom)theEObject;
				T result = caseAxiom(axiom);
				if (result == null) result = caseRule(axiom);
				if (result == null) result = caseOverrider(axiom);
				if (result == null) result = caseReferToJudgment(axiom);
				if (result == null) result = caseUniqueByName(axiom);
				if (result == null) result = caseNamed(axiom);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE_WITH_PREMISES:
			{
				RuleWithPremises ruleWithPremises = (RuleWithPremises)theEObject;
				T result = caseRuleWithPremises(ruleWithPremises);
				if (result == null) result = caseRule(ruleWithPremises);
				if (result == null) result = caseOverrider(ruleWithPremises);
				if (result == null) result = caseReferToJudgment(ruleWithPremises);
				if (result == null) result = caseUniqueByName(ruleWithPremises);
				if (result == null) result = caseNamed(ruleWithPremises);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.CHECK_RULE:
			{
				CheckRule checkRule = (CheckRule)theEObject;
				T result = caseCheckRule(checkRule);
				if (result == null) result = caseOverrider(checkRule);
				if (result == null) result = caseUniqueByName(checkRule);
				if (result == null) result = caseNamed(checkRule);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE_CONCLUSION:
			{
				RuleConclusion ruleConclusion = (RuleConclusion)theEObject;
				T result = caseRuleConclusion(ruleConclusion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE_INVOCATION:
			{
				RuleInvocation ruleInvocation = (RuleInvocation)theEObject;
				T result = caseRuleInvocation(ruleInvocation);
				if (result == null) result = caseXExpression(ruleInvocation);
				if (result == null) result = caseReferToJudgment(ruleInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.ENVIRONMENT:
			{
				Environment environment = (Environment)theEObject;
				T result = caseEnvironment(environment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE_CONCLUSION_ELEMENT:
			{
				RuleConclusionElement ruleConclusionElement = (RuleConclusionElement)theEObject;
				T result = caseRuleConclusionElement(ruleConclusionElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.RULE_PARAMETER:
			{
				RuleParameter ruleParameter = (RuleParameter)theEObject;
				T result = caseRuleParameter(ruleParameter);
				if (result == null) result = caseRuleConclusionElement(ruleParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.EXPRESSION_IN_CONCLUSION:
			{
				ExpressionInConclusion expressionInConclusion = (ExpressionInConclusion)theEObject;
				T result = caseExpressionInConclusion(expressionInConclusion);
				if (result == null) result = caseRuleConclusionElement(expressionInConclusion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.OUTPUT_PARAMETER:
			{
				OutputParameter outputParameter = (OutputParameter)theEObject;
				T result = caseOutputParameter(outputParameter);
				if (result == null) result = caseJudgmentParameter(outputParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.INPUT_PARAMETER:
			{
				InputParameter inputParameter = (InputParameter)theEObject;
				T result = caseInputParameter(inputParameter);
				if (result == null) result = caseJudgmentParameter(inputParameter);
				if (result == null) result = caseUniqueByName(inputParameter);
				if (result == null) result = caseNamed(inputParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.OR_EXPRESSION:
			{
				OrExpression orExpression = (OrExpression)theEObject;
				T result = caseOrExpression(orExpression);
				if (result == null) result = caseXExpression(orExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.FAIL:
			{
				Fail fail = (Fail)theEObject;
				T result = caseFail(fail);
				if (result == null) result = caseXExpression(fail);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.ENVIRONMENT_COMPOSITION:
			{
				EnvironmentComposition environmentComposition = (EnvironmentComposition)theEObject;
				T result = caseEnvironmentComposition(environmentComposition);
				if (result == null) result = caseXExpression(environmentComposition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.ENVIRONMENT_MAPPING:
			{
				EnvironmentMapping environmentMapping = (EnvironmentMapping)theEObject;
				T result = caseEnvironmentMapping(environmentMapping);
				if (result == null) result = caseXExpression(environmentMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.EMPTY_ENVIRONMENT:
			{
				EmptyEnvironment emptyEnvironment = (EmptyEnvironment)theEObject;
				T result = caseEmptyEnvironment(emptyEnvironment);
				if (result == null) result = caseXExpression(emptyEnvironment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.ERROR_SPECIFICATION:
			{
				ErrorSpecification errorSpecification = (ErrorSpecification)theEObject;
				T result = caseErrorSpecification(errorSpecification);
				if (result == null) result = caseXExpression(errorSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.UNIQUE_BY_NAME:
			{
				UniqueByName uniqueByName = (UniqueByName)theEObject;
				T result = caseUniqueByName(uniqueByName);
				if (result == null) result = caseNamed(uniqueByName);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.OVERRIDER:
			{
				Overrider overrider = (Overrider)theEObject;
				T result = caseOverrider(overrider);
				if (result == null) result = caseUniqueByName(overrider);
				if (result == null) result = caseNamed(overrider);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.REFER_TO_JUDGMENT:
			{
				ReferToJudgment referToJudgment = (ReferToJudgment)theEObject;
				T result = caseReferToJudgment(referToJudgment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.NAMED:
			{
				Named named = (Named)theEObject;
				T result = caseNamed(named);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.CACHED_CLAUSE:
			{
				CachedClause cachedClause = (CachedClause)theEObject;
				T result = caseCachedClause(cachedClause);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.CACHABLE:
			{
				Cachable cachable = (Cachable)theEObject;
				T result = caseCachable(cachable);
				if (result == null) result = caseUniqueByName(cachable);
				if (result == null) result = caseNamed(cachable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.DESCRIPTION:
			{
				Description description = (Description)theEObject;
				T result = caseDescription(description);
				if (result == null) result = caseOverrider(description);
				if (result == null) result = caseCachable(description);
				if (result == null) result = caseUniqueByName(description);
				if (result == null) result = caseNamed(description);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.ABSTRACT_FIELD_DEFINITION:
			{
				AbstractFieldDefinition abstractFieldDefinition = (AbstractFieldDefinition)theEObject;
				T result = caseAbstractFieldDefinition(abstractFieldDefinition);
				if (result == null) result = caseUniqueByName(abstractFieldDefinition);
				if (result == null) result = caseNamed(abstractFieldDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case XsemanticsPackage.FIELD_DEFINITION:
			{
				FieldDefinition fieldDefinition = (FieldDefinition)theEObject;
				T result = caseFieldDefinition(fieldDefinition);
				if (result == null) result = caseAbstractFieldDefinition(fieldDefinition);
				if (result == null) result = caseUniqueByName(fieldDefinition);
				if (result == null) result = caseNamed(fieldDefinition);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>File</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>File</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseXsemanticsFile(XsemanticsFile object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>System</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseXsemanticsSystem(XsemanticsSystem object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Injected</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Injected</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInjected(Injected object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Auxiliary Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Auxiliary Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAuxiliaryDescription(AuxiliaryDescription object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Judgment Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Judgment Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJudgmentDescription(JudgmentDescription object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Judgment Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Judgment Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJudgmentParameter(JudgmentParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Auxiliary Function</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Auxiliary Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAuxiliaryFunction(AuxiliaryFunction object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRule(Rule object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Axiom</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Axiom</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAxiom(Axiom object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule With Premises</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule With Premises</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRuleWithPremises(RuleWithPremises object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Check Rule</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Check Rule</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCheckRule(CheckRule object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule Conclusion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule Conclusion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRuleConclusion(RuleConclusion object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRuleInvocation(RuleInvocation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Environment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Environment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnvironment(Environment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule Conclusion Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule Conclusion Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRuleConclusionElement(RuleConclusionElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Rule Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Rule Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRuleParameter(RuleParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression In Conclusion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression In Conclusion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpressionInConclusion(ExpressionInConclusion object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Output Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Output Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOutputParameter(OutputParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Input Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Input Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInputParameter(InputParameter object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Or Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Or Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOrExpression(OrExpression object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Fail</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Fail</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFail(Fail object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Environment Composition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Environment Composition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnvironmentComposition(EnvironmentComposition object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Environment Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Environment Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEnvironmentMapping(EnvironmentMapping object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Empty Environment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Empty Environment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEmptyEnvironment(EmptyEnvironment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Error Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Error Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseErrorSpecification(ErrorSpecification object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unique By Name</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unique By Name</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUniqueByName(UniqueByName object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Overrider</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Overrider</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOverrider(Overrider object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Refer To Judgment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Refer To Judgment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferToJudgment(ReferToJudgment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamed(Named object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cached Clause</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cached Clause</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCachedClause(CachedClause object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cachable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cachable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCachable(Cachable object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Description</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Description</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDescription(Description object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Field Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Field Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractFieldDefinition(AbstractFieldDefinition object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Field Definition</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Field Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFieldDefinition(FieldDefinition object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>XExpression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>XExpression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @since 2.7
	 * @generated
	 */
	public T caseXExpression(XExpression object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //XsemanticsSwitch
