/**
 */
package org.eclipse.xsemantics.dsl.xsemantics.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.xsemantics.dsl.xsemantics.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class XsemanticsFactoryImpl extends EFactoryImpl implements XsemanticsFactory
{
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static XsemanticsFactory init()
	{
		try
		{
			XsemanticsFactory theXsemanticsFactory = (XsemanticsFactory)EPackage.Registry.INSTANCE.getEFactory(XsemanticsPackage.eNS_URI);
			if (theXsemanticsFactory != null)
			{
				return theXsemanticsFactory;
			}
		}
		catch (Exception exception)
		{
			EcorePlugin.INSTANCE.log(exception);
		}
		return new XsemanticsFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XsemanticsFactoryImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass)
	{
		switch (eClass.getClassifierID())
		{
			case XsemanticsPackage.XSEMANTICS_FILE: return createXsemanticsFile();
			case XsemanticsPackage.XSEMANTICS_SYSTEM: return createXsemanticsSystem();
			case XsemanticsPackage.INJECTED: return createInjected();
			case XsemanticsPackage.AUXILIARY_DESCRIPTION: return createAuxiliaryDescription();
			case XsemanticsPackage.JUDGMENT_DESCRIPTION: return createJudgmentDescription();
			case XsemanticsPackage.JUDGMENT_PARAMETER: return createJudgmentParameter();
			case XsemanticsPackage.AUXILIARY_FUNCTION: return createAuxiliaryFunction();
			case XsemanticsPackage.RULE: return createRule();
			case XsemanticsPackage.AXIOM: return createAxiom();
			case XsemanticsPackage.RULE_WITH_PREMISES: return createRuleWithPremises();
			case XsemanticsPackage.CHECK_RULE: return createCheckRule();
			case XsemanticsPackage.RULE_CONCLUSION: return createRuleConclusion();
			case XsemanticsPackage.RULE_INVOCATION: return createRuleInvocation();
			case XsemanticsPackage.ENVIRONMENT: return createEnvironment();
			case XsemanticsPackage.RULE_CONCLUSION_ELEMENT: return createRuleConclusionElement();
			case XsemanticsPackage.RULE_PARAMETER: return createRuleParameter();
			case XsemanticsPackage.EXPRESSION_IN_CONCLUSION: return createExpressionInConclusion();
			case XsemanticsPackage.OUTPUT_PARAMETER: return createOutputParameter();
			case XsemanticsPackage.INPUT_PARAMETER: return createInputParameter();
			case XsemanticsPackage.OR_EXPRESSION: return createOrExpression();
			case XsemanticsPackage.FAIL: return createFail();
			case XsemanticsPackage.ENVIRONMENT_COMPOSITION: return createEnvironmentComposition();
			case XsemanticsPackage.ENVIRONMENT_MAPPING: return createEnvironmentMapping();
			case XsemanticsPackage.EMPTY_ENVIRONMENT: return createEmptyEnvironment();
			case XsemanticsPackage.ERROR_SPECIFICATION: return createErrorSpecification();
			case XsemanticsPackage.OVERRIDER: return createOverrider();
			case XsemanticsPackage.REFER_TO_JUDGMENT: return createReferToJudgment();
			case XsemanticsPackage.CACHED_CLAUSE: return createCachedClause();
			case XsemanticsPackage.CACHABLE: return createCachable();
			case XsemanticsPackage.DESCRIPTION: return createDescription();
			case XsemanticsPackage.ABSTRACT_FIELD_DEFINITION: return createAbstractFieldDefinition();
			case XsemanticsPackage.FIELD_DEFINITION: return createFieldDefinition();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue)
	{
		switch (eDataType.getClassifierID())
		{
			case XsemanticsPackage.ENTRY_POINTS_OPTION:
				return createEntryPointsOptionFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue)
	{
		switch (eDataType.getClassifierID())
		{
			case XsemanticsPackage.ENTRY_POINTS_OPTION:
				return convertEntryPointsOptionToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XsemanticsFile createXsemanticsFile()
	{
		XsemanticsFileImpl xsemanticsFile = new XsemanticsFileImpl();
		return xsemanticsFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XsemanticsSystem createXsemanticsSystem()
	{
		XsemanticsSystemImpl xsemanticsSystem = new XsemanticsSystemImpl();
		return xsemanticsSystem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Injected createInjected()
	{
		InjectedImpl injected = new InjectedImpl();
		return injected;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AuxiliaryDescription createAuxiliaryDescription()
	{
		AuxiliaryDescriptionImpl auxiliaryDescription = new AuxiliaryDescriptionImpl();
		return auxiliaryDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JudgmentDescription createJudgmentDescription()
	{
		JudgmentDescriptionImpl judgmentDescription = new JudgmentDescriptionImpl();
		return judgmentDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JudgmentParameter createJudgmentParameter()
	{
		JudgmentParameterImpl judgmentParameter = new JudgmentParameterImpl();
		return judgmentParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AuxiliaryFunction createAuxiliaryFunction()
	{
		AuxiliaryFunctionImpl auxiliaryFunction = new AuxiliaryFunctionImpl();
		return auxiliaryFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Rule createRule()
	{
		RuleImpl rule = new RuleImpl();
		return rule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Axiom createAxiom()
	{
		AxiomImpl axiom = new AxiomImpl();
		return axiom;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RuleWithPremises createRuleWithPremises()
	{
		RuleWithPremisesImpl ruleWithPremises = new RuleWithPremisesImpl();
		return ruleWithPremises;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CheckRule createCheckRule()
	{
		CheckRuleImpl checkRule = new CheckRuleImpl();
		return checkRule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RuleConclusion createRuleConclusion()
	{
		RuleConclusionImpl ruleConclusion = new RuleConclusionImpl();
		return ruleConclusion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RuleInvocation createRuleInvocation()
	{
		RuleInvocationImpl ruleInvocation = new RuleInvocationImpl();
		return ruleInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Environment createEnvironment()
	{
		EnvironmentImpl environment = new EnvironmentImpl();
		return environment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RuleConclusionElement createRuleConclusionElement()
	{
		RuleConclusionElementImpl ruleConclusionElement = new RuleConclusionElementImpl();
		return ruleConclusionElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RuleParameter createRuleParameter()
	{
		RuleParameterImpl ruleParameter = new RuleParameterImpl();
		return ruleParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionInConclusion createExpressionInConclusion()
	{
		ExpressionInConclusionImpl expressionInConclusion = new ExpressionInConclusionImpl();
		return expressionInConclusion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputParameter createOutputParameter()
	{
		OutputParameterImpl outputParameter = new OutputParameterImpl();
		return outputParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InputParameter createInputParameter()
	{
		InputParameterImpl inputParameter = new InputParameterImpl();
		return inputParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OrExpression createOrExpression()
	{
		OrExpressionImpl orExpression = new OrExpressionImpl();
		return orExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Fail createFail()
	{
		FailImpl fail = new FailImpl();
		return fail;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EnvironmentComposition createEnvironmentComposition()
	{
		EnvironmentCompositionImpl environmentComposition = new EnvironmentCompositionImpl();
		return environmentComposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EnvironmentMapping createEnvironmentMapping()
	{
		EnvironmentMappingImpl environmentMapping = new EnvironmentMappingImpl();
		return environmentMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EmptyEnvironment createEmptyEnvironment()
	{
		EmptyEnvironmentImpl emptyEnvironment = new EmptyEnvironmentImpl();
		return emptyEnvironment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ErrorSpecification createErrorSpecification()
	{
		ErrorSpecificationImpl errorSpecification = new ErrorSpecificationImpl();
		return errorSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Overrider createOverrider()
	{
		OverriderImpl overrider = new OverriderImpl();
		return overrider;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ReferToJudgment createReferToJudgment()
	{
		ReferToJudgmentImpl referToJudgment = new ReferToJudgmentImpl();
		return referToJudgment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CachedClause createCachedClause()
	{
		CachedClauseImpl cachedClause = new CachedClauseImpl();
		return cachedClause;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Cachable createCachable()
	{
		CachableImpl cachable = new CachableImpl();
		return cachable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Description createDescription()
	{
		DescriptionImpl description = new DescriptionImpl();
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractFieldDefinition createAbstractFieldDefinition()
	{
		AbstractFieldDefinitionImpl abstractFieldDefinition = new AbstractFieldDefinitionImpl();
		return abstractFieldDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FieldDefinition createFieldDefinition()
	{
		FieldDefinitionImpl fieldDefinition = new FieldDefinitionImpl();
		return fieldDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EntryPointsOption createEntryPointsOptionFromString(EDataType eDataType, String initialValue)
	{
		EntryPointsOption result = EntryPointsOption.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEntryPointsOptionToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public XsemanticsPackage getXsemanticsPackage()
	{
		return (XsemanticsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static XsemanticsPackage getPackage()
	{
		return XsemanticsPackage.eINSTANCE;
	}

} //XsemanticsFactoryImpl
