/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.dsl.services;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * @author Lorenzo Bettini
 */
@SuppressWarnings("all")
public class XsemanticsProposalsForDatatypeRules {
  @Inject
  private XsemanticsGrammarAccess grammarAccess;

  public List<String> judgmentSymbols() {
    final Function1<Keyword, String> _function = (Keyword it) -> {
      return it.getValue();
    };
    return ListExtensions.<Keyword, String>map(EcoreUtil2.<Keyword>getAllContentsOfType(this.grammarAccess.getJudgmentSymbolRule().getAlternatives(), Keyword.class), _function);
  }

  public List<String> relationSymbols() {
    final Function1<Keyword, String> _function = (Keyword it) -> {
      return it.getValue();
    };
    return ListExtensions.<Keyword, String>map(EcoreUtil2.<Keyword>getAllContentsOfType(this.grammarAccess.getRelationSymbolRule().getAlternatives(), Keyword.class), _function);
  }
}
