/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.dsl;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xsemantics.dsl.xsemantics.XsemanticsPackage;

/**
 * Initialization support for running Xtext languages without equinox extension
 * registry
 */
@SuppressWarnings("all")
public class XsemanticsStandaloneSetup extends XsemanticsStandaloneSetupGenerated {
  public static void doSetup() {
    new XsemanticsStandaloneSetup().createInjectorAndDoEMFRegistration();
  }

  @Override
  public void register(final Injector injector) {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey(XsemanticsPackage.eNS_URI);
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put(XsemanticsPackage.eNS_URI, XsemanticsPackage.eINSTANCE);
    }
    super.register(injector);
  }
}
