/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.director.shared;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectorApplicationCommand
implements DirectorRuntime.Command {
    private StringList metadataSources = new StringList();
    private StringList artifactSources = new StringList();
    private StringList unitsToInstall = new StringList();
    private String profileName;
    private TargetEnvironment environment;
    private boolean installFeatures;
    private File destination;

    @Override
    public final void addMetadataSources(Iterable<URI> metadataRepositories) {
        for (URI repositoryUrl : metadataRepositories) {
            this.metadataSources.append(repositoryUrl);
        }
    }

    @Override
    public final void addArtifactSources(Iterable<URI> artifactRepositories) {
        for (URI repositoryUrl : artifactRepositories) {
            this.artifactSources.append(repositoryUrl);
        }
    }

    @Override
    public final void addUnitToInstall(String id) {
        this.unitsToInstall.append(id);
    }

    @Override
    public final void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public final void setEnvironment(TargetEnvironment env) {
        this.environment = env;
    }

    @Override
    public final void setInstallFeatures(boolean installFeatures) {
        this.installFeatures = installFeatures;
    }

    @Override
    public final void setDestination(File path) {
        this.destination = path;
    }

    protected List<String> getDirectorApplicationArguments() {
        CommandLineArguments args = new CommandLineArguments();
        args.addUnlessEmpty("-metadataRepository", this.metadataSources);
        args.addUnlessEmpty("-artifactRepository", this.artifactSources);
        args.addUnlessEmpty("-installIU", this.unitsToInstall);
        args.add("-destination", this.destination.getAbsolutePath());
        args.add("-profile", this.profileName);
        args.add("-profileProperties", "org.eclipse.update.install.features=" + String.valueOf(this.installFeatures));
        args.add("-roaming");
        if (this.environment != null) {
            args.add("-p2.os", this.environment.getOs());
            args.add("-p2.ws", this.environment.getWs());
            args.add("-p2.arch", this.environment.getArch());
        }
        return args.asList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineArguments {
        List<String> arguments = new ArrayList<String>();

        private CommandLineArguments() {
        }

        void add(String flag) {
            this.arguments.add(flag);
        }

        void add(String parameterName, String parameterValue) {
            this.arguments.add(parameterName);
            this.arguments.add(parameterValue);
        }

        void addUnlessEmpty(String parameterName, StringList list) {
            String parameterValue = list.toString();
            if (parameterValue.length() > 0) {
                this.add(parameterName, parameterValue);
            }
        }

        public List<String> asList() {
            return new ArrayList<String>(this.arguments);
        }
    }

    private static class StringList {
        private static final String VALUE_SEPARATOR = ",";
        StringBuilder list = new StringBuilder();

        private StringList() {
        }

        void append(Object valueToAppend) {
            this.list.append(VALUE_SEPARATOR);
            this.list.append(valueToAppend);
        }

        public String toString() {
            if (this.list.length() == 0) {
                return "";
            }
            return this.list.substring(VALUE_SEPARATOR.length());
        }
    }
}

