/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConverterMetadata
extends AbstractConverterMetadata {
    private String m_className;

    public ConverterMetadata() {
        super("<converter>");
    }

    public ConverterMetadata(MetadataAnnotation converter, MetadataAccessor accessor) {
        super(converter, accessor);
        this.m_className = converter.getAttributeString("converterClass");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ConverterMetadata) {
            ConverterMetadata converter = (ConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), converter.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_className, converter.getClassName());
        }
        return false;
    }

    public String getClassName() {
        return this.m_className;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_className = this.initXMLClassName(this.m_className).getName();
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        this.setConverterClassName(mapping, this.getClassName(), isForMapKey);
    }

    public void setClassName(String className) {
        this.m_className = className;
    }
}

