/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.service;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

class TemplateUtil {
    private TemplateUtil() {
    }

    static Template getSingletonTemplate(KubernetesList resources) {
        HasMetadata singleEntity;
        List items;
        if (resources != null && (items = resources.getItems()) != null && items.size() == 1 && (singleEntity = (HasMetadata)items.get(0)) instanceof Template) {
            return (Template)singleEntity;
        }
        return null;
    }

    static void interpolateTemplateVariables(KubernetesList resources, File kubernetesYaml) throws IOException {
        String kubernetesYamlContent;
        List<Parameter> parameters = TemplateUtil.listAllParameters(resources);
        if (parameters.isEmpty()) {
            return;
        }
        try {
            kubernetesYamlContent = FileUtils.readFileToString((File)kubernetesYaml, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + kubernetesYaml + " for template variable replacement", e);
        }
        String interpolatedKubernetesYamlContent = TemplateUtil.interpolateTemplateVariables(parameters, kubernetesYamlContent);
        if (!kubernetesYamlContent.equals(interpolatedKubernetesYamlContent)) {
            try {
                FileUtils.writeStringToFile((File)kubernetesYaml, (String)interpolatedKubernetesYamlContent, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new IOException("Failed to save " + kubernetesYaml + " after replacing template expressions", e);
            }
        }
    }

    private static String interpolateTemplateVariables(List<Parameter> parameters, String text) {
        for (Parameter parameter : parameters) {
            String from = "${" + parameter.getName() + "}";
            String to = parameter.getValue();
            if (!StringUtils.isNotBlank((CharSequence)to)) continue;
            text = text.replace(from, to);
        }
        return text;
    }

    private static List<Parameter> listAllParameters(KubernetesList resources) {
        return resources.getItems().stream().filter(template -> template instanceof Template).map(Template.class::cast).map(Template::getParameters).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

