/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.plus.webapp;

import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.jndi.NamingDump;
import org.eclipse.jetty.util.jndi.NamingUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvConfiguration
extends AbstractConfiguration {
    public static final String JETTY_ENV_XML = "org.eclipse.jetty.jndi.JettyEnvXml";
    private static final Logger LOG = LoggerFactory.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";
    private static final String JETTY_EE10_ENV_XML_FILENAME = "jetty-ee10-env.xml";
    private static final String JETTY_ENV_XML_FILENAME = "jetty-env.xml";

    public EnvConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(new Class[]{WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class}).addDependents(new Class[]{PlusConfiguration.class, JettyWebXmlConfiguration.class}).protectAndExpose(new String[]{"org.eclipse.jetty.jndi."}));
    }

    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnvXmlResource;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp {}", (Object)context.getContextPath());
        }
        if ((jettyEnvXmlResource = (Resource)context.getAttribute(JETTY_ENV_XML)) == null) {
            jettyEnvXmlResource = this.resolveJettyEnvXml(context.getWebInf());
        }
        if (jettyEnvXmlResource != null) {
            Set boundNamesBefore = NamingUtil.flattenBindings((Context)new InitialContext(), (String)"").keySet();
            try {
                XmlConfiguration configuration = new XmlConfiguration(jettyEnvXmlResource);
                configuration.setJettyStandardIdsAndProperties((Object)context.getServer(), null);
                WebAppClassLoader.runWithServerClassAccess(() -> {
                    configuration.configure((Object)context);
                    return null;
                });
            }
            finally {
                Set boundNamesAfter = NamingUtil.flattenBindings((Context)new InitialContext(), (String)"").keySet();
                boundNamesAfter.removeAll(boundNamesBefore);
                context.setAttribute(JETTY_ENV_BINDINGS, boundNamesAfter);
            }
        }
        this.bindEnvEntries(context);
        context.addBean((Object)new NamingDump(context.getClassLoader(), "java:comp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconfigure(WebAppContext context) throws Exception {
        Dumper dumper = (Dumper)((Object)context.getBean(Dumper.class));
        if (dumper != null) {
            context.removeBean((Object)dumper);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            Set jettyEnvBoundNames = (Set)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (jettyEnvBoundNames != null) {
                for (String name : jettyEnvBoundNames) {
                    NamingUtil.unbind((Context)ic, (String)name, (boolean)true);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn("Unable to destroy InitialContext", (Throwable)e);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingEntryUtil.destroyContextForScope((Object)context);
        }
        catch (NameNotFoundException e) {
            LOG.trace("IGNORED", (Throwable)e);
            LOG.debug("No jndi entries scoped to webapp {}", (Object)context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp {}", (Object)context, (Object)e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        LOG.debug("Binding env entries from the jvm scope");
        this.doBindings(envCtx, null);
        LOG.debug("Binding env entries from the server scope");
        this.doBindings(envCtx, context.getServer());
        LOG.debug("Binding env entries from environment {} scope", (Object)ServletContextHandler.ENVIRONMENT.getName());
        this.doBindings(envCtx, ServletContextHandler.ENVIRONMENT.getName());
        LOG.debug("Binding env entries from the context scope");
        this.doBindings(envCtx, context);
    }

    private void doBindings(Context envCtx, Object scope) throws NamingException {
        for (EnvEntry ee : NamingEntryUtil.lookupNamingEntries((Object)scope, EnvEntry.class)) {
            ee.bindToENC(ee.getJndiName());
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(null, (NamingEntry)ee);
            NamingUtil.bind((Context)envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
    }

    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)wac.getClassLoader());
        try {
            WebAppClassLoader.runWithServerClassAccess(() -> {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.createSubcontext("env");
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private Resource resolveJettyEnvXml(Resource webInf) {
        try {
            if (webInf == null || !webInf.isDirectory()) {
                return null;
            }
            Resource xmlResource = webInf.resolve(JETTY_EE10_ENV_XML_FILENAME);
            if (!Resources.missing((Resource)xmlResource)) {
                return xmlResource;
            }
            xmlResource = webInf.resolve(JETTY_ENV_XML_FILENAME);
            if (!Resources.missing((Resource)xmlResource)) {
                return xmlResource;
            }
            return null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error resolving", (Throwable)e);
            }
            return null;
        }
    }

    private static class Dumper
    extends NamingDump {
        Dumper(ClassLoader loader, String name) {
            super(loader, name);
        }
    }
}

