/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.model.codegen.execmodel.CanonicalModelKieProject;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.util.IoUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleUnitProviderImpl
implements RuleUnitProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleUnitProviderImpl.class);
    private static final boolean USE_EXEC_MODEL = true;
    private final Map<String, RuleUnit> ruleUnitMap = this.loadRuleUnits(Thread.currentThread().getContextClassLoader());

    public <T extends RuleUnitData> RuleUnit<T> getRuleUnit(T ruleUnitData) {
        Class<?> ruleUnitDataClass = ruleUnitData.getClass();
        RuleUnit ruleUnit = this.ruleUnitMap.get(ruleUnitDataClass.getCanonicalName());
        if (ruleUnit != null) {
            return ruleUnit;
        }
        this.ruleUnitMap.putAll(this.generateRuleUnit(ruleUnitData));
        return this.ruleUnitMap.get(ruleUnitDataClass.getCanonicalName());
    }

    protected <T extends RuleUnitData> Map<String, RuleUnit> generateRuleUnit(T ruleUnitData) {
        InternalKieModule kieModule = RuleUnitProviderImpl.createRuleUnitKieModule(ruleUnitData.getClass(), true);
        KieModuleKieProject kieModuleKieProject = RuleUnitProviderImpl.createRuleUnitKieProject(kieModule, true);
        return this.loadRuleUnits(kieModuleKieProject.getClassLoader());
    }

    private Map<String, RuleUnit> loadRuleUnits(ClassLoader classLoader) {
        HashMap<String, RuleUnit> map = new HashMap<String, RuleUnit>();
        ServiceLoader<RuleUnit> loader = ServiceLoader.load(RuleUnit.class, classLoader);
        for (RuleUnit impl : loader) {
            map.put(impl.id(), impl);
        }
        return map;
    }

    static InternalKieModule createRuleUnitKieModule(Class<?> unitClass, boolean useExecModel) {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (Resource drlResource : RuleUnitProviderImpl.drlResourcesForUnitClass(ks, unitClass)) {
            kfs.write(drlResource);
        }
        return (InternalKieModule)ks.newKieBuilder(kfs).getKieModule(useExecModel ? ExecutableModelProject.class : DrlProject.class);
    }

    static KieModuleKieProject createRuleUnitKieProject(InternalKieModule kieModule, boolean useExecModel) {
        return useExecModel ? new CanonicalModelKieProject(kieModule, kieModule.getModuleClassLoader()) : new KieModuleKieProject(kieModule, kieModule.getModuleClassLoader());
    }

    private static Collection<Resource> drlResourcesForUnitClass(KieServices ks, Class<?> unitClass) {
        String unitStatement = "unit " + unitClass.getSimpleName();
        HashSet<Resource> resources = new HashSet<Resource>();
        try {
            Enumeration<URL> urlEnumeration = unitClass.getClassLoader().getResources(unitClass.getPackageName().replace('.', '/'));
            while (urlEnumeration.hasMoreElements()) {
                String path = urlEnumeration.nextElement().getPath();
                Stream.of(new File(path).listFiles()).filter(f -> f.getPath().endsWith(".drl")).filter(f -> IoUtils.readFileAsString((File)f).contains(unitStatement)).peek(f -> LOGGER.debug("Found " + f.getPath() + " in " + unitClass.getSimpleName() + " unit")).map(arg_0 -> ((KieResources)ks.getResources()).newFileSystemResource(arg_0)).forEach(resources::add);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }
}

