/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.builder.DirectoryLookupFactoryService;
import org.drools.core.util.StringUtils;
import org.drools.grid.ExecutionNode;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.io.Resource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.pipeline.PipelineContext;
import org.drools.runtime.pipeline.Transformer;
import org.drools.runtime.pipeline.impl.BaseEmitter;
import org.drools.runtime.pipeline.impl.ExecutionNodePipelineContextImpl;
import org.drools.runtime.pipeline.impl.XStreamResolverStrategy;

public class XStreamFromXmlGridTransformer
extends BaseEmitter
implements Transformer {
    private XStreamResolverStrategy strategy;
    private Object payload;
    private PipelineContext context;
    private static Pattern p = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");

    public XStreamFromXmlGridTransformer(XStreamResolverStrategy strategy) {
        this.strategy = strategy;
    }

    public void receive(Object object, PipelineContext context) {
        this.payload = this.processPayload(object, context);
        this.emit(this.payload, context);
    }

    public Object processPayload(Object object, PipelineContext context) {
        try {
            XStream xstream;
            String str;
            if (object instanceof String) {
                str = (String)object;
            } else if (object instanceof Reader) {
                str = StringUtils.toString((Reader)((Reader)object));
            } else if (object instanceof InputStream) {
                str = StringUtils.toString((InputStream)((InputStream)object));
            } else if (object instanceof Resource) {
                str = StringUtils.toString((Reader)((Resource)object).getReader());
            } else {
                throw new IllegalArgumentException("signal object must be instance of String, Reader, InputStream or Resource, was: " + object);
            }
            Matcher m = p.matcher(str);
            String name = null;
            if (m.find()) {
                name = m.group(1);
            }
            if ((xstream = this.strategy.lookup(name)) == null) {
                throw new IllegalArgumentException("Unable to lookup XStream parser using name '" + name + "'");
            }
            ExecutionNodePipelineContextImpl executionNodeContext = (ExecutionNodePipelineContextImpl)context;
            ExecutionNode node = executionNodeContext.getExecutionNode();
            CommandExecutor executor = ((DirectoryLookupFactoryService)node.get(DirectoryLookupFactoryService.class)).lookup(name);
            if (executor == null) {
                throw new IllegalArgumentException("Unable to lookup CommandExecutor using name '" + name + "'");
            }
            executionNodeContext.setCommandExecutor(executor);
            DroolsCompositeClassLoader cl = null;
            if (executor instanceof StatefulKnowledgeSessionImpl) {
                cl = ((ReteooRuleBase)((StatefulKnowledgeSessionImpl)executor).getRuleBase()).getRootClassLoader();
                xstream.setClassLoader((ClassLoader)cl);
            } else if (executor instanceof StatelessKnowledgeSessionImpl) {
                cl = ((ReteooRuleBase)((StatelessKnowledgeSessionImpl)executor).getRuleBase()).getRootClassLoader();
            } else {
                throw new IllegalArgumentException("Unable to set ClassLoader on " + executor);
            }
            xstream.setClassLoader((ClassLoader)cl);
            executionNodeContext.setClassLoader((ClassLoader)cl);
            this.payload = xstream.fromXML((String)object);
            context.getProperties().put("xstream-instance", xstream);
            this.context = context;
        }
        catch (Exception e) {
            this.handleException(this, object, e);
        }
        return this.payload;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public PipelineContext getContext() {
        return this.context;
    }

    public void setContext(PipelineContext context) {
        this.context = context;
    }
}

