/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.parser;

import com.github.javaparser.Problem;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.drools.mvel.parser.GeneratedMvelParserTokenManager;
import org.drools.mvel.parser.JavaToken;
import org.drools.mvel.parser.ParseException;
import org.drools.mvel.parser.Provider;
import org.drools.mvel.parser.Token;

abstract class GeneratedMvelParserBase {
    List<Problem> problems = new ArrayList<Problem>();
    boolean storeTokens;

    GeneratedMvelParserBase() {
    }

    abstract GeneratedMvelParserTokenManager getTokenSource();

    abstract void ReInit(Provider var1);

    abstract com.github.javaparser.JavaToken token();

    abstract Token getNextToken();

    abstract Token getToken(int var1);

    void reset(Provider provider) {
        this.ReInit(provider);
        this.problems = new ArrayList<Problem>();
        this.getTokenSource().reset();
    }

    public List<com.github.javaparser.JavaToken> getTokens() {
        return this.getTokenSource().getTokens();
    }

    CommentsCollection getCommentsCollection() {
        return this.getTokenSource().getCommentsCollection();
    }

    void addProblem(String message) {
        this.problems.add(new Problem(message, this.tokenRange(), null));
    }

    TokenRange tokenRange() {
        if (this.storeTokens) {
            return new TokenRange(this.token(), this.token());
        }
        return null;
    }

    TokenRange range(com.github.javaparser.JavaToken begin, com.github.javaparser.JavaToken end) {
        if (this.storeTokens) {
            return new TokenRange(begin, end);
        }
        return null;
    }

    TokenRange range(Node begin, com.github.javaparser.JavaToken end) {
        if (this.storeTokens) {
            return new TokenRange(((TokenRange)begin.getTokenRange().get()).getBegin(), end);
        }
        return null;
    }

    TokenRange range(com.github.javaparser.JavaToken begin, Node end) {
        if (this.storeTokens) {
            return new TokenRange(begin, ((TokenRange)end.getTokenRange().get()).getEnd());
        }
        return null;
    }

    TokenRange range(Node begin, Node end) {
        if (this.storeTokens) {
            return new TokenRange(((TokenRange)begin.getTokenRange().get()).getBegin(), ((TokenRange)end.getTokenRange().get()).getEnd());
        }
        return null;
    }

    com.github.javaparser.JavaToken orIfInvalid(com.github.javaparser.JavaToken firstChoice, com.github.javaparser.JavaToken secondChoice) {
        if (this.storeTokens) {
            Utils.assertNotNull((Object)firstChoice);
            Utils.assertNotNull((Object)secondChoice);
            if (firstChoice.valid() || secondChoice.invalid()) {
                return firstChoice;
            }
            return secondChoice;
        }
        return null;
    }

    com.github.javaparser.JavaToken orIfInvalid(com.github.javaparser.JavaToken firstChoice, Node secondChoice) {
        if (this.storeTokens) {
            return this.orIfInvalid(firstChoice, ((TokenRange)secondChoice.getTokenRange().get()).getBegin());
        }
        return null;
    }

    com.github.javaparser.JavaToken nodeListBegin(NodeList<?> l) {
        if (!this.storeTokens || l.isEmpty()) {
            return com.github.javaparser.JavaToken.INVALID;
        }
        return ((TokenRange)l.get(0).getTokenRange().get()).getBegin();
    }

    void setTokenKind(int newKind) {
        JavaToken token = (JavaToken)this.token();
        token.setKind(newKind);
    }

    void setStoreTokens(boolean storeTokens) {
        this.storeTokens = storeTokens;
        this.getTokenSource().setStoreTokens(storeTokens);
    }

    TokenRange recover(int recoveryTokenType, ParseException p) {
        Token t;
        com.github.javaparser.JavaToken begin = null;
        if (p.currentToken != null) {
            begin = this.token();
        }
        do {
            t = this.getNextToken();
        } while (t.kind != recoveryTokenType && t.kind != 0);
        com.github.javaparser.JavaToken end = this.token();
        TokenRange tokenRange = null;
        if (begin != null && end != null) {
            tokenRange = this.range(begin, end);
        }
        this.problems.add(new Problem(this.makeMessageForParseException(p), tokenRange, (Throwable)p));
        return tokenRange;
    }

    TokenRange recoverStatement(int recoveryTokenType, int lBraceType, int rBraceType, ParseException p) {
        Token t;
        com.github.javaparser.JavaToken begin = null;
        if (p.currentToken != null) {
            begin = this.token();
        }
        int level = 0;
        do {
            Token nextToken;
            if ((nextToken = this.getToken(1)) != null && nextToken.kind == rBraceType && level == 0) {
                TokenRange tokenRange = this.range(begin, this.token());
                this.problems.add(new Problem(this.makeMessageForParseException(p), tokenRange, (Throwable)p));
                return tokenRange;
            }
            t = this.getNextToken();
            if (t.kind == lBraceType) {
                ++level;
                continue;
            }
            if (t.kind != rBraceType) continue;
            --level;
        } while ((t.kind != recoveryTokenType || level != 0) && t.kind != 0);
        com.github.javaparser.JavaToken end = this.token();
        TokenRange tokenRange = null;
        if (begin != null && end != null) {
            tokenRange = this.range(begin, end);
        }
        this.problems.add(new Problem(this.makeMessageForParseException(p), tokenRange, (Throwable)p));
        return tokenRange;
    }

    <T extends Node> NodeList<T> emptyNodeList() {
        return new NodeList();
    }

    <T extends Node> NodeList<T> add(NodeList<T> list, T obj) {
        if (list == null) {
            list = new NodeList();
        }
        list.add(obj);
        return list;
    }

    <T extends Node> NodeList<T> addWhenNotNull(NodeList<T> list, T obj) {
        if (obj == null) {
            return list;
        }
        return this.add(list, obj);
    }

    <T extends Node> NodeList<T> prepend(NodeList<T> list, T obj) {
        if (list == null) {
            list = new NodeList();
        }
        list.addFirst(obj);
        return list;
    }

    <T> List<T> add(List<T> list, T obj) {
        if (list == null) {
            list = new LinkedList<T>();
        }
        list.add(obj);
        return list;
    }

    private void propagateRangeGrowthOnRight(Node node, Node endNode) {
        if (this.storeTokens) {
            node.getParentNode().ifPresent(nodeParent -> {
                boolean isChildOnTheRightBorderOfParent = ((TokenRange)node.getTokenRange().get()).getEnd().equals((Object)((TokenRange)nodeParent.getTokenRange().get()).getEnd());
                if (isChildOnTheRightBorderOfParent) {
                    this.propagateRangeGrowthOnRight((Node)nodeParent, endNode);
                }
            });
            node.setTokenRange(this.range(node, endNode));
        }
    }

    Expression generateLambda(Expression ret, Statement lambdaBody) {
        if (ret instanceof EnclosedExpr) {
            Expression inner = ((EnclosedExpr)ret).getInner();
            SimpleName id = ((NameExpr)inner).getName();
            NodeList<Parameter> params = this.add(new NodeList(), new Parameter((TokenRange)ret.getTokenRange().orElse(null), new NodeList(), new NodeList(), (Type)new UnknownType(), false, new NodeList(), id));
            ret = new LambdaExpr(this.range((Node)ret, (Node)lambdaBody), params, lambdaBody, true);
        } else if (ret instanceof NameExpr) {
            SimpleName id = ((NameExpr)ret).getName();
            NodeList<Parameter> params = this.add(new NodeList(), new Parameter((TokenRange)ret.getTokenRange().orElse(null), new NodeList(), new NodeList(), (Type)new UnknownType(), false, new NodeList(), id));
            ret = new LambdaExpr(this.range((Node)ret, (Node)lambdaBody), params, lambdaBody, false);
        } else if (ret instanceof LambdaExpr) {
            ((LambdaExpr)ret).setBody(lambdaBody);
            this.propagateRangeGrowthOnRight((Node)ret, (Node)lambdaBody);
        } else if (ret instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)ret;
            Expression inner = this.generateLambda(castExpr.getExpression(), lambdaBody);
            castExpr.setExpression(inner);
        } else {
            this.addProblem("Failed to parse lambda expression! Please create an issue at https://github.com/javaparser/javaparser/issues");
        }
        return ret;
    }

    ArrayCreationExpr juggleArrayCreation(TokenRange range, List<TokenRange> levelRanges, Type type, NodeList<Expression> dimensions, List<NodeList<AnnotationExpr>> arrayAnnotations, ArrayInitializerExpr arrayInitializerExpr) {
        NodeList levels = new NodeList();
        for (int i = 0; i < arrayAnnotations.size(); ++i) {
            levels.add((Node)new ArrayCreationLevel(levelRanges.get(i), (Expression)dimensions.get(i), arrayAnnotations.get(i)));
        }
        return new ArrayCreationExpr(range, type, levels, arrayInitializerExpr);
    }

    Type juggleArrayType(Type partialType, List<ArrayType.ArrayBracketPair> additionalBrackets) {
        Pair partialParts = ArrayType.unwrapArrayTypes((Type)partialType);
        Type elementType = (Type)partialParts.a;
        List leftMostBrackets = (List)partialParts.b;
        return ArrayType.wrapInArrayTypes((Type)elementType, (List[])new List[]{additionalBrackets, leftMostBrackets}).clone();
    }

    private String makeMessageForParseException(ParseException exception) {
        StringBuilder sb = new StringBuilder("Parse error. Found ");
        StringBuilder expected = new StringBuilder();
        int maxExpectedTokenSequenceLength = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        for (int i = 0; i < exception.expectedTokenSequences.length; ++i) {
            if (maxExpectedTokenSequenceLength < exception.expectedTokenSequences[i].length) {
                maxExpectedTokenSequenceLength = exception.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < exception.expectedTokenSequences[i].length; ++j) {
                sortedOptions.add(exception.tokenImage[exception.expectedTokenSequences[i][j]]);
            }
        }
        for (String option : sortedOptions) {
            expected.append(" ").append(option);
        }
        Token token = exception.currentToken.next;
        for (int i = 0; i < maxExpectedTokenSequenceLength; ++i) {
            String tokenText = token.image;
            Object escapedTokenText = ParseException.add_escapes(tokenText);
            if (i != 0) {
                sb.append(" ");
            }
            if (token.kind == 0) {
                sb.append(exception.tokenImage[0]);
                break;
            }
            String image = exception.tokenImage[token.kind];
            if (image.equals(escapedTokenText = "\"" + (String)escapedTokenText + "\"")) {
                sb.append(image);
            } else {
                sb.append(" ").append((String)escapedTokenText).append(" ").append(image);
            }
            token = token.next;
        }
        if (exception.expectedTokenSequences.length != 0) {
            int numExpectedTokens = exception.expectedTokenSequences.length;
            sb.append(", expected").append(numExpectedTokens == 1 ? "" : " one of ").append(expected.toString());
        }
        return sb.toString();
    }

    Name scopeToName(Expression scope) {
        if (scope.isNameExpr()) {
            SimpleName simpleName = scope.asNameExpr().getName();
            return new Name((TokenRange)simpleName.getTokenRange().orElse(null), null, simpleName.getIdentifier());
        }
        if (scope.isFieldAccessExpr()) {
            FieldAccessExpr fieldAccessExpr = scope.asFieldAccessExpr();
            return new Name((TokenRange)fieldAccessExpr.getTokenRange().orElse(null), this.scopeToName(fieldAccessExpr.getScope()), fieldAccessExpr.getName().getIdentifier());
        }
        throw new IllegalStateException("Unexpected expression type: " + scope.getClass().getSimpleName());
    }

    String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    String unTripleQuote(String s) {
        int start = 3;
        if (s.charAt(start) == '\r') {
            ++start;
        }
        if (s.charAt(start) == '\n') {
            ++start;
        }
        return s.substring(start, s.length() - 3);
    }

    void setYieldSupported() {
        this.getTokenSource().setYieldSupported();
    }
}

