/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.lang.reflect.InvocationTargetException;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.drl.ast.descr.AccumulateImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.util.TypeResolver;
import org.kie.api.runtime.rule.AccumulateFunction;

public class AccumulateFunctionCompilationPhase
extends AbstractPackageCompilationPhase {
    private final TypeResolver typeResolver;

    public AccumulateFunctionCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        super(pkgRegistry, packageDescr);
        this.typeResolver = pkgRegistry.getTypeResolver();
    }

    @Override
    public void process() {
        for (AccumulateImportDescr aid : this.packageDescr.getAccumulateImports()) {
            AccumulateFunction af = this.loadAccumulateFunction(aid.getFunctionName(), aid.getTarget());
            this.pkgRegistry.getPackage().addAccumulateFunction(aid.getFunctionName(), af);
        }
    }

    private AccumulateFunction loadAccumulateFunction(String identifier, String className) {
        try {
            Class clazz = this.typeResolver.resolveType(className);
            return (AccumulateFunction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Class " + className + " not found", e);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + className, e);
        }
    }
}

