/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.view;

import java.util.stream.Stream;
import org.drools.model.Condition;
import org.drools.model.Variable;
import org.drools.model.view.AbstractExprViewItem;
import org.drools.model.view.ViewItem;

public class CombinedExprViewItem<T>
extends AbstractExprViewItem<T> {
    private final Condition.Type type;
    private final ViewItem[] expressions;

    public CombinedExprViewItem(Condition.Type type, ViewItem[] expressions) {
        super(CombinedExprViewItem.getCombinedVariable(expressions));
        this.type = type;
        this.expressions = expressions;
    }

    public ViewItem[] getExpressions() {
        return this.expressions;
    }

    @Override
    public Variable<?>[] getVariables() {
        return (Variable[])Stream.of(this.expressions).flatMap(expr -> Stream.of(expr.getVariables())).distinct().toArray(Variable[]::new);
    }

    @Override
    public Condition.Type getType() {
        return this.type;
    }

    private static Variable getCombinedVariable(ViewItem ... expressions) {
        Variable var = null;
        for (ViewItem expression : expressions) {
            if (var == null) {
                var = expression.getFirstVariable();
                continue;
            }
            if (var == expression.getFirstVariable()) continue;
            return null;
        }
        return var;
    }

    @Override
    public void setQueryExpression(boolean queryExpression) {
        super.setQueryExpression(queryExpression);
        for (ViewItem expr : this.expressions) {
            if (!(expr instanceof AbstractExprViewItem)) continue;
            ((AbstractExprViewItem)expr).setQueryExpression(queryExpression);
        }
    }
}

