/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.audit;

import java.util.Date;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.process.audit.HibernateUtil;
import org.drools.process.audit.NodeInstanceLog;
import org.drools.process.audit.ProcessInstanceLog;
import org.hibernate.classic.Session;

public class WorkingMemoryDbLogger
extends WorkingMemoryLogger {
    public WorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super((WorkingMemoryEventManager)workingMemory);
    }

    public WorkingMemoryDbLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    public void logEventCreated(LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 8: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.addProcessLog(processEvent.getProcessInstanceId(), processEvent.getProcessId());
                break;
            }
            case 11: {
                RuleFlowLogEvent processEvent = (RuleFlowLogEvent)logEvent;
                this.updateProcessLog(processEvent.getProcessInstanceId());
                break;
            }
            case 24: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeEnterLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId());
                break;
            }
            case 26: {
                RuleFlowNodeLogEvent nodeEvent = (RuleFlowNodeLogEvent)logEvent;
                this.addNodeExitLog(nodeEvent.getProcessInstanceId(), nodeEvent.getProcessId(), nodeEvent.getNodeInstanceId(), nodeEvent.getNodeId());
                break;
            }
        }
    }

    private void addProcessLog(long processInstanceId, String processId) {
        ProcessInstanceLog log = new ProcessInstanceLog(processInstanceId, processId);
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        session.save((Object)log);
        session.getTransaction().commit();
    }

    private void updateProcessLog(long processInstanceId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from ProcessInstanceLog as log where log.processInstanceId = ? and log.end is null").setLong(0, processInstanceId).list();
        if (result != null && result.size() != 0) {
            ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
            log.setEnd(new Date());
            session.update((Object)log);
        }
        session.getTransaction().commit();
    }

    private void addNodeEnterLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId) {
        NodeInstanceLog log = new NodeInstanceLog(0, processInstanceId, processId, nodeInstanceId, nodeId);
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        session.save((Object)log);
        session.getTransaction().commit();
    }

    private void addNodeExitLog(long processInstanceId, String processId, String nodeInstanceId, String nodeId) {
        NodeInstanceLog log = new NodeInstanceLog(1, processInstanceId, processId, nodeInstanceId, nodeId);
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        session.save((Object)log);
        session.getTransaction().commit();
    }

    public void dispose() {
        HibernateUtil.getSessionFactory().getCurrentSession().close();
        HibernateUtil.close();
    }
}

