/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.audit;

import java.util.List;
import org.drools.process.audit.HibernateUtil;
import org.drools.process.audit.NodeInstanceLog;
import org.drools.process.audit.ProcessInstanceLog;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceDbLog {
    public static List<ProcessInstanceLog> findProcessInstances() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from ProcessInstanceLog").list();
        session.getTransaction().commit();
        return result;
    }

    public static List<ProcessInstanceLog> findProcessInstances(String processId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from ProcessInstanceLog as log where log.processId = ?").setString(0, processId).list();
        session.getTransaction().commit();
        return result;
    }

    public static ProcessInstanceLog findProcessInstance(long processInstanceId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from ProcessInstanceLog as log where log.processInstanceId = ?").setLong(0, processInstanceId).list();
        session.getTransaction().commit();
        return result == null || result.size() == 0 ? null : (ProcessInstanceLog)result.get(0);
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from NodeInstanceLog as log where log.processInstanceId = ?").setLong(0, processInstanceId).list();
        session.getTransaction().commit();
        return result;
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List result = session.createQuery("from NodeInstanceLog as log where log.processInstanceId = ? and log.nodeId = ?").setLong(0, processInstanceId).setString(1, nodeId).list();
        session.getTransaction().commit();
        return result;
    }

    public static void clear() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List processInstances = session.createQuery("from ProcessInstanceLog").list();
        for (ProcessInstanceLog processInstance : processInstances) {
            session.delete((Object)processInstance);
        }
        List nodeInstances = session.createQuery("from NodeInstanceLog").list();
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            session.delete((Object)nodeInstance);
        }
        session.getTransaction().commit();
    }
}

