/*
 *
 * Copyright 2017-2018 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.fulltext.languages;

import org.dizitart.no2.fulltext.Language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Hebrew stop words
 *
 * @since 2.1.0
 * @author Anindya Chatterjee
 */
public class Hebrew implements Language {
    @Override
    public Set<String> stopWords() {
        return new HashSet<>(Arrays.asList(
                "אבל",
                "או",
                "אולי",
                "אותה",
                "אותו",
                "אותי",
                "אותך",
                "אותם",
                "אותן",
                "אותנו",
                "אז",
                "אחר",
                "אחרות",
                "אחרי",
                "אחריכן",
                "אחרים",
                "אחרת",
                "אי",
                "איזה",
                "איך",
                "אין",
                "איפה",
                "איתה",
                "איתו",
                "איתי",
                "איתך",
                "איתכם",
                "איתכן",
                "איתם",
                "איתן",
                "איתנו",
                "אך",
                "אל",
                "אלה",
                "אלו",
                "אם",
                "אנחנו",
                "אני",
                "אס",
                "אף",
                "אצל",
                "אשר",
                "את",
                "אתה",
                "אתכם",
                "אתכן",
                "אתם",
                "אתן",
                "באיזומידה",
                "באמצע",
                "באמצעות",
                "בגלל",
                "בין",
                "בלי",
                "במידה",
                "במקוםשבו",
                "ברם",
                "בשביל",
                "בשעהש",
                "בתוך",
                "גם",
                "דרך",
                "הוא",
                "היא",
                "היה",
                "היכן",
                "היתה",
                "היתי",
                "הם",
                "הן",
                "הנה",
                "הסיבהשבגללה",
                "הרי",
                "ואילו",
                "ואת",
                "זאת",
                "זה",
                "זות",
                "יהיה",
                "יוכל",
                "יוכלו",
                "יותרמדי",
                "יכול",
                "יכולה",
                "יכולות",
                "יכולים",
                "יכל",
                "יכלה",
                "יכלו",
                "יש",
                "כאן",
                "כאשר",
                "כולם",
                "כולן",
                "כזה",
                "כי",
                "כיצד",
                "כך",
                "ככה",
                "כל",
                "כלל",
                "כמו",
                "כן",
                "כפי",
                "כש",
                "לא",
                "לאו",
                "לאיזותכלית",
                "לאן",
                "לבין",
                "לה",
                "להיות",
                "להם",
                "להן",
                "לו",
                "לי",
                "לכם",
                "לכן",
                "למה",
                "למטה",
                "למעלה",
                "למקוםשבו",
                "למרות",
                "לנו",
                "לעבר",
                "לעיכן",
                "לפיכך",
                "לפני",
                "מאד",
                "מאחורי",
                "מאיזוסיבה",
                "מאין",
                "מאיפה",
                "מבלי",
                "מבעד",
                "מדוע",
                "מה",
                "מהיכן",
                "מול",
                "מחוץ",
                "מי",
                "מכאן",
                "מכיוון",
                "מלבד",
                "מן",
                "מנין",
                "מסוגל",
                "מעט",
                "מעטים",
                "מעל",
                "מצד",
                "מקוםבו",
                "מתחת",
                "מתי",
                "נגד",
                "נגר",
                "נו",
                "עד",
                "עז",
                "על",
                "עלי",
                "עליה",
                "עליהם",
                "עליהן",
                "עליו",
                "עליך",
                "עליכם",
                "עלינו",
                "עם",
                "עצמה",
                "עצמהם",
                "עצמהן",
                "עצמו",
                "עצמי",
                "עצמם",
                "עצמן",
                "עצמנו",
                "פה",
                "רק",
                "שוב",
                "של",
                "שלה",
                "שלהם",
                "שלהן",
                "שלו",
                "שלי",
                "שלך",
                "שלכה",
                "שלכם",
                "שלכן",
                "שלנו",
                "שם",
                "תהיה",
                "תחת"
        ));
    }
}
