/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.demoiselle.signer.core.CertificateManager;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgAndLength;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgorithmIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.ObjectIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.engine.asn1.icpb.v2.PolicyValidator;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS1Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs1.PKCS1Signer;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.SignedOrUnsignedAttribute;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.factory.AttributeFactory;
import org.demoiselle.signer.policy.impl.cades.util.AlgorithmNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSigner
implements PKCS7Signer {
    private static final Logger logger = LoggerFactory.getLogger(CAdESSigner.class);
    private final PKCS1Signer pkcs1 = PKCS1Factory.getInstance().factoryDefault();
    private X509Certificate certificate;
    private Certificate[] certificateChain = null;
    private Certificate[] certificateChainTimeStamp = null;
    private boolean attached = false;
    private SignaturePolicy signaturePolicy = null;
    private boolean defaultCertificateValidators = true;
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();
    private byte[] hash = null;
    private String policyName;
    private CertificateManager certificateManager;
    private byte[] escTimeStampContent;
    private boolean pades = false;
    private Date notAfterSignerCertificate;
    private String signatory;

    public CAdESSigner() {
        this.pkcs1.setAlgorithm((String)null);
        this.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
    }

    public CAdESSigner(String algorithm, PolicyFactory.Policies police) {
        this.pkcs1.setAlgorithm(algorithm);
        this.setSignaturePolicy(police);
    }

    public CAdESSigner(String algorithm, PolicyFactory.Policies police, boolean pades) {
        this.pkcs1.setAlgorithm(algorithm);
        this.setSignaturePolicy(police);
        this.setPades(pades);
    }

    private Store<?> generatedCertStore(Certificate[] previewCerts) {
        JcaCertStore result = null;
        try {
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            certificates.addAll(Arrays.asList(previewCerts));
            boolean add = true;
            for (Certificate cert : previewCerts) {
                if (!cert.equals(this.certificateChain[0])) continue;
                add = false;
            }
            if (add) {
                logger.debug("Adicionando Certificado no CertStore");
                certificates.addAll(Arrays.asList(this.certificateChain[0]));
            } else {
                logger.debug("Certificado j\u00e1 assinou este arquivo. N\u00e3o adicionar no CertStore");
            }
            result = new JcaCertStore(certificates);
        }
        catch (CertificateEncodingException ex) {
            throw new SignerException(ex);
        }
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.pkcs1.getAlgorithm();
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.pkcs1.getPrivateKey();
    }

    @Override
    public Provider getProvider() {
        return this.pkcs1.getProvider();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pkcs1.getPublicKey();
    }

    public boolean isDefaultCertificateValidators() {
        return this.defaultCertificateValidators;
    }

    @Override
    public void setAlgorithm(SignerAlgorithmEnum algorithm) {
        this.pkcs1.setAlgorithm(algorithm);
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.pkcs1.setAlgorithm(algorithm);
    }

    private void setAttached(boolean attached) {
        this.attached = attached;
    }

    @Override
    public void setCertificates(Certificate[] certificates) {
        this.certificateChain = certificates;
    }

    public void setDefaultCertificateValidators(boolean defaultCertificateValidators) {
        this.defaultCertificateValidators = defaultCertificateValidators;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        this.pkcs1.setPrivateKey(privateKey);
    }

    @Override
    public void setProvider(Provider provider) {
        this.pkcs1.setProvider(provider);
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        this.pkcs1.setPublicKey(publicKey);
    }

    private byte[] doSign(byte[] content) {
        return this.doSign(content, null);
    }

    private Collection<X509Certificate> getSignersCertificates(CMSSignedData previewSignerData) {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        Store certStore = previewSignerData.getCertificates();
        SignerInformationStore signers = previewSignerData.getSignerInfos();
        for (SignerInformation signer : signers.getSigners()) {
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certificateHolder = (X509CertificateHolder)certIt.next();
            try {
                result.add(new JcaX509CertificateConverter().getCertificate(certificateHolder));
            }
            catch (CertificateException certificateException) {}
        }
        return result;
    }

    private byte[] doSign(byte[] content, byte[] previewSignature) {
        byte[] result;
        CMSSignedData cmsSignedData;
        SignerInfoGenerator signerInfoGenerator;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.certificateChain == null) {
            logger.error(cadesMessagesBundle.getString("error.certificate.null"));
            throw new SignerException(cadesMessagesBundle.getString("error.certificate.null"));
        }
        if (this.getPrivateKey() == null) {
            logger.error(cadesMessagesBundle.getString("error.privatekey.null"));
            throw new SignerException(cadesMessagesBundle.getString("error.privatekey.null"));
        }
        if (this.certificate == null && this.certificateChain != null && this.certificateChain.length > 0) {
            this.certificate = (X509Certificate)this.certificateChain[0];
        }
        this.certificateChain = CAManager.getInstance().getCertificateChainArray(this.certificate);
        if (this.certificateChain.length < 3) {
            throw new SignerException(cadesMessagesBundle.getString("error.no.ca", new Object[]{this.certificate.getIssuerDN()}));
        }
        Certificate[] certStore = new Certificate[]{};
        CMSSignedData cmsPreviewSignedData = null;
        if (previewSignature != null && previewSignature.length > 0) {
            try {
                cmsPreviewSignedData = new CMSSignedData((CMSProcessable)new CMSAbsentContent(), previewSignature);
            }
            catch (CMSException e) {
                logger.error(e.getMessage());
                throw new SignerException(e);
            }
            Collection<X509Certificate> previewCerts = this.getSignersCertificates(cmsPreviewSignedData);
            certStore = previewCerts.toArray(new Certificate[0]);
        }
        try {
            this.setCertificateManager(new CertificateManager(this.certificate));
        }
        catch (CertificateValidatorCRLException cvre) {
            logger.warn(cvre.getMessage());
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            config.setOnline(true);
            try {
                this.setCertificateManager(new CertificateManager(this.certificate));
            }
            catch (CertificateValidatorCRLException cvre1) {
                logger.error(cvre1.getMessage());
                throw new CertificateValidatorCRLException(cvre1.getMessage());
            }
        }
        ArrayList<AlgAndLength> listOfAlgAndLength = new ArrayList<AlgAndLength>();
        for (AlgAndLength algLength : this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getAlgorithmConstraintSet().getSignerAlgorithmConstraints().getAlgAndLengths()) {
            listOfAlgAndLength.add(algLength);
        }
        AlgAndLength algAndLength = null;
        if (this.pkcs1.getAlgorithm() != null) {
            String varSetedAlgorithmOID = AlgorithmNames.getOIDByAlgorithmName(this.pkcs1.getAlgorithm());
            for (AlgAndLength algLength : listOfAlgAndLength) {
                if (!algLength.getAlgID().getValue().equalsIgnoreCase(varSetedAlgorithmOID)) continue;
                algAndLength = algLength;
                SignerAlgorithmEnum varSignerAlgorithmEnum = SignerAlgorithmEnum.valueOf(this.pkcs1.getAlgorithm());
                String varOIDAlgorithmHash = varSignerAlgorithmEnum.getOIDAlgorithmHash();
                ObjectIdentifier varObjectIdentifier = this.signaturePolicy.getSignPolicyHashAlg().getAlgorithm();
                varObjectIdentifier.setValue(varOIDAlgorithmHash);
                AlgorithmIdentifier varAlgorithmIdentifier = this.signaturePolicy.getSignPolicyHashAlg();
                varAlgorithmIdentifier.setAlgorithm(varObjectIdentifier);
                this.signaturePolicy.setSignPolicyHashAlg(varAlgorithmIdentifier);
            }
        } else {
            algAndLength = (AlgAndLength)listOfAlgAndLength.get(1);
            this.pkcs1.setAlgorithm(AlgorithmNames.getAlgorithmNameByOID(algAndLength.getAlgID().getValue()));
            SignerAlgorithmEnum varSignerAlgorithmEnum = SignerAlgorithmEnum.valueOf(this.pkcs1.getAlgorithm());
            String varOIDAlgorithmHash = varSignerAlgorithmEnum.getOIDAlgorithmHash();
            ObjectIdentifier varObjectIdentifier = this.signaturePolicy.getSignPolicyHashAlg().getAlgorithm();
            varObjectIdentifier.setValue(varOIDAlgorithmHash);
            AlgorithmIdentifier varAlgorithmIdentifier = this.signaturePolicy.getSignPolicyHashAlg();
            varAlgorithmIdentifier.setAlgorithm(varObjectIdentifier);
            this.signaturePolicy.setSignPolicyHashAlg(varAlgorithmIdentifier);
        }
        if (algAndLength == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.no.algorithm.policy"));
        }
        logger.debug(cadesMessagesBundle.getString("info.algorithm.id", new Object[]{algAndLength.getAlgID().getValue()}));
        logger.debug(cadesMessagesBundle.getString("info.algorithm.name", new Object[]{AlgorithmNames.getAlgorithmNameByOID(algAndLength.getAlgID().getValue())}));
        logger.debug(cadesMessagesBundle.getString("info.min.key.length", new Object[]{algAndLength.getMinKeyLength()}));
        logger.debug(cadesMessagesBundle.getString("info.validating.key.length"));
        int keyLegth = ((RSAKey)((Object)this.certificate.getPublicKey())).getModulus().bitLength();
        if (keyLegth < algAndLength.getMinKeyLength()) {
            throw new SignerException(cadesMessagesBundle.getString("error.min.key.length", new Object[]{algAndLength.getMinKeyLength().toString(), keyLegth}));
        }
        AttributeFactory attributeFactory = AttributeFactory.getInstance();
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        if (this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedSignedAttr().getObjectIdentifiers() != null) {
            for (ObjectIdentifier objectIdentifier : this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedSignedAttr().getObjectIdentifiers()) {
                SignedOrUnsignedAttribute signedOrUnsignedAttribute = attributeFactory.factory(objectIdentifier.getValue());
                signedOrUnsignedAttribute.initialize(this.pkcs1.getPrivateKey(), this.certificateChain, content, this.signaturePolicy, this.hash);
                signedAttributes.add((ASN1Encodable)signedOrUnsignedAttribute.getValue());
            }
        }
        AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
        Object signedAttributeGenerator = this.isPades() ? new SimpleAttributeTableGenerator(signedAttributesTable) : new DefaultSignedAttributeTableGenerator(signedAttributesTable);
        HashSet<X509Certificate> trustedCAs = new HashSet<X509Certificate>();
        Collection ctp = this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSigningCertTrustCondition().getSignerTrustTrees().getCertificateTrustPoints();
        for (Certificate[] certificateTrustPoint : ctp) {
            logger.debug(cadesMessagesBundle.getString("info.trust.point", new Object[]{certificateTrustPoint.getTrustpoint().getSubjectDN().toString()}));
            trustedCAs.add(certificateTrustPoint.getTrustpoint());
        }
        HashSet<X509Certificate> certificateChainTrusted = new HashSet<X509Certificate>();
        for (Certificate certCA : this.certificateChain) {
            certificateChainTrusted.add((X509Certificate)certCA);
        }
        X509Certificate rootOfCertificate = null;
        for (X509Certificate tcac : certificateChainTrusted) {
            logger.debug(tcac.getIssuerDN().toString());
            if (!CAManager.getInstance().isRootCA(tcac)) continue;
            rootOfCertificate = tcac;
        }
        if (trustedCAs.contains(rootOfCertificate)) {
            logger.debug(cadesMessagesBundle.getString("info.trust.in.point", new Object[]{rootOfCertificate.getSubjectDN()}));
        } else {
            logger.debug(cadesMessagesBundle.getString("info.trust.poin.homolog"));
            CAManager.getInstance().validateRootCAs(certificateChainTrusted, this.certificate);
        }
        logger.debug(cadesMessagesBundle.getString("info.policy.valid.period"));
        PolicyValidator pv = new PolicyValidator(this.signaturePolicy, this.policyName);
        pv.validate();
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            gen.addCertificates(this.generatedCertStore(certStore));
        }
        catch (CMSException e) {
            logger.error(e.getMessage());
            throw new SignerException(e);
        }
        String algorithmOID = algAndLength.getAlgID().getValue();
        logger.debug(cadesMessagesBundle.getString("info.algorithm.id", new Object[]{algorithmOID}));
        try {
            signerInfoGenerator = new JcaSimpleSignerInfoGeneratorBuilder().setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator).setUnsignedAttributeGenerator(null).build(AlgorithmNames.getAlgorithmNameByOID(algorithmOID), this.pkcs1.getPrivateKey(), this.certificate);
        }
        catch (CertificateEncodingException | OperatorCreationException e) {
            logger.error(e.getMessage());
            throw new SignerException(e);
        }
        gen.addSignerInfoGenerator(signerInfoGenerator);
        Object cmsTypedData = content == null ? new CMSAbsentContent() : new CMSProcessableByteArray(content);
        try {
            cmsSignedData = gen.generate((CMSTypedData)cmsTypedData, this.attached);
        }
        catch (CMSException e) {
            logger.error(e.getMessage());
            throw new SignerException(e);
        }
        this.setAttached(false);
        ASN1EncodableVector unsignedAttributes = new ASN1EncodableVector();
        logger.debug(cadesMessagesBundle.getString("info.unsigned.attribute"));
        Collection vNewSigners = cmsSignedData.getSignerInfos().getSigners();
        Iterator it = vNewSigners.iterator();
        SignerInformation oSi = (SignerInformation)it.next();
        if (this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers() != null) {
            for (ObjectIdentifier objectIdentifier : this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers()) {
                SignedOrUnsignedAttribute signedOrUnsignedAttribute = attributeFactory.factory(objectIdentifier.getValue());
                switch (signedOrUnsignedAttribute.getOID()) {
                    case "1.2.840.113549.1.9.16.2.14": {
                        Certificate[] varCertificateChainTimeStamp;
                        logger.debug("TimeStampToken");
                        PrivateKey pkForTimeStamp = this.pkcs1.getPrivateKeyForTimeStamp();
                        if (pkForTimeStamp == null) {
                            pkForTimeStamp = this.pkcs1.getPrivateKey();
                        }
                        varCertificateChainTimeStamp = (varCertificateChainTimeStamp = this.certificateChainTimeStamp) == null || varCertificateChainTimeStamp.length < 1 ? this.certificateChain : CAManager.getInstance().getCertificateChainArray((X509Certificate)varCertificateChainTimeStamp[0]);
                        signedOrUnsignedAttribute.initialize(pkForTimeStamp, varCertificateChainTimeStamp, oSi.getSignature(), this.signaturePolicy, this.hash);
                        break;
                    }
                    case "1.2.840.113549.1.9.16.2.25": {
                        logger.debug("ets_escTimeStamp");
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        try {
                            Certificate[] varCertificateChainEscTimeStamp;
                            outputStream.write(oSi.getSignature());
                            AttributeTable varUnsignedAttributes = oSi.getUnsignedAttributes();
                            Attribute varAttribute = varUnsignedAttributes.get(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.getId()));
                            outputStream.write(varAttribute.getAttrType().getEncoded());
                            outputStream.write(varAttribute.getAttrValues().getEncoded());
                            varAttribute = varUnsignedAttributes.get(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.id_aa_ets_certificateRefs.getId()));
                            outputStream.write(varAttribute.getAttrType().getEncoded());
                            outputStream.write(varAttribute.getAttrValues().getEncoded());
                            varAttribute = varUnsignedAttributes.get(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.id_aa_ets_revocationRefs.getId()));
                            outputStream.write(varAttribute.getAttrType().getEncoded());
                            outputStream.write(varAttribute.getAttrValues().getEncoded());
                            this.escTimeStampContent = outputStream.toByteArray();
                            PrivateKey pkForEscTimeStamp = this.pkcs1.getPrivateKeyForTimeStamp();
                            if (pkForEscTimeStamp == null) {
                                pkForEscTimeStamp = this.pkcs1.getPrivateKey();
                            }
                            varCertificateChainEscTimeStamp = (varCertificateChainEscTimeStamp = this.certificateChainTimeStamp) == null || varCertificateChainEscTimeStamp.length < 1 ? this.certificateChain : CAManager.getInstance().getCertificateChainArray((X509Certificate)varCertificateChainEscTimeStamp[0]);
                            signedOrUnsignedAttribute.initialize(pkForEscTimeStamp, varCertificateChainEscTimeStamp, this.escTimeStampContent, this.signaturePolicy, this.hash);
                            break;
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                            throw new SignerException(e);
                        }
                    }
                    default: {
                        signedOrUnsignedAttribute.initialize(this.pkcs1.getPrivateKey(), this.certificateChain, oSi.getSignature(), this.signaturePolicy, this.hash);
                    }
                }
                unsignedAttributes.add((ASN1Encodable)signedOrUnsignedAttribute.getValue());
                AttributeTable unsignedAttributesTable = new AttributeTable(unsignedAttributes);
                vNewSigners.remove(oSi);
                oSi = SignerInformation.replaceUnsignedAttributes((SignerInformation)oSi, (AttributeTable)unsignedAttributesTable);
                vNewSigners.add(oSi);
            }
        }
        if (previewSignature != null && previewSignature.length > 0) {
            vNewSigners.addAll(cmsPreviewSignedData.getSignerInfos().getSigners());
        }
        SignerInformationStore oNewSignerInformationStore = new SignerInformationStore(vNewSigners);
        CMSSignedData oSignedData = cmsSignedData;
        cmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)oSignedData, (SignerInformationStore)oNewSignerInformationStore);
        try {
            result = cmsSignedData.getEncoded();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new SignerException(e);
        }
        String SN = this.certificate.getSerialNumber().toString() + "(" + this.certificate.getSerialNumber().toString(16).toUpperCase() + ")";
        logger.debug(cadesMessagesBundle.getString("info.signed.by", new Object[]{this.certificate.getSubjectDN().toString().split(",")[0], SN}));
        this.setSignatory(this.certificate.getSubjectDN().toString().split(",")[0] + " " + SN);
        PeriodValidator pV = new PeriodValidator();
        this.setNotAfterSignerCertificate(pV.valDate(this.certificate));
        return result;
    }

    @Override
    public void setSignaturePolicy(PolicyFactory.Policies signaturePolicy) {
        SignaturePolicy sp;
        this.setPolicyName(signaturePolicy.name());
        PolicyFactory policyFactory = PolicyFactory.getInstance();
        this.signaturePolicy = sp = policyFactory.loadPolicy(signaturePolicy);
    }

    @Override
    public byte[] doAttachedSign(byte[] content) {
        this.setAttached(true);
        return this.doSign(content);
    }

    @Override
    public byte[] doDetachedSign(byte[] content) {
        return this.doSign(content);
    }

    @Override
    public byte[] doAttachedSign(byte[] content, byte[] previewSigned) {
        this.setAttached(true);
        return this.doSign(content, previewSigned);
    }

    @Override
    public byte[] doDetachedSign(byte[] content, byte[] previewSigned) {
        return this.doSign(content, previewSigned);
    }

    private CMSSignedData updateWithCounterSignature(CMSSignedData counterSignature, CMSSignedData originalSignature, SignerId selector) {
        SignerInformationStore originalSignerInfos = originalSignature.getSignerInfos();
        SignerInformationStore signerInfos = counterSignature.getSignerInfos();
        originalSignature.getSignerInfos().get(selector);
        SignerInformation updatedSI = SignerInformation.addCounterSigners((SignerInformation)originalSignerInfos.get(selector), (SignerInformationStore)signerInfos);
        ArrayList<SignerInformation> counterSignatureInformationCollection = new ArrayList<SignerInformation>();
        counterSignatureInformationCollection.add(updatedSI);
        SignerInformationStore signerInformationStore = new SignerInformationStore(counterSignatureInformationCollection);
        return CMSSignedData.replaceSigners((CMSSignedData)originalSignature, (SignerInformationStore)signerInformationStore);
    }

    @Override
    public byte[] doCounterSign(byte[] previewCMSSignature) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CMSSignedData cmsPreviewSignedData = new CMSSignedData(previewCMSSignature);
            Collection previewSigners = cmsPreviewSignedData.getSignerInfos().getSigners();
            for (SignerInformation previewSigner : previewSigners) {
                byte[] previewSignatureFromSigner = previewSigner.getSignature();
                CMSSignedData cmsCounterSignedData = new CMSSignedData(this.doSign(previewSignatureFromSigner));
                cmsPreviewSignedData = this.updateWithCounterSignature(cmsCounterSignedData, cmsPreviewSignedData, previewSigner.getSID());
            }
            return cmsPreviewSignedData.getEncoded();
        }
        catch (Throwable error) {
            throw new SignerException(error);
        }
    }

    @Override
    public byte[] doHashSign(byte[] hash) {
        this.hash = hash;
        return this.doSign(null);
    }

    @Override
    public byte[] doHashCoSign(byte[] hash, byte[] previewSigned) {
        this.hash = hash;
        return this.doSign(null, previewSigned);
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public CertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
    }

    public boolean isPades() {
        return this.pades;
    }

    public void setPades(boolean pades) {
        this.pades = pades;
    }

    @Override
    public Date getNotAfterSignerCertificate() {
        return this.notAfterSignerCertificate;
    }

    public void setNotAfterSignerCertificate(Date notAfterSignerCertificate) {
        this.notAfterSignerCertificate = notAfterSignerCertificate;
    }

    @Override
    public void setCertificatesForTimeStamp(Certificate[] certificates) {
        this.certificateChainTimeStamp = certificates;
    }

    @Override
    public void setPrivateKeyForTimeStamp(PrivateKey privateKeyForTimeStamp) {
        this.pkcs1.setPrivateKeyForTimeStamp(privateKeyForTimeStamp);
    }

    @Override
    public PrivateKey getPrivateKeyForTimeStamp() {
        return this.pkcs1.getPrivateKeyForTimeStamp();
    }

    @Override
    public String getSignatory() {
        return this.signatory;
    }

    public void setSignatory(String signatory) {
        this.signatory = signatory;
    }
}

