/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.UnsignedAttribute;

public class CertValues
implements UnsignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_ets_certValues;
    private java.security.cert.Certificate[] certificates = null;

    @Override
    public void initialize(PrivateKey privateKey, java.security.cert.Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.certificates = certificates;
    }

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() throws SignerException {
        ArrayList<Certificate> certificateValues = new ArrayList<Certificate>();
        try {
            int chainSize = this.certificates.length - 1;
            for (int i = 0; i < chainSize; ++i) {
                X509Certificate cert = (X509Certificate)this.certificates[i];
                byte[] data = cert.getEncoded();
                certificateValues.add(Certificate.getInstance((Object)data));
            }
            Certificate[] certValuesArray = new Certificate[certificateValues.size()];
            return new Attribute(this.identifier, (ASN1Set)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable[])certificateValues.toArray(certValuesArray))));
        }
        catch (CertificateEncodingException e) {
            throw new SignerException(e.getMessage());
        }
    }
}

