/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs1.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs1.PKCS1Signer;

public class PKCS1SignerImpl
implements PKCS1Signer {
    private Provider provider = null;
    private PrivateKey privateKey = null;
    private String algorithm = SignerAlgorithmEnum.SHA512withRSA.getAlgorithm();
    private PublicKey publicKey = null;
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();
    private PrivateKey privateKeyForTimeStamp = null;

    private byte[] doSign(byte[] content) {
        if (content == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.value.null"));
        }
        if (this.privateKey == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.private.key.null"));
        }
        if (this.algorithm == null) {
            this.algorithm = SignerAlgorithmEnum.DEFAULT.getAlgorithm();
        }
        Signature sign = null;
        byte[] result = null;
        try {
            sign = this.provider != null ? Signature.getInstance(this.algorithm, this.provider) : Signature.getInstance(this.algorithm);
            sign.initSign(this.privateKey);
            sign.update(content);
            result = sign.sign();
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.load.algorithm", new Object[]{this.algorithm}), exception);
        }
        catch (InvalidKeyException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.private.key.invalid"), exception);
        }
        catch (SignatureException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.sign.exception"), exception);
        }
        return result;
    }

    public boolean check(byte[] content, byte[] signed) {
        if (content == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.value.null"));
        }
        if (signed == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.content.signed.null"));
        }
        if (this.publicKey == null) {
            throw new SignerException(cadesMessagesBundle.getString("error.public.key.null"));
        }
        if (this.algorithm == null) {
            this.algorithm = SignerAlgorithmEnum.DEFAULT.getAlgorithm();
        }
        Signature signature = null;
        boolean result = false;
        try {
            signature = this.provider != null ? Signature.getInstance(this.algorithm, this.provider) : Signature.getInstance(this.algorithm);
            signature.initVerify(this.publicKey);
            signature.update(content);
            result = signature.verify(signed);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.load.algorithm", new Object[]{this.algorithm}), exception);
        }
        catch (InvalidKeyException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.public.key.invalid"), exception);
        }
        catch (SignatureException exception) {
            throw new SignerException(cadesMessagesBundle.getString("error.check.exception"), exception);
        }
        return result;
    }

    @Override
    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setAlgorithm(SignerAlgorithmEnum algorithm) {
        this.algorithm = algorithm.getAlgorithm();
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] doAttachedSign(byte[] content) {
        return this.doSign(content);
    }

    @Override
    public byte[] doDetachedSign(byte[] content) {
        return this.doSign(content);
    }

    @Override
    public byte[] doHashSign(byte[] hash) {
        return null;
    }

    public boolean checkAttached(byte[] signedData) {
        return false;
    }

    public List<SignatureInformations> checkSignatureByHash(String digestAlgorithm, byte[] calculatedHashContent, byte[] signedData) {
        return null;
    }

    public List<SignatureInformations> checkAttachedSignature(byte[] signedData) {
        return null;
    }

    @Override
    public void setPrivateKeyForTimeStamp(PrivateKey privateKeyToTimeStamp) {
        this.privateKeyForTimeStamp = privateKeyToTimeStamp;
    }

    @Override
    public PrivateKey getPrivateKeyForTimeStamp() {
        return this.privateKeyForTimeStamp;
    }

    @Override
    public Date getNotAfterSignerCertificate() {
        return null;
    }

    @Override
    public String getSignatory() {
        return null;
    }
}

