/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.metadata;

import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.metadata.AbstractExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;

public class UnaryMetadata
extends AbstractExpressionMetadata {
    protected ExpressionMetadata expr;

    public UnaryMetadata(ExpressionType expressionType, ExpressionMetadata expr) {
        super(expressionType);
        if (expressionType != ExpressionType.MUST && expressionType != ExpressionType.NOT && expressionType != ExpressionType.MINUS && expressionType != ExpressionType.PAREN) {
            throw new IllegalArgumentException("Invalid expression type!");
        }
        Validate.notNull((Object)expr, (String)"expr is null!", (Object[])new Object[0]);
        this.expr = expr;
    }

    public ExpressionMetadata getExpr() {
        return this.expr;
    }

    public String toString() {
        String op = "+";
        if (this.expressionType == ExpressionType.NOT) {
            op = "!";
        } else if (this.expressionType == ExpressionType.MINUS) {
            op = "-";
        } else if (this.expressionType == ExpressionType.PAREN) {
            if (this.boost == 1) {
                return String.format("(%s)", this.expr.toString());
            }
            return String.format("(%s)^%d", this.expr.toString(), this.boost);
        }
        if (this.boost == 1) {
            return String.format("%s%s", op, this.expr.toString());
        }
        return String.format("%s%s^%d", op, this.expr.toString(), this.boost);
    }
}

