/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.metadata;

import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.metadata.AbstractExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;

public class SuffixMetadata
extends AbstractExpressionMetadata {
    protected ExpressionMetadata expr;
    protected Number number;

    public SuffixMetadata(ExpressionType expressionType, Number number) {
        super(expressionType);
        if (expressionType == ExpressionType.PROXIMITY) {
            if (number != null && !(number instanceof Integer)) {
                throw new IllegalArgumentException("Invalid format! Number should be unsigned integer!");
            }
            if (number.intValue() < 0) {
                throw new IllegalArgumentException("Invalid format! Number should be bigger than 1!");
            }
        } else if (expressionType == ExpressionType.FUZZY) {
            if (number != null && (number.doubleValue() <= 0.0 || number.doubleValue() > 1.0)) {
                throw new IllegalArgumentException("Invalid format! Number should be (0,1]!");
            }
        } else {
            throw new IllegalArgumentException("Invalid expression type!");
        }
        this.number = number;
    }

    public ExpressionMetadata getExpr() {
        return this.expr;
    }

    public void setExpr(ExpressionMetadata expr) {
        Validate.notNull((Object)expr, (String)"expr is null!", (Object[])new Object[0]);
        this.expr = expr;
    }

    public Number getNumber() {
        return this.number;
    }

    public String toString() {
        String op = "~";
        StringBuffer sbuf = new StringBuffer();
        if (this.expr != null) {
            sbuf.append(this.expr.toString());
        }
        sbuf.append(op);
        if (this.number != null) {
            sbuf.append(this.number.toString());
        }
        if (this.boost != 1) {
            sbuf.append("^");
            sbuf.append(this.boost);
        }
        return sbuf.toString();
    }
}

