/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.metadata;

import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.metadata.AbstractExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;

public class RangeMetadata
extends AbstractExpressionMetadata {
    protected boolean lInclude = false;
    protected boolean rInclude = false;
    protected ExpressionMetadata lExpr;
    protected ExpressionMetadata rExpr;

    public RangeMetadata(boolean lInclude, ExpressionMetadata lExpr, ExpressionMetadata rExpr, boolean rInclude) {
        super(ExpressionType.RANGE);
        Validate.notNull((Object)lExpr, (String)"lExpr is null!", (Object[])new Object[0]);
        Validate.notNull((Object)rExpr, (String)"rExpr is null!", (Object[])new Object[0]);
        this.lExpr = lExpr;
        this.rExpr = rExpr;
    }

    public boolean islInclude() {
        return this.lInclude;
    }

    public boolean isrInclude() {
        return this.rInclude;
    }

    public ExpressionMetadata getlExpr() {
        return this.lExpr;
    }

    public ExpressionMetadata getrExpr() {
        return this.rExpr;
    }

    public String toString() {
        String l = "[";
        String r = "]";
        if (!this.lInclude) {
            l = "{";
        }
        if (this.rInclude) {
            r = "}";
        }
        if (this.boost == 1) {
            return String.format("%s%s,%s%s", l, this.lExpr.toString(), this.rExpr.toString(), r);
        }
        return String.format("%s%s,%s%s^%d", l, this.lExpr.toString(), this.rExpr.toString(), r, this.boost);
    }
}

