/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.comparator;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.comparator.BaseColumnComparator;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"columnType", "schema", "columnIdx"})
public class NumericalColumnComparator
extends BaseColumnComparator {
    private ColumnType columnType;
    private boolean ascending;

    public NumericalColumnComparator(String columnName) {
        this(columnName, true);
    }

    public NumericalColumnComparator(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="ascending") boolean ascending) {
        super(columnName);
        this.ascending = ascending;
    }

    @Override
    public void setSchema(Schema sequenceSchema) {
        super.setSchema(sequenceSchema);
        this.columnType = sequenceSchema.getType(this.columnIdx);
        switch (this.columnType) {
            case Integer: 
            case Long: 
            case Double: 
            case Time: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot apply numerical column comparator on column of type " + (Object)((Object)this.columnType));
            }
        }
    }

    @Override
    protected int compare(Writable w1, Writable w2) {
        int compare;
        switch (this.columnType) {
            case Integer: {
                compare = Integer.compare(w1.toInt(), w2.toInt());
                break;
            }
            case Long: 
            case Time: {
                compare = Long.compare(w1.toLong(), w2.toLong());
                break;
            }
            case Double: {
                compare = Double.compare(w1.toDouble(), w2.toDouble());
                break;
            }
            default: {
                throw new RuntimeException("Cannot apply numerical column comparator on column of type " + (Object)((Object)this.columnType));
            }
        }
        if (this.ascending) {
            return compare;
        }
        return -compare;
    }

    @Override
    public String toString() {
        return "NumericalColumnComparator(columnName=\"" + this.columnName + "\",ascending=" + this.ascending + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericalColumnComparator)) {
            return false;
        }
        NumericalColumnComparator other = (NumericalColumnComparator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isAscending() == other.isAscending();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumericalColumnComparator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAscending() ? 79 : 97);
        return result;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

