/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.widgets.AlertPanel;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.uberfire.mvp.Command;

@Dependent
public class AlertPanelView
extends Composite
implements AlertPanel.View {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    Alert alert;
    @UiField
    Button okButton;
    @UiField
    Button cancelButton;
    AlertPanel presenter;
    Map<AlertType, String> pflyIconMap = new HashMap<AlertType, String>();

    public void init(AlertPanel presenter) {
        this.presenter = presenter;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.pflyIconMap.put(AlertType.SUCCESS, "pficon-ok");
        this.pflyIconMap.put(AlertType.INFO, "pficon-info");
        this.pflyIconMap.put(AlertType.WARNING, "pficon-warning-triangle-o");
        this.pflyIconMap.put(AlertType.DANGER, "pficon-error-circle-o");
        this.pflyIconMap.put(AlertType.DEFAULT, "pficon-info");
    }

    @Override
    public void show(AlertType severity, String message, Integer width, final Command onOk, final Command onCancel) {
        this.alert.setType(severity);
        this.alert.addStyleName("pficon");
        this.alert.addStyleName(this.pflyIconMap.get(severity));
        this.alert.setText("  " + message + "  ");
        if (width != null) {
            this.alert.setWidth(width + "px");
        }
        if (onOk != null) {
            this.okButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    onOk.execute();
                }
            });
        }
        if (onCancel != null) {
            this.cancelButton.setVisible(true);
            this.cancelButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    onCancel.execute();
                }
            });
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, AlertPanelView> {
    }
}

