/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.map;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.editor.map.MapEditor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;

@Dependent
public class MapEditorView
extends Composite
implements MapEditor.View {
    @UiField
    @Editor.Ignore
    HTMLPanel mainPanel;
    @UiField
    @Editor.Ignore
    ScrollPanel gridPanel;
    @UiField
    DataGrid<Map.Entry<String, String>> grid;
    @UiField
    @Editor.Ignore
    Button addButton;
    @UiField
    @Editor.Ignore
    Label errorLabel;
    private MapEditor presenter;

    @UiConstructor
    public MapEditorView() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi(this));
        this.addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MapEditorView.this.presenter.addEntry();
            }
        });
    }

    public void init(MapEditor presenter) {
        this.presenter = presenter;
    }

    @Override
    public MapEditor.View setEmptyText(String text) {
        this.grid.setEmptyTableWidget((Widget)new Label(text));
        return this;
    }

    @Override
    public MapEditor.View setAddText(String text) {
        this.addButton.setText(text);
        this.addButton.setTitle(text);
        return this;
    }

    @Override
    public MapEditor.View addTextColumn(final int columnIndex, String heading, boolean isSortable, int width) {
        Column<Map.Entry<String, String>, String> keyColumn = new Column<Map.Entry<String, String>, String>((Cell)new EditTextCell()){

            public String getValue(Map.Entry<String, String> object) {
                return MapEditorView.this.presenter.getValue(columnIndex, object);
            }
        };
        this.addColumn(keyColumn, columnIndex, heading, isSortable, width);
        return this;
    }

    @Override
    public MapEditor.View addButtonColumn(final int columnIndex, String header, int width) {
        Column<Map.Entry<String, String>, String> removeColumn = new Column<Map.Entry<String, String>, String>((Cell)new ButtonCell(IconType.MINUS, ButtonSize.EXTRA_SMALL)){

            public String getValue(Map.Entry<String, String> object) {
                return MapEditorView.this.presenter.getValue(columnIndex, object);
            }
        };
        this.addColumn(removeColumn, columnIndex, header, false, width);
        return this;
    }

    private void addColumn(Column<Map.Entry<String, String>, String> column, final int columnIndex, String header, boolean isSortable, int width) {
        column.setSortable(isSortable);
        column.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.grid.addColumn(column, header);
        this.grid.setColumnWidth(column, (double)width, Style.Unit.PCT);
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<Map.Entry<String, String>, String>(){

            public void update(int index, Map.Entry<String, String> object, String value) {
                MapEditorView.this.presenter.update(columnIndex, index, object, value);
            }
        });
    }

    @Override
    public MapEditor.View removeColumn(int index) {
        this.grid.removeColumn(index);
        return this;
    }

    @Override
    public MapEditor.View setRowCount(int count) {
        this.grid.setRowCount(count);
        return this;
    }

    @Override
    public MapEditor.View setData(List<Map.Entry<String, String>> data) {
        this.grid.setRowData(0, data);
        return this;
    }

    @Override
    public MapEditor.View showError(SafeHtml message) {
        Element element = this.errorLabel.getElement();
        element.setInnerText(message.asString());
        element.getStyle().setDisplay(Style.Display.INLINE);
        element.getStyle().setBorderColor("red");
        element.getStyle().setBorderStyle(Style.BorderStyle.SOLID);
        element.getStyle().setBorderWidth(1.0, Style.Unit.PX);
        this.errorLabel.setVisible(true);
        return this;
    }

    @Override
    public MapEditor.View clearError() {
        Element element = this.errorLabel.getElement();
        element.setInnerText("");
        element.getStyle().setDisplay(Style.Display.NONE);
        element.getStyle().setBorderWidth(0.0, Style.Unit.PX);
        this.errorLabel.setVisible(false);
        return this;
    }

    static interface Binder
    extends UiBinder<Widget, MapEditorView> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

