/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ToggleSwitchEditor
implements IsWidget,
LeafAttributeEditor<Boolean> {
    Event<ValueChangeEvent<Boolean>> valueChangeEvent;
    public View view;
    Boolean value;

    @Inject
    public ToggleSwitchEditor(View view, Event<ValueChangeEvent<Boolean>> valueChangeEvent) {
        this.view = view;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setEnabled(boolean isEnabled) {
        this.view.setEnabled(isEnabled);
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (error.getEditor() != this) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setValue(Boolean value) {
        this.value = value;
        this.view.setValue(value);
    }

    public Boolean getValue() {
        return this.value;
    }

    void onValueChanged(Boolean value) {
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        this.view.clearError();
        Boolean before = this.value;
        this.value = value;
        this.valueChangeEvent.fire(new ValueChangeEvent<Boolean>(this, before, this.value));
    }

    public static interface View
    extends UberView<ToggleSwitchEditor> {
        public View setValue(Boolean var1);

        public View setEnabled(Boolean var1);

        public View showError(SafeHtml var1);

        public View clearError();
    }
}

