/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.Utils;

class SchemeValidator {
    SchemeValidator() {
    }

    void validate(String scheme) {
        if (scheme == null) {
            throw Utils.newNPE("The scheme value must not be null.", new Object[0]);
        }
        if (scheme.isEmpty()) {
            throw Utils.newIAE("The scheme value must not be empty.", new Object[0]);
        }
        this.validateFirstCharacter(scheme);
        this.validateRemainingCharacters(scheme);
    }

    private void validateFirstCharacter(String scheme) {
        char c = scheme.charAt(0);
        if (!Utils.isAlphabet(c)) {
            throw Utils.newIAE("The scheme value \"%s\" has an invalid character \"%s\" at the index 0.", scheme, Character.valueOf(c));
        }
    }

    private void validateRemainingCharacters(String scheme) {
        for (int i = 1; i < scheme.length(); ++i) {
            char c = scheme.charAt(i);
            if (this.isValid(c)) continue;
            throw Utils.newIAE("The scheme value \"%s\" has an invalid character \"%s\" at the index %d.", scheme, Character.valueOf(c), i);
        }
    }

    private boolean isValid(char c) {
        return Utils.isAlphabet(c) || Utils.isDigit(c) || c == '+' || c == '-' || c == '.';
    }
}

