/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.czeal.rfc3986.Utils;

abstract class PercentEncodedStringProcessor {
    PercentEncodedStringProcessor() {
    }

    protected String process(String input, Charset charset, StringBuilder outputBuilder) {
        int currentIndex = 0;
        int lastIndex = input.length() - 1;
        Info info = new Info();
        while (currentIndex <= lastIndex) {
            char c = input.charAt(currentIndex);
            if (c == '%') {
                this.onPercent(input, charset, outputBuilder, currentIndex, lastIndex, info);
                currentIndex += 3;
                continue;
            }
            this.onNonPercent(input, outputBuilder, c, currentIndex);
            ++currentIndex;
        }
        return outputBuilder == null ? null : outputBuilder.toString();
    }

    private void onPercent(String input, Charset charset, StringBuilder outputBuilder, int currentIndex, int lastIndex, Info info) {
        if (currentIndex + 2 > lastIndex) {
            throw this.onMalformedPercentEncodedValue(input, currentIndex);
        }
        String percentEncodedValue = input.substring(currentIndex, currentIndex + 3);
        byte b = this.toByte(input, currentIndex + 1, currentIndex + 2);
        info.add(percentEncodedValue, b);
        int nextIndex = currentIndex + 3;
        if (nextIndex > lastIndex || input.charAt(nextIndex) != '%') {
            this.decode(input, charset, outputBuilder, info);
            info.reset();
        }
    }

    private byte toByte(String input, int higherHexDigitIndex, int lowerHexDigitIndex) {
        char higherHexDigit = input.charAt(higherHexDigitIndex);
        int intOfHigherHexDigit = this.toIntOfHexDigit(input, higherHexDigitIndex, higherHexDigit);
        char lowerHexDigit = input.charAt(lowerHexDigitIndex);
        int intOfLowerHexDigit = this.toIntOfHexDigit(input, lowerHexDigitIndex, lowerHexDigit);
        return (byte)((intOfHigherHexDigit << 4) + intOfLowerHexDigit);
    }

    private int toIntOfHexDigit(String input, int index, char hexDigit) {
        int intOfHexDigit = Utils.fromHexDigit(hexDigit);
        if (intOfHexDigit == -1) {
            throw this.onInvalidHexDigit(input, hexDigit, index);
        }
        return intOfHexDigit;
    }

    private void decode(String input, Charset charset, StringBuilder outputBuilder, Info info) {
        CharBuffer docodedCharBuffer;
        try {
            docodedCharBuffer = charset.newDecoder().decode(ByteBuffer.wrap(info.getByteArray()));
        }
        catch (CharacterCodingException e) {
            throw this.onDecodeFailed(input, info);
        }
        this.onDecoded(charset, outputBuilder, docodedCharBuffer);
    }

    protected abstract IllegalArgumentException onMalformedPercentEncodedValue(String var1, int var2);

    protected abstract IllegalArgumentException onInvalidHexDigit(String var1, char var2, int var3);

    protected abstract IllegalArgumentException onDecodeFailed(String var1, Info var2);

    protected abstract void onDecoded(Charset var1, StringBuilder var2, CharBuffer var3);

    protected abstract void onNonPercent(String var1, StringBuilder var2, char var3, int var4);

    protected static class Info {
        private StringBuffer sb = new StringBuffer();
        private ByteArrayOutputStream bs = new ByteArrayOutputStream();

        protected Info() {
        }

        void add(String percentEncodedValue, byte byteForPercentEncodedValue) {
            this.sb.append(percentEncodedValue);
            this.bs.write(byteForPercentEncodedValue);
        }

        String getString() {
            return this.sb.toString();
        }

        byte[] getByteArray() {
            return this.bs.toByteArray();
        }

        void reset() {
            this.sb.setLength(0);
            this.bs.reset();
        }
    }
}

