/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import org.czeal.rfc3986.HostType;
import org.czeal.rfc3986.Ipv4AddressValidator;
import org.czeal.rfc3986.Ipv6AddressValidator;
import org.czeal.rfc3986.IpvFutureValidator;
import org.czeal.rfc3986.RegNameValidator;
import org.czeal.rfc3986.Utils;

class HostTypeDeterminer {
    HostTypeDeterminer() {
    }

    HostType determine(String value, Charset charset) {
        if (value == null || value.isEmpty()) {
            return HostType.REGNAME;
        }
        if (value.startsWith("[")) {
            return this.determineHostTypeForIpLiteral(value);
        }
        try {
            new Ipv4AddressValidator().validate(value);
            return HostType.IPV4;
        }
        catch (Throwable t) {
            new RegNameValidator().validate(value, charset);
            return HostType.REGNAME;
        }
    }

    private HostType determineHostTypeForIpLiteral(String value) {
        if (!value.endsWith("]")) {
            throw Utils.newIAE("The host value \"%s\" start with \"[\" but doesn't end with \"]\".", value);
        }
        String enclosed = value.substring(1, value.length() - 1);
        try {
            new Ipv6AddressValidator().validate(enclosed);
            return HostType.IPV6;
        }
        catch (Throwable t) {
            new IpvFutureValidator().validate(enclosed);
            return HostType.IPVFUTURE;
        }
    }
}

