/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.wsclient.jsonsimple.JSONArray;

public final class JsonUtils {
    private JsonUtils() {
    }

    @CheckForNull
    public static String getString(Map obj, String field) {
        Object value = obj.get(field);
        if (value instanceof String || value instanceof Number) {
            return value.toString();
        }
        return null;
    }

    @CheckForNull
    public static Integer getInteger(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return ((Long)value).intValue();
        }
        return null;
    }

    @CheckForNull
    public static Boolean getBoolean(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (Boolean)value;
        }
        return null;
    }

    @CheckForNull
    public static Long getLong(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            return (Long)value;
        }
        return null;
    }

    @CheckForNull
    public static Double getDouble(Map obj, String field) {
        Object value = obj.get(field);
        if (value != null) {
            if (value instanceof Long) {
                return ((Long)value).doubleValue();
            }
            return (Double)value;
        }
        return null;
    }

    @CheckForNull
    public static JSONArray getArray(Map obj, String field) {
        return (JSONArray)obj.get(field);
    }

    @CheckForNull
    public static Date getDateTime(Map obj, String field) {
        return JsonUtils.parseDate(obj, field, "yyyy-MM-dd'T'HH:mm:ssZ");
    }

    @CheckForNull
    public static Date getDate(Map obj, String field) {
        return JsonUtils.parseDate(obj, field, "yyyy-MM-dd");
    }

    @CheckForNull
    private static Date parseDate(Map obj, String field, String format) {
        String value = JsonUtils.getString(obj, field);
        if (value != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                return dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Fail to parse date property '" + field + "': " + format, e);
            }
        }
        return null;
    }
}

