/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Rule;

public class RuleQuery
extends Query<Rule> {
    public static final String BASE_URL = "/api/rules";
    private String language;
    private String[] repositories;
    private String searchText;
    private String profile;
    private String[] severities;
    private Boolean active;

    public RuleQuery(String language) {
        this.language = language;
    }

    public RuleQuery setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public RuleQuery setRepositories(String ... s) {
        this.repositories = s;
        return this;
    }

    public String[] getRepositories() {
        return this.repositories;
    }

    public RuleQuery setSearchText(String searchText) {
        this.searchText = searchText;
        return this;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public RuleQuery setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public RuleQuery setSeverities(String ... severities) {
        this.severities = severities;
        return this;
    }

    public String[] getSeverities() {
        return this.severities;
    }

    public RuleQuery setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public Boolean getStatus() {
        return this.active;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        RuleQuery.appendUrlParameter(url, "language", this.language);
        RuleQuery.appendUrlParameter(url, "plugins", this.repositories);
        RuleQuery.appendUrlParameter(url, "searchtext", this.searchText);
        RuleQuery.appendUrlParameter(url, "profile", this.profile);
        RuleQuery.appendUrlParameter(url, "priorities", this.severities);
        if (this.active != null) {
            RuleQuery.appendUrlParameter(url, "status", this.active != false ? "ACTIVE" : "INACTIVE");
        }
        return url.toString();
    }

    @Override
    public Class<Rule> getModelClass() {
        return Rule.class;
    }
}

