/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Property;
import org.sonar.wsclient.services.Query;

public class PropertyQuery
extends Query<Property> {
    public static final String BASE_URL = "/api/properties";
    private String key = null;
    private String resourceKeyOrId = null;

    public String getKey() {
        return this.key;
    }

    public PropertyQuery setKey(String key) {
        this.key = key;
        return this;
    }

    public String getResourceKeyOrId() {
        return this.resourceKeyOrId;
    }

    public PropertyQuery setResourceKeyOrId(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        if (this.key != null) {
            url.append("/").append(PropertyQuery.encode(this.key));
        }
        url.append('?');
        PropertyQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        return url.toString();
    }

    @Override
    public Class<Property> getModelClass() {
        return Property.class;
    }

    public static PropertyQuery createForAll() {
        return new PropertyQuery();
    }

    public static PropertyQuery createForKey(String key) {
        return new PropertyQuery().setKey(key);
    }

    public static PropertyQuery createForResource(String key, String resourceKeyOrId) {
        return new PropertyQuery().setKey(key).setResourceKeyOrId(resourceKeyOrId);
    }
}

