/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.rule.internal;

import java.util.HashMap;
import java.util.Map;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.rule.RuleClient;

public class DefaultRuleClient
implements RuleClient {
    private static final String ROOT_URL = "/api/rules";
    private static final String ADD_TAGS_URL = "/api/rules/add_tags";
    private static final String REMOVE_TAGS_URL = "/api/rules/remove_tags";
    private final HttpRequestFactory requestFactory;

    public DefaultRuleClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public void addTags(String key, String ... tags) {
        this.requestFactory.post(ADD_TAGS_URL, this.buildQueryParams(key, tags));
    }

    @Override
    public void removeTags(String key, String ... tags) {
        this.requestFactory.post(REMOVE_TAGS_URL, this.buildQueryParams(key, tags));
    }

    private Map<String, Object> buildQueryParams(String key, String ... tags) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", key);
        StringBuilder tagsBuilder = new StringBuilder();
        for (int i = 0; i < tags.length - 1; ++i) {
            tagsBuilder.append(tags[i]).append(",");
        }
        tagsBuilder.append(tags[tags.length - 1]);
        params.put("tags", tagsBuilder.toString());
        return params;
    }
}

