/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.qualitygate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.jsonsimple.JSONValue;
import org.sonar.wsclient.qualitygate.NewCondition;
import org.sonar.wsclient.qualitygate.QualityGate;
import org.sonar.wsclient.qualitygate.QualityGateClient;
import org.sonar.wsclient.qualitygate.QualityGateCondition;
import org.sonar.wsclient.qualitygate.QualityGateDetails;
import org.sonar.wsclient.qualitygate.QualityGates;
import org.sonar.wsclient.qualitygate.UpdateCondition;
import org.sonar.wsclient.qualitygate.internal.DefaultQualityGate;
import org.sonar.wsclient.qualitygate.internal.DefaultQualityGateCondition;
import org.sonar.wsclient.qualitygate.internal.DefaultQualityGateDetails;
import org.sonar.wsclient.qualitygate.internal.DefaultQualityGates;

public class DefaultQualityGateClient
implements QualityGateClient {
    private static final String ROOT_URL = "/api/qualitygates";
    private static final String LIST_URL = "/api/qualitygates/list";
    private static final String SHOW_URL = "/api/qualitygates/show";
    private static final String CREATE_URL = "/api/qualitygates/create";
    private static final String CREATE_CONDITION_URL = "/api/qualitygates/create_condition";
    private static final String UPDATE_CONDITION_URL = "/api/qualitygates/update_condition";
    private static final String DELETE_CONDITION_URL = "/api/qualitygates/delete_condition";
    private static final String RENAME_URL = "/api/qualitygates/rename";
    private static final String DESTROY_URL = "/api/qualitygates/destroy";
    private static final String SET_DEFAULT_URL = "/api/qualitygates/set_as_default";
    private static final String UNSET_DEFAULT_URL = "/api/qualitygates/unset_default";
    private static final String SELECT_URL = "/api/qualitygates/select";
    private static final String DESELECT_URL = "/api/qualitygates/deselect";
    private final HttpRequestFactory requestFactory;

    public DefaultQualityGateClient(HttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public QualityGates list() {
        String json = this.requestFactory.get(LIST_URL, Collections.<String, Object>emptyMap());
        return this.jsonToQualityGates(json);
    }

    @Override
    public QualityGate create(String qGateName) {
        String json = this.requestFactory.post(CREATE_URL, Collections.singletonMap("name", qGateName));
        return this.jsonToQualityGate(json);
    }

    @Override
    public QualityGate rename(long qGateId, String qGateName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", qGateId);
        params.put("name", qGateName);
        String json = this.requestFactory.post(RENAME_URL, params);
        return this.jsonToQualityGate(json);
    }

    @Override
    public QualityGateDetails show(long qGateId) {
        String json = this.requestFactory.get(SHOW_URL, Collections.singletonMap("id", qGateId));
        return this.jsonToDetails(json);
    }

    @Override
    public QualityGateDetails show(String qGateName) {
        String json = this.requestFactory.get(SHOW_URL, Collections.singletonMap("name", qGateName));
        return this.jsonToDetails(json);
    }

    @Override
    public QualityGateCondition createCondition(NewCondition condition) {
        String json = this.requestFactory.post(CREATE_CONDITION_URL, condition.urlParams());
        return this.jsonToCondition(json);
    }

    @Override
    public QualityGateCondition updateCondition(UpdateCondition condition) {
        String json = this.requestFactory.post(UPDATE_CONDITION_URL, condition.urlParams());
        return this.jsonToCondition(json);
    }

    @Override
    public void deleteCondition(long conditionId) {
        this.requestFactory.post(DELETE_CONDITION_URL, Collections.singletonMap("id", conditionId));
    }

    @Override
    public void destroy(long qGateId) {
        this.requestFactory.post(DESTROY_URL, Collections.singletonMap("id", qGateId));
    }

    @Override
    public void setDefault(long qGateId) {
        this.requestFactory.post(SET_DEFAULT_URL, Collections.singletonMap("id", qGateId));
    }

    @Override
    public void unsetDefault() {
        this.requestFactory.post(UNSET_DEFAULT_URL, Collections.<String, Object>emptyMap());
    }

    @Override
    public void selectProject(long qGateId, long projectId) {
        this.requestFactory.post(SELECT_URL, this.selectionParams(qGateId, projectId));
    }

    @Override
    public void deselectProject(long qGateId, long projectId) {
        this.requestFactory.post(DESELECT_URL, this.selectionParams(qGateId, projectId));
    }

    private Map<String, Object> selectionParams(long qGateId, long projectId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gateId", Long.toString(qGateId));
        params.put("projectId", Long.toString(projectId));
        return params;
    }

    private QualityGate jsonToQualityGate(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultQualityGate(jsonRoot);
    }

    private QualityGates jsonToQualityGates(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultQualityGates(jsonRoot);
    }

    private QualityGateDetails jsonToDetails(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        return new DefaultQualityGateDetails(jsonRoot, this.jsonToConditions(json));
    }

    private Collection<QualityGateCondition> jsonToConditions(String json) {
        Map jsonRoot = (Map)JSONValue.parse(json);
        Collection conditionArray = (Collection)jsonRoot.get("conditions");
        ArrayList<QualityGateCondition> conditions = new ArrayList<QualityGateCondition>();
        if (conditionArray != null) {
            for (Map conditionJson : conditionArray) {
                conditions.add(new DefaultQualityGateCondition(conditionJson));
            }
        }
        return conditions;
    }

    private DefaultQualityGateCondition jsonToCondition(String json) {
        return new DefaultQualityGateCondition((Map)JSONValue.parse(json));
    }
}

