/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.issue.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.wsclient.base.Paging;
import org.sonar.wsclient.component.Component;
import org.sonar.wsclient.issue.ActionPlan;
import org.sonar.wsclient.issue.Issue;
import org.sonar.wsclient.issue.Issues;
import org.sonar.wsclient.rule.Rule;
import org.sonar.wsclient.user.User;

public class DefaultIssues
implements Issues {
    private final List<Issue> list = new ArrayList<Issue>();
    private final Map<String, Rule> rulesByKey = new HashMap<String, Rule>();
    private final Map<String, User> usersByKey = new HashMap<String, User>();
    private final Map<Long, Component> componentsById = new HashMap<Long, Component>();
    private final Map<String, Component> projectsByKey = new HashMap<String, Component>();
    private final Map<String, ActionPlan> actionPlansByKey = new HashMap<String, ActionPlan>();
    private Paging paging;
    private Boolean maxResultsReached;

    @Override
    public List<Issue> list() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Collection<Rule> rules() {
        return this.rulesByKey.values();
    }

    @Override
    public Rule rule(Issue issue) {
        return this.rulesByKey.get(issue.ruleKey());
    }

    @Override
    public Collection<User> users() {
        return this.usersByKey.values();
    }

    @Override
    @CheckForNull
    public User user(String login) {
        return this.usersByKey.get(login);
    }

    @Override
    public Collection<Component> components() {
        return this.componentsById.values();
    }

    @Override
    @CheckForNull
    public Component component(Issue issue) {
        return this.componentsById.get(issue.componentId());
    }

    @Override
    @CheckForNull
    public Component componentById(long id) {
        return this.componentsById.get(id);
    }

    @Override
    public Collection<Component> projects() {
        return this.projectsByKey.values();
    }

    @Override
    @CheckForNull
    public Component project(Issue issue) {
        return this.projectsByKey.get(issue.projectKey());
    }

    @Override
    public Collection<ActionPlan> actionPlans() {
        return this.actionPlansByKey.values();
    }

    @Override
    @CheckForNull
    public ActionPlan actionPlans(Issue issue) {
        return this.actionPlansByKey.get(issue.actionPlan());
    }

    @Override
    public Paging paging() {
        return this.paging;
    }

    @Override
    @Nullable
    public Boolean maxResultsReached() {
        return this.maxResultsReached;
    }

    DefaultIssues add(Issue issue) {
        this.list.add(issue);
        return this;
    }

    DefaultIssues add(Rule rule) {
        this.rulesByKey.put(rule.key(), rule);
        return this;
    }

    DefaultIssues add(User user) {
        this.usersByKey.put(user.login(), user);
        return this;
    }

    DefaultIssues add(ActionPlan actionPlan) {
        this.actionPlansByKey.put(actionPlan.key(), actionPlan);
        return this;
    }

    DefaultIssues addComponent(Component c) {
        this.componentsById.put(c.id(), c);
        return this;
    }

    DefaultIssues addProject(Component c) {
        this.projectsByKey.put(c.key(), c);
        return this;
    }

    DefaultIssues setPaging(Paging paging) {
        this.paging = paging;
        return this;
    }

    DefaultIssues setMaxResultsReached(@Nullable Boolean maxResultsReached) {
        this.maxResultsReached = maxResultsReached;
        return this;
    }
}

