/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.internal;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.wsclient.base.HttpException;
import org.sonar.wsclient.kevinsawicki.HttpRequest;

public class HttpRequestFactory {
    private static final int[] RESPONSE_SUCCESS = new int[]{200, 201, 204};
    private final String baseUrl;
    private String login;
    private String password;
    private String proxyHost;
    private String proxyLogin;
    private String proxyPassword;
    private int proxyPort;
    private int connectTimeoutInMilliseconds;
    private int readTimeoutInMilliseconds;

    public HttpRequestFactory(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public HttpRequestFactory setLogin(@Nullable String login) {
        this.login = login;
        return this;
    }

    public HttpRequestFactory setPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    public HttpRequestFactory setProxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public HttpRequestFactory setProxyLogin(@Nullable String proxyLogin) {
        this.proxyLogin = proxyLogin;
        return this;
    }

    public HttpRequestFactory setProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public HttpRequestFactory setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public HttpRequestFactory setConnectTimeoutInMilliseconds(int connectTimeoutInMilliseconds) {
        this.connectTimeoutInMilliseconds = connectTimeoutInMilliseconds;
        return this;
    }

    public HttpRequestFactory setReadTimeoutInMilliseconds(int readTimeoutInMilliseconds) {
        this.readTimeoutInMilliseconds = readTimeoutInMilliseconds;
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyLogin() {
        return this.proxyLogin;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getConnectTimeoutInMilliseconds() {
        return this.connectTimeoutInMilliseconds;
    }

    public int getReadTimeoutInMilliseconds() {
        return this.readTimeoutInMilliseconds;
    }

    public String get(String wsUrl, Map<String, Object> queryParams) {
        HttpRequest request = this.prepare(HttpRequest.get((CharSequence)(this.baseUrl + wsUrl), queryParams, true));
        return this.execute(request);
    }

    public String post(String wsUrl, Map<String, Object> queryParams) {
        HttpRequest request = this.prepare(HttpRequest.post((CharSequence)(this.baseUrl + wsUrl), true, new Object[0])).form(queryParams, "UTF-8");
        return this.execute(request);
    }

    private String execute(HttpRequest request) {
        try {
            if (this.isSuccess(request)) {
                return request.body("UTF-8");
            }
            throw new HttpException(request.url().toString(), request.code());
        }
        catch (HttpRequest.HttpRequestException e) {
            throw new IllegalStateException("Fail to request " + request.url(), e.getCause());
        }
    }

    private boolean isSuccess(HttpRequest request) {
        return Arrays.binarySearch(RESPONSE_SUCCESS, request.code()) >= 0;
    }

    private HttpRequest prepare(HttpRequest request) {
        if (this.proxyHost != null) {
            request.useProxy(this.proxyHost, this.proxyPort);
            if (this.proxyLogin != null) {
                request.proxyBasic(this.proxyLogin, this.proxyPassword);
            }
        }
        request.acceptGzipEncoding().uncompress(true).acceptJson().acceptCharset("UTF-8").connectTimeout(this.connectTimeoutInMilliseconds).readTimeout(this.readTimeoutInMilliseconds).trustAllCerts().trustAllHosts();
        if (this.login != null) {
            request.basic(this.login, this.password);
        }
        return request;
    }
}

